/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ElisionFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware,
MultiTermAwareComponent {
    private CharArraySet articles;

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String articlesFile = (String)this.args.get("articles");
        boolean ignoreCase = this.getBoolean("ignoreCase", false);
        if (articlesFile != null) {
            this.articles = this.getWordSet(loader, articlesFile, ignoreCase);
        }
        if (this.articles == null) {
            this.articles = FrenchAnalyzer.DEFAULT_ARTICLES;
        }
    }

    @Override
    public ElisionFilter create(TokenStream input) {
        return new ElisionFilter(input, this.articles);
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        return this;
    }
}

