/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ShingleFilterFactory
extends TokenFilterFactory {
    private int minShingleSize;
    private int maxShingleSize;
    private boolean outputUnigrams;
    private boolean outputUnigramsIfNoShingles;
    private String tokenSeparator;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.maxShingleSize = this.getInt("maxShingleSize", 2);
        if (this.maxShingleSize < 2) {
            throw new IllegalArgumentException("Invalid maxShingleSize (" + this.maxShingleSize + ") - must be at least 2");
        }
        this.minShingleSize = this.getInt("minShingleSize", 2);
        if (this.minShingleSize < 2) {
            throw new IllegalArgumentException("Invalid minShingleSize (" + this.minShingleSize + ") - must be at least 2");
        }
        if (this.minShingleSize > this.maxShingleSize) {
            throw new IllegalArgumentException("Invalid minShingleSize (" + this.minShingleSize + ") - must be no greater than maxShingleSize (" + this.maxShingleSize + ")");
        }
        this.outputUnigrams = this.getBoolean("outputUnigrams", true);
        this.outputUnigramsIfNoShingles = this.getBoolean("outputUnigramsIfNoShingles", false);
        this.tokenSeparator = args.containsKey("tokenSeparator") ? args.get("tokenSeparator") : " ";
    }

    @Override
    public ShingleFilter create(TokenStream input) {
        ShingleFilter r = new ShingleFilter(input, this.minShingleSize, this.maxShingleSize);
        r.setOutputUnigrams(this.outputUnigrams);
        r.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
        r.setTokenSeparator(this.tokenSeparator);
        return r;
    }
}

