/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.IOUtils;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet dictionary;
    private HyphenationTree hyphenator;
    private String dictFile;
    private String hypFile;
    private String encoding;
    private int minWordSize;
    private int minSubwordSize;
    private int maxSubwordSize;
    private boolean onlyLongestMatch;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.assureMatchVersion();
        this.dictFile = args.get("dictionary");
        if (args.containsKey("encoding")) {
            this.encoding = args.get("encoding");
        }
        this.hypFile = args.get("hyphenator");
        if (null == this.hypFile) {
            throw new IllegalArgumentException("Missing required parameter: hyphenator");
        }
        this.minWordSize = this.getInt("minWordSize", 5);
        this.minSubwordSize = this.getInt("minSubwordSize", 2);
        this.maxSubwordSize = this.getInt("maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean("onlyLongestMatch", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        InputStream stream = null;
        try {
            if (this.dictFile != null) {
                this.dictionary = this.getWordSet(loader, this.dictFile, false);
            }
            stream = loader.openResource(this.hypFile);
            InputSource is = new InputSource(stream);
            is.setEncoding(this.encoding);
            is.setSystemId(this.hypFile);
            this.hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(stream);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(stream);
    }

    @Override
    public HyphenationCompoundWordTokenFilter create(TokenStream input) {
        return new HyphenationCompoundWordTokenFilter(this.luceneMatchVersion, input, this.hyphenator, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

