/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.TransliterationRuleSet;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeMatcher;
import com.ibm.icu.text.UnicodeReplacer;
import com.ibm.icu.text.UnicodeSet;
import java.util.Hashtable;

public class RuleBasedTransliterator
extends Transliterator {
    private Data data;

    RuleBasedTransliterator(String ID2, Data data, UnicodeFilter filter) {
        super(ID2, filter);
        this.data = data;
        this.setMaximumContextLength(data.ruleSet.getMaximumContextLength());
    }

    protected synchronized void handleTransliterate(Replaceable text, Transliterator.Position index, boolean incremental) {
        int loopCount = 0;
        int loopLimit = index.limit - index.start << 4;
        if (loopLimit < 0) {
            loopLimit = Integer.MAX_VALUE;
        }
        while (index.start < index.limit && loopCount <= loopLimit && this.data.ruleSet.transliterate(text, index, incremental)) {
            ++loopCount;
        }
    }

    public String toRules(boolean escapeUnprintable) {
        return this.data.ruleSet.toRules(escapeUnprintable);
    }

    protected UnicodeSet handleGetSourceSet() {
        return this.data.ruleSet.getSourceTargetSet(false);
    }

    public UnicodeSet getTargetSet() {
        return this.data.ruleSet.getSourceTargetSet(true);
    }

    static class Data {
        public TransliterationRuleSet ruleSet;
        Hashtable variableNames = new Hashtable();
        Object[] variables;
        char variablesBase;

        public Data() {
            this.ruleSet = new TransliterationRuleSet();
        }

        public UnicodeMatcher lookupMatcher(int standIn) {
            int i = standIn - this.variablesBase;
            return i >= 0 && i < this.variables.length ? (UnicodeMatcher)this.variables[i] : null;
        }

        public UnicodeReplacer lookupReplacer(int standIn) {
            int i = standIn - this.variablesBase;
            return i >= 0 && i < this.variables.length ? (UnicodeReplacer)this.variables[i] : null;
        }
    }
}

