/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;
import org.musicbrainz.search.index.Utils;

public class CommonTables {
    private static final String ENGLISH_ISO_CODE = "en";
    protected Connection dbConnection;
    private List<String> indexesToBeBuilt;

    public CommonTables(Connection dbConnection, String indexToBeBuilt) {
        this.dbConnection = dbConnection;
        this.indexesToBeBuilt = new ArrayList<String>();
        this.indexesToBeBuilt.add(indexToBeBuilt);
    }

    public CommonTables(Connection dbConnection, List<String> indexesToBeBuilt) {
        this.dbConnection = dbConnection;
        this.indexesToBeBuilt = indexesToBeBuilt;
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    private void createArtistCreditTableUsingDb() throws SQLException {
        System.out.println("tmp_artistcredit:Started at:" + Utils.formatCurrentTimeForOutput());
        StopWatch clock = new StopWatch();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE TEMPORARY TABLE tmp_artistcredit AS SELECT acn.artist_credit as artist_credit,   acn.position as pos,   acn.join_phrase as joinphrase,   a.gid as artistId,    a.comment as comment,   an.name as artistName,   an2.name as artistCreditName,   an3.name as artistSortName,   aa1.aliasName  FROM artist_credit_name acn    INNER JOIN artist a ON a.id=acn.artist   INNER JOIN artist_name an ON a.name=an.id   INNER JOIN artist_name an2 ON acn.name=an2.id   INNER JOIN artist_name an3 ON a.sort_name=an3.id   LEFT JOIN ( SELECT aa.artist, MAX(an4.name) AS aliasName FROM     artist_alias aa      INNER JOIN artist_name an4 ON aa.name=an4.id      WHERE aa.locale='en'     GROUP BY aa.artist) AS aa1     ON a.id=aa1.artist  ORDER BY acn.artist_credit,acn.position ");
        clock.stop();
        System.out.println("tmp_artistcredit:Finished:" + Utils.formatClock(clock));
        clock.reset();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE INDEX tmp_artistcredit_idx ON tmp_artistcredit (artist_credit) ");
        clock.stop();
        System.out.println("tmp_artistcredit:Created Indexes:" + Utils.formatClock(clock));
        clock.reset();
    }

    private void createReleasePuidTableUsingDb() throws SQLException {
        System.out.println("tmp_release_puid:Started at:" + Utils.formatCurrentTimeForOutput());
        StopWatch clock = new StopWatch();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE TEMPORARY TABLE tmp_release_puid AS   SELECT m.release, rp.recording, p.puid   FROM medium m     INNER JOIN track t ON t.medium = m.id     INNER JOIN recording_puid rp ON rp.recording = t.recording     INNER JOIN puid p ON rp.puid = p.id");
        clock.stop();
        System.out.println("tmp_release_puid:Finished:" + Utils.formatClock(clock));
        clock.reset();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE INDEX tmp_release_puid_idx_release ON tmp_release_puid (release) ");
        this.getDbConnection().createStatement().execute("CREATE INDEX tmp_release_puid_idx_recording ON tmp_release_puid (recording) ");
        clock.stop();
        System.out.println("tmp_release_puid:Created Indexes:" + Utils.formatClock(clock));
        clock.reset();
    }

    private void createReleaseTableUsingDb() throws SQLException {
        System.out.println("tmp_release     :Started at:" + Utils.formatCurrentTimeForOutput());
        StopWatch clock = new StopWatch();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE TEMPORARY TABLE tmp_release AS SELECT r.id, r.gid, rn.name as name,   barcode,   rgt.name as type, rg.id as rg_id, rg.gid as rg_gid, rm.amazon_asin,   language.iso_code_3 as language, language.iso_code_2t as language_2t, script.iso_code as script, rs.name as status,   sum(m.track_count) as tracks,  r.artist_credit,  r.comment FROM release r   LEFT JOIN release_meta rm ON r.id = rm.id   LEFT JOIN release_group rg ON rg.id = r.release_group   LEFT JOIN release_group_primary_type rgt  ON rg.type = rgt.id   LEFT JOIN release_name rn ON r.name = rn.id   LEFT JOIN release_status rs ON r.status = rs.id   LEFT JOIN language ON r.language=language.id   LEFT JOIN script ON r.script=script.id   LEFT JOIN medium m ON m.release=r.id GROUP BY r.id,r.gid,rn.name,barcode,rgt.name,rg.id, rg.gid,  rm.amazon_asin, language.iso_code_3, language.iso_code_2t, script.iso_code,rs.name,r.artist_credit, r.comment");
        clock.stop();
        System.out.println("tmp_release     :Finished:" + Utils.formatClock(clock));
        clock.reset();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE INDEX tmp_release_idx_release ON tmp_release (id) ");
        clock.stop();
        System.out.println("tmp_release     :Created Indexes:" + Utils.formatClock(clock));
        clock.reset();
    }

    private void createReleaseEventsTableUsingDb() throws SQLException {
        System.out.println("tmp_release_event     :Started at:" + Utils.formatCurrentTimeForOutput());
        StopWatch clock = new StopWatch();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE TEMPORARY TABLE tmp_release_event AS  SELECT r1.release, r2.code as country,   r1.date_year, r1.date_month, r1.date_day,  a1.gid as gid, a1.name as name, a1.sort_name as sort_name FROM release_country r1  LEFT JOIN area a1  ON r1.country = a1.id LEFT JOIN iso_3166_1 r2  ON a1.id = r2.area  UNION SELECT release, null as country,   date_year, date_month, date_day,  null as gid, null as name, null as sort_name FROM release_unknown_country r1 ");
        clock.stop();
        System.out.println("tmp_release_event     :Finished:" + Utils.formatClock(clock));
        clock.reset();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE INDEX tmp_release_event_idx_release ON tmp_release_event (release) ");
        clock.stop();
        System.out.println("tmp_release_event     :Created Indexes:" + Utils.formatClock(clock));
        clock.reset();
    }

    private void createTrackTableUsingDb() throws SQLException {
        System.out.println("tmp_track       :Started at:" + Utils.formatCurrentTimeForOutput());
        StopWatch clock = new StopWatch();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE TEMPORARY TABLE tmp_track AS SELECT t.id, t.gid, t.recording, t.length, tn.name as track_name, t.position as track_position, t.number as track_number, m.track_count,   m.release as release_id, m.position as medium_position, mf.name as format  FROM track t   INNER JOIN track_name tn ON t.name=tn.id  INNER JOIN medium m ON t.medium=m.id   LEFT JOIN  medium_format mf ON m.format=mf.id ");
        clock.stop();
        System.out.println("tmp_track       :Finished:" + Utils.formatClock(clock));
        clock.reset();
        clock.start();
        this.getDbConnection().createStatement().execute("CREATE INDEX tmp_track_idx_recording ON tmp_track (recording) ");
        clock.stop();
        System.out.println("tmp_track       :Created Indexes" + Utils.formatClock(clock));
        clock.reset();
    }

    public void createTemporaryTables(boolean isUpdater) throws SQLException {
        if (this.indexesToBeBuilt.contains("release") || this.indexesToBeBuilt.contains("releasegroup") || this.indexesToBeBuilt.contains("recording")) {
            this.createArtistCreditTableUsingDb();
        }
        if (this.indexesToBeBuilt.contains("release") || this.indexesToBeBuilt.contains("recording")) {
            if (!isUpdater) {
                this.createReleasePuidTableUsingDb();
            }
            this.createReleaseTableUsingDb();
            this.createReleaseEventsTableUsingDb();
        }
        if (this.indexesToBeBuilt.contains("recording") && !isUpdater) {
            this.createTrackTableUsingDb();
        }
    }
}

