/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.musicbrainz.search.analysis.UnaccentData;
import org.musicbrainz.search.analysis.UnaccentIndexes;
import org.musicbrainz.search.analysis.UnaccentPositions;

public class AccentFilter
extends TokenFilter {
    private char[] output = new char[256];
    private int outputPos;
    private CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);

    public AccentFilter(TokenStream input) {
        super(input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        int length;
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] buffer = this.termAttr.buffer();
        if (this.removeAccents(buffer, length = this.termAttr.length())) {
            this.termAttr.copyBuffer(this.output, 0, this.outputPos);
        }
        return true;
    }

    protected final boolean removeAccents(char[] input, int length) {
        int size;
        int maxSizeNeeded = 2 * length;
        for (size = this.output.length; size < maxSizeNeeded; size *= 2) {
        }
        int inputPos = 0;
        this.outputPos = 0;
        for (int i = 0; i < length; ++i) {
            char c = input[i];
            short block = UnaccentIndexes.indexes[c >> 5];
            short[] positions = UnaccentPositions.positions[block];
            int position = c & 0x1F;
            short unacPosition = positions[position];
            int unacLength = positions[position + 1] - unacPosition;
            if (unacLength <= 0) continue;
            if (size != this.output.length) {
                this.output = new char[size];
            }
            if (inputPos < i) {
                System.arraycopy(input, inputPos, this.output, this.outputPos, i - inputPos);
                this.outputPos += i - inputPos;
            }
            System.arraycopy(UnaccentData.data[block], unacPosition, this.output, this.outputPos, unacLength);
            this.outputPos += unacLength;
            inputPos = i + 1;
        }
        if (inputPos == 0) {
            return false;
        }
        int copyLength = length - inputPos;
        if (copyLength > 0) {
            System.arraycopy(input, inputPos, this.output, this.outputPos, copyLength);
            this.outputPos += copyLength;
        }
        return true;
    }
}

