\name{ScalarToRGBColormapImageFilter}
\alias{ScalarToRGBColormapImageFilter}
\title{ScalarToRGBColormapImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements pixel-wise intensity->rgb mapping operation on one image.
ScalarToRGBColormapImageFilter}
\details{
This class is parameterized over the type of the input image and the
type of the output image.
The input image's scalar pixel values are mapped into a color map. The
color map is specified by passing the SetColormap function one of the
predefined maps. The following selects the
"RGBColormapFilterEnum::Hot" colormap:
You can also specify a custom color map. This is done by creating a
CustomColormapFunction, and then creating lists of values for the red,
green, and blue channel. An example of setting the red channel of a
colormap with only 2 colors is given below. The blue and green
channels should be specified in the same manner.
The range of values present in the input image is the range that is
mapped to the entire range of colors.
This code was contributed in the Insight Journal paper: "Meeting Andy
Warhol Somewhere Over the Rainbow: RGB Colormapping and ITK" by
Tustison N., Zhang H., Lehmann G., Yushkevich P., Gee J. https://www.insight-journal.org/browse/publication/285
See:
BinaryFunctionImageFilter TernaryFunctionImageFilter
ScalarToRGBColormap for the procedural interface
itk::ScalarToRGBColormapImageFilter for the Doxygen on the original ITK class.
ScalarToRGBColormapImageFilter}
%C++ includes: sitkScalarToRGBColormapImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ColormapType GetColormap() const:}{
Set/Get the colormap object.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseInputImageExtremaForScaling() const:}{
Set/Get UseInputImageExtremaForScaling. If true, the colormap uses the
min and max values from the image to scale appropriately. Otherwise,
these values can be set in the colormap manually.
}
\item{ ScalarToRGBColormapImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetColormap(ColormapType Colormap):}{}
\item{Self SetUseInputImageExtremaForScaling(bool UseInputImageExtremaForScaling):}{
Set/Get UseInputImageExtremaForScaling. If true, the colormap uses the
min and max values from the image to scale appropriately. Otherwise,
these values can be set in the colormap manually.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseInputImageExtremaForScalingOff():}{}
\item{Self UseInputImageExtremaForScalingOn():}{
Set the value of UseInputImageExtremaForScaling to true or false
respectfully.
}
\item{ ~ScalarToRGBColormapImageFilter():}{
Destructor
}
}
}
