/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Throwables;

public class ShouldNotBeInstance
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldNotBeInstance(Object actual, Class<?> type) {
        ShouldNotBeInstance shouldNotBeInstance;
        if (actual instanceof Throwable) {
            Throwable throwable = (Throwable)actual;
            shouldNotBeInstance = new ShouldNotBeInstance(throwable, type);
        } else {
            shouldNotBeInstance = new ShouldNotBeInstance(actual, type);
        }
        return shouldNotBeInstance;
    }

    private ShouldNotBeInstance(Object actual, Class<?> type) {
        super("%nExpecting actual:%n  %s%nnot to be an instance of: %s", actual, type);
    }

    private ShouldNotBeInstance(Throwable throwable, Class<?> type) {
        super("%nExpecting actual:%n  %s%nnot to be an instance of: %s", Throwables.getStackTrace(throwable), type);
    }
}

