/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.SName;

class USymbolRectangle
extends USymbol {
    private final SName sname;

    public USymbolRectangle(SName sname) {
        this.sname = sname;
    }

    @Override
    public SName[] getSNames() {
        return new SName[]{this.sname};
    }

    private void drawRect(UGraphic ug, double width, double height, double shadowing, double roundCorner, double diagonalCorner) {
        URectangle rect = URectangle.build(width, height);
        Shadowable shape = diagonalCorner > 0.0 ? rect.diagonalCorner(diagonalCorner) : rect.rounded(roundCorner);
        shape.setDeltaShadow(shadowing);
        ug.draw(shape);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolRectangle this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                this.this$0.drawRect(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner(), symbolContext.getDiagonalCorner());
                USymbol.Margin margin = this.this$0.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return this.this$0.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, final HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolRectangle this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                this.this$0.drawRect(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner(), symbolContext.getDiagonalCorner());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (stereoAlignment == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - this.this$0.getMargin().getX1() / 2.0;
                    posStereoY = this.this$0.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = labelAlignment == HorizontalAlignment.LEFT ? 3.0 : (labelAlignment == HorizontalAlignment.RIGHT ? width - dimTitle.getWidth() - 3.0 : (width - dimTitle.getWidth()) / 2.0);
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

