/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.util.Objects;
import lombok.NonNull;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.CircuitBreakerManager;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCacheItem;
import org.opensearch.neuralsearch.sparse.cache.MemMonitoredCache;
import org.opensearch.neuralsearch.sparse.cache.MemoryUsageManager;
import org.opensearch.neuralsearch.sparse.cache.RamBytesRecorder;

public class ForwardIndexCache
extends MemMonitoredCache<ForwardIndexCacheItem> {
    private static volatile ForwardIndexCache INSTANCE;

    protected ForwardIndexCache() {
        MemoryUsageManager.getInstance().getMemoryUsageTracker().recordWithoutValidation(RamUsageEstimator.shallowSizeOf((Object)this.cacheMap), CircuitBreakerManager::addWithoutBreaking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ForwardIndexCache getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ForwardIndexCache> clazz = ForwardIndexCache.class;
        synchronized (ForwardIndexCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ForwardIndexCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @NonNull
    public ForwardIndexCacheItem getOrCreate(@NonNull CacheKey key, int docCount) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        RamBytesRecorder globalRecorder = MemoryUsageManager.getInstance().getMemoryUsageTracker();
        return super.getOrCreate(key, k -> new ForwardIndexCacheItem((CacheKey)k, docCount, globalRecorder));
    }
}

