{
 **********************************************************************
  This file is part of LazUtils.
  It is copied and modified from a file in Free Component Library.

  See the file COPYING.FPC, included in this distribution,
  for details about the license.
 **********************************************************************

  XML naming character tables, built upon w3.org specifications

}

type
  TSetOfByte = set of Byte;

const
// colon ($3a) is excluded, it is handled in the code
  ns_ASCII = [{ $3A,} $41..$5A, $5F, $61..$7A, $C0..$D6, $D8..$F6, $F8..$FF];
  ns_0200  = [0..$17, $50..$A8, $BB..$C1];
  ns_0300  = [$86, $88..$8A, $8C, $8E..$A1,
              $A3..$CE, $D0..$D6, $DA, $DC,
              $DE, $E0, $E2..$F3];
  ns_0400  = [$01..$0C, $0E..$4F, $51..$5C,
              $5E..$81, $90..$C4, $C7..$C8,
              $CB..$CC, $D0..$EB, $EE..$F5,
              $F8..$F9];
  ns_0500  = [$31..$56, $59, $61..$86, $D0..$EA, $F0..$F2];
  ns_0600  = [$21..$3A, $41..$4A, $71..$B7,
              $BA..$BE, $C0..$CE, $D0..$D3,
              $D5, $E5..$E6];
  ns_0900  = [$05..$39, $3D, $58..$61,
              $85..$8C, $8F..$90, $93..$A8,
              $AA..$B0, $B2, $B6..$B9,
              $DC..$DD, $DF..$E1, $F0..$F1];
  ns_0A00  = [$05..$0A, $0F..$10, $13..$28,
              $2A..$30, $32..$33, $35..$36,
              $38..$39, $59..$5C, $5E, $72..$74,
              $85..$8B, $8D, $8F..$91, $93..$A8,
              $AA..$B0, $B2..$B3, $B5..$B9, $BD, $E0];
  ns_0B00  = [$05..$0C, $0F..$10, $13..$28,
              $2A..$30, $32..$33, $36..$39,
              $3D, $5C..$5D, $5F..$61, $85..$8A,
              $8E..$90, $92..$95, $99..$9A,
              $9C, $9E..$9F, $A3..$A4, $A8..$AA,
              $AE..$B5, $B7..$B9];
  ns_0C00  = [$05..$0C, $0E..$10, $12..$28,
              $2A..$33, $35..$39, $60..$61,
              $85..$8C, $8E..$90, $92..$A8,
              $AA..$B3, $B5..$B9, $DE, $E0..$E1];
  ns_0D00  = [$05..$0C, $0E..$10, $12..$28, $2A..$39, $60..$61];
  ns_0E00  = [$01..$2E, $30, $32..$33, $40..$45,
              $81..$82, $84, $87..$88, $8A, $8D,
              $94..$97, $99..$9F, $A1..$A3,
              $A5, $A7, $AA..$AB, $AD..$AE,
              $B0, $B2..$B3, $BD, $C0..$C4];
  ns_0F00  = [$40..$47, $49..$69];

  ns_3000  = [$41..$94, $A1..$FA] + [$07, $21..$29];

  namingBitmap: array[0..$30] of TSetOfByte = (

  [],                              // 00 - nothing allowed
  [0..255],                        // 01 - all allowed
  ns_ASCII,                        // 02
  [0..$31, $34..$3E, $41..$48,     // 03 - $0100, both Name and NameStart
   $4A..$7E, $80..$C3, $CD..$F0,
   $F4..$F5, $FA..$FF],

  ns_0200,                  // 04
  ns_0300,                  // 05
  ns_0400,                  // 06
  ns_0500,                  // 07
  ns_0600,                  // 08
  ns_0900,                  // 09
  ns_0A00,                  // 0A
  ns_0B00,                  // 0B
  ns_0C00,                  // 0C
  ns_0D00,                  // 0D
  ns_0E00,                  // 0E
  ns_0F00,                  // 0F
  [$A0..$C5, $D0..$F6],            // 10 - $1000, both Name and NameStart
  [0, $02..03, $05..$07, $09,      // 11 - $1100, both Name and NameStart
   $0B..$0C, $0E..$12, $3C, $3E,
   $40, $4C, $4E, $50, $54..$55,
   $59, $5F..$61, $63, $65, $67,
   $69, $6D..$6E, $72..$73, $75,
   $9E, $A8, $AB, $AE..$AF,
   $B7..$B8, $BA, $BC..$C2, $EB, $F0, $F9],
  [0..$9B, $A0..$F9],              // 12 - $1E00, both Name and NameStart
  [0..$15, $18..$1D, $20..$45,     // 13 - $1F00, both Name and NameStart
   $48..$4D, $50..$57, $59, $5B, $5D,
   $5F..$7D, $80..$B4, $B6..$BC, $BE,
   $C2..$C4, $C6..$CC, $D0..$D3,
   $D6..$DB, $E0..$EC, $F2..$F4, $F6..$FC],
  [$26, $2A..$2B, $2E, $80..$82],  // 14 - $2100, NameStart
  ns_3000,                         // 15
  [$05..$2C],                      // 16 - $3100, NameStart
  [0..$A5],                        // 17 - $9F00, NameStart (ideographs)
  [0..$A3],                        // 18 - $D700, NameStart

  ns_ASCII +                       // 19 - $0000, Names
    [$2D..$2E, $30..$39, $B7],
  ns_0200 +                        // 1A - $0200, Names
    [$D0..$D1],
  ns_0300 +                        // 1B - $0300, Names
    [0..$45, $60..$61, $87],
  ns_0400 +                        // 1C - $0400, Names
    [$83..$86],
  ns_0500 +                        // 1D - $0500, Names
    [$91..$A1, $A3..$B9, $BB..$BD,         { combining }
    $BF, $C1..$C2, $C4],
  ns_0600 +                        // 1E - $0600, Names
    [$4B..$52, $70, $D6..$DC, $DD..$DF,    { combining }
     $E0..$E4, $E7..$E8, $EA..$ED] +
    [$60..$69, $F0..$F9] + [$40],          { digits + ext }
  ns_0900 +                        // 1F - $0900, Names
    [$01..$03, $3C, $3E..$4C, $4D,         { combining }
     $51..$54, $62..$63, $81..$83,
     $BC, $BE, $BF, $C0..$C4, $C7..$C8,
     $CB..$CD, $D7, $E2..$E3] +
     [$66..$6F, $E6..$EF],                 { digits }
  ns_0A00 +                        // 20 - $0A00, Names
  [$02, $3C, $3E..$42, $47..$48, $4B..$4D, { combining }
   $70..$71, $81..$83, $BC, $BE..$C5,
   $C7..$C9, $CB..$CD] +
  [$66..$6F, $E6..$EF],                    { digits }
  ns_0B00 +                        // 21 - $0B00, Names
  [$01..$03, $3C, $3E..$43, $47..$48,      { combining }
   $4B..$4D, $56..$57, $82..$83, $BE..$C2,
   $C6..$C8, $CA..$CD, $D7] +
  [$66..$6F, $E7..$EF],                    { digits }
  ns_0C00 +                        // 22 - $0C00, Names
    [$01..$03, $3E..$44, $46..$48,        { combining }
     $4A..$4D, $55..$56, $82..$83,
     $BE..$C4, $C6..$C8, $CA..$CD, $D5..$D6] +
    [$66..$6F, $E6..$EF],                { digits }
  ns_0D00 +                        // 23 - $0D00, Names
    [$02..$03, $3E..$43,                { combining }
     $46..$48, $4A..$4D, $57] +
    [$66..$6F],                         { digits }
  ns_0E00 +                        // 24 - $0E00, Names
    [$31, $34..$3A, $47..$4E,           { combining }
     $B1, $B4..$B9, $BB..$BC,
     $C8..$CD] +
    [$50..$59, $D0..$D9] +              { digits }
    [$46, $C6],                         { extenders }
  ns_0F00 +                        // 25 - $0F00, Names
    [$18..$19, $35, $37, $39,           { combining }
     $3E, $3F, $71..$84, $86..$8B,
     $90..$95, $97, $99..$AD,
     $B1..$B7, $B9] +
    [$20..$29],                         { digits }
    [$D0..$DC, $E1],               // 26 - $2000, Names (combining)
  ns_3000 +                        // 27 - $3000, Names
    [$2A..$2F, $99, $9A] +               { combining }
    [$05, $31..$35, $9D..$9E, $FC..$FE], { extenders }

{ XML 1.1 additions }

  [0..$CF, $F0..$FF],              // 28 $FD00 - NameStart
  [0..$EF],                        // 29 $2F00 - NameStart
  [$0C..$0D, $70..$FF],            // 2A $2000 - NameStart
  [0..$8F],                        // 2B $2100 - NameStart
  [$70..$7D, $7F..$FF],            // 2C $0300 - NameStart
  [1..$FF],                        // 2D $3000 - NameStart
  [0..$7D, $7F..$FF],              // 2E $0300 - Names
  [$0C..$0D, $3F..$40, $70..$FF],  // 2F $2000 - Names
  [$00..$FD]                       // 30 $FF00 - both Name and NameStart
);

  Xml11HighPages: TSetOfByte = [0..$21, $2C..$D7, $F9..$FE];

  NamePages: array[0..511] of Byte = (
$02, $03, $04, $05, $06, $07, $08, $00,
$00, $09, $0A, $0B, $0C, $0D, $0E, $0F,
$10, $11, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $12, $13,
$00, $14, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$15, $16, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $17,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $18,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
// second half - NameChars
$19, $03, $1A, $1B, $1C, $1D, $1E, $00,
$00, $1F, $20, $21, $22, $23, $24, $25,
$10, $11, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $12, $13,
$26, $14, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$27, $16, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $17,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $01,
$01, $01, $01, $01, $01, $01, $01, $18,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00,
$00, $00, $00, $00, $00, $00, $00, $00);

