/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.selector;

public class SelectLine {
    private final int maxLength;
    private boolean selected = false;
    private boolean focus = false;
    private final String description;

    public SelectLine(String description, int maxLength) {
        this.description = description;
        this.maxLength = maxLength;
    }

    public SelectLine(String description, boolean selected, int maxLength) {
        this.description = description;
        this.maxLength = maxLength;
        this.selected = selected;
    }

    public void select() {
        this.selected = !this.selected;
    }

    public void focus() {
        this.focus = !this.focus;
    }

    private char getFocus() {
        return this.focus ? (char)'>' : ' ';
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String print() {
        String out;
        String string = out = this.selected ? this.getFocus() + "[*] " + this.description : this.getFocus() + "[ ] " + this.description;
        if (out.length() > this.maxLength) {
            return out.substring(0, this.maxLength - 3) + "...";
        }
        return out;
    }

    public String value() {
        return this.description;
    }
}

