/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.MySQLIndexHint;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.SQLServerHints;
import net.sf.jsqlparser.expression.WindowDefinition;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.piped.AggregatePipeOperator;
import net.sf.jsqlparser.statement.piped.AsPipeOperator;
import net.sf.jsqlparser.statement.piped.CallPipeOperator;
import net.sf.jsqlparser.statement.piped.DropPipeOperator;
import net.sf.jsqlparser.statement.piped.ExtendPipeOperator;
import net.sf.jsqlparser.statement.piped.FromQuery;
import net.sf.jsqlparser.statement.piped.JoinPipeOperator;
import net.sf.jsqlparser.statement.piped.LimitPipeOperator;
import net.sf.jsqlparser.statement.piped.OrderByPipeOperator;
import net.sf.jsqlparser.statement.piped.PipeOperator;
import net.sf.jsqlparser.statement.piped.PipeOperatorVisitor;
import net.sf.jsqlparser.statement.piped.PivotPipeOperator;
import net.sf.jsqlparser.statement.piped.RenamePipeOperator;
import net.sf.jsqlparser.statement.piped.SelectPipeOperator;
import net.sf.jsqlparser.statement.piped.SetOperationPipeOperator;
import net.sf.jsqlparser.statement.piped.SetPipeOperator;
import net.sf.jsqlparser.statement.piped.TableSamplePipeOperator;
import net.sf.jsqlparser.statement.piped.UnPivotPipeOperator;
import net.sf.jsqlparser.statement.piped.WherePipeOperator;
import net.sf.jsqlparser.statement.piped.WindowPipeOperator;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.First;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.LateralView;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.OptimizeFor;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.Pivot;
import net.sf.jsqlparser.statement.select.PivotVisitor;
import net.sf.jsqlparser.statement.select.PivotXml;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SampleClause;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Skip;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.TableStatement;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.UnPivot;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.UpdateSet;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.GroupByDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;
import net.sf.jsqlparser.util.deparser.StatementDeParser;
import net.sf.jsqlparser.util.deparser.TableStatementDeParser;
import net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;

public class SelectDeParser
extends AbstractDeParser<PlainSelect>
implements SelectVisitor<StringBuilder>,
SelectItemVisitor<StringBuilder>,
FromItemVisitor<StringBuilder>,
PivotVisitor<StringBuilder>,
PipeOperatorVisitor<StringBuilder, Void> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;

    public SelectDeParser() {
        this(new StringBuilder());
    }

    public SelectDeParser(StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = new ExpressionDeParser(this, buffer);
    }

    public SelectDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass, StringBuilder builder) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        super(builder);
        this.expressionVisitor = expressionDeparserClass.getConstructor(SelectDeParser.class, StringBuilder.class).newInstance(this, builder);
    }

    public SelectDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this(expressionDeparserClass, new StringBuilder());
    }

    public SelectDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedSelect select, S context) {
        UnPivot unpivot;
        Pivot pivot;
        SampleClause sampleClause;
        Alias alias;
        List<WithItem<?>> withItemsList = select.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.builder.append("WITH ");
            for (WithItem<?> withItem : withItemsList) {
                withItem.accept(this, context);
                this.builder.append(" ");
            }
        }
        this.builder.append("(");
        select.getSelect().accept(this, context);
        this.builder.append(")");
        if (select.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.builder).deParse(select.isOracleSiblings(), select.getOrderByElements());
        }
        if ((alias = select.getAlias()) != null) {
            this.builder.append(alias);
        }
        if ((sampleClause = select.getSampleClause()) != null) {
            this.builder.append(sampleClause);
        }
        if ((pivot = select.getPivot()) != null) {
            pivot.accept(this, context);
        }
        if ((unpivot = select.getUnPivot()) != null) {
            unpivot.accept(this, context);
        }
        if (select.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.builder).deParse(select.getLimit());
        }
        if (select.getOffset() != null) {
            this.visit(select.getOffset());
        }
        if (select.getFetch() != null) {
            this.visit(select.getFetch());
        }
        if (select.getIsolation() != null) {
            this.builder.append(select.getIsolation().toString());
        }
        return this.builder;
    }

    public void visit(Top top) {
        this.builder.append(top).append(" ");
    }

    @Override
    public <S> StringBuilder visit(PlainSelect plainSelect, S context) {
        UnPivot unpivot;
        Pivot pivot;
        Alias alias;
        Top top;
        First first;
        Skip skip;
        OracleHint hint;
        List<WithItem<?>> withItemsList = plainSelect.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.builder.append("WITH ");
            Iterator<WithItem<?>> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this, context);
                if (iter.hasNext()) {
                    this.builder.append(",");
                }
                this.builder.append(" ");
            }
        }
        this.builder.append("SELECT ");
        if (plainSelect.getMySqlHintStraightJoin()) {
            this.builder.append("STRAIGHT_JOIN ");
        }
        if ((hint = plainSelect.getOracleHint()) != null) {
            this.builder.append(hint).append(" ");
        }
        if ((skip = plainSelect.getSkip()) != null) {
            this.builder.append(skip).append(" ");
        }
        if ((first = plainSelect.getFirst()) != null) {
            this.builder.append(first).append(" ");
        }
        this.deparseDistinctClause(plainSelect.getDistinct());
        if (plainSelect.getBigQuerySelectQualifier() != null) {
            switch (plainSelect.getBigQuerySelectQualifier()) {
                case AS_STRUCT: {
                    this.builder.append("AS STRUCT ");
                    break;
                }
                case AS_VALUE: {
                    this.builder.append("AS VALUE ");
                }
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.visit(top);
        }
        if (plainSelect.getMySqlSqlCacheFlag() != null) {
            this.builder.append(plainSelect.getMySqlSqlCacheFlag().name()).append(" ");
        }
        if (plainSelect.getMySqlSqlCalcFoundRows()) {
            this.builder.append("SQL_CALC_FOUND_ROWS").append(" ");
        }
        this.deparseSelectItemsClause(plainSelect.getSelectItems());
        if (plainSelect.getIntoTables() != null) {
            this.builder.append(" INTO ");
            Iterator<Table> iter = plainSelect.getIntoTables().iterator();
            while (iter.hasNext()) {
                this.visit(iter.next(), (Object)context);
                if (!iter.hasNext()) continue;
                this.builder.append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            Object table;
            this.builder.append(" FROM ");
            if (plainSelect.isUsingOnly()) {
                this.builder.append("ONLY ");
            }
            plainSelect.getFromItem().accept(this, context);
            if (plainSelect.getFromItem() instanceof Table && ((Table)(table = (Table)plainSelect.getFromItem())).getSampleClause() != null) {
                ((Table)table).getSampleClause().appendTo(this.builder);
            }
        }
        if (plainSelect.getLateralViews() != null) {
            for (LateralView lateralView : plainSelect.getLateralViews()) {
                this.deparseLateralView(lateralView);
            }
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.isUsingFinal()) {
            this.builder.append(" FINAL");
        }
        if (plainSelect.getKsqlWindow() != null) {
            this.builder.append(" WINDOW ");
            this.builder.append(plainSelect.getKsqlWindow().toString());
        }
        this.deparseWhereClause(plainSelect);
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor, context);
        }
        if (plainSelect.getPreferringClause() != null) {
            this.builder.append(" ").append(plainSelect.getPreferringClause().toString());
        }
        if (plainSelect.getGroupBy() != null) {
            this.builder.append(" ");
            new GroupByDeParser(this.expressionVisitor, this.builder).deParse(plainSelect.getGroupBy());
        }
        if (plainSelect.getHaving() != null) {
            this.builder.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor, context);
        }
        if (plainSelect.getQualify() != null) {
            this.builder.append(" QUALIFY ");
            plainSelect.getQualify().accept(this.expressionVisitor, context);
        }
        if (plainSelect.getWindowDefinitions() != null) {
            this.builder.append(" WINDOW ");
            this.builder.append(plainSelect.getWindowDefinitions().stream().map(WindowDefinition::toString).collect(Collectors.joining(", ")));
        }
        if (plainSelect.getForClause() != null) {
            plainSelect.getForClause().appendTo(this.builder);
        }
        if ((alias = plainSelect.getAlias()) != null) {
            this.builder.append(alias);
        }
        if ((pivot = plainSelect.getPivot()) != null) {
            pivot.accept(this, context);
        }
        if ((unpivot = plainSelect.getUnPivot()) != null) {
            unpivot.accept(this, context);
        }
        this.deparseOrderByElementsClause(plainSelect, plainSelect.getOrderByElements());
        if (plainSelect.isEmitChanges()) {
            this.builder.append(" EMIT CHANGES");
        }
        if (plainSelect.getLimitBy() != null) {
            new LimitDeparser(this.expressionVisitor, this.builder).deParse(plainSelect.getLimitBy());
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.builder).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.visit(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.visit(plainSelect.getFetch());
        }
        if (plainSelect.getIsolation() != null) {
            this.builder.append(plainSelect.getIsolation().toString());
        }
        if (plainSelect.getForMode() != null) {
            this.builder.append(" FOR ");
            this.builder.append(plainSelect.getForMode().getValue());
            if (plainSelect.getForUpdateTable() != null) {
                this.builder.append(" OF ").append(plainSelect.getForUpdateTable());
            }
            if (plainSelect.getWait() != null) {
                this.builder.append(plainSelect.getWait());
            }
            if (plainSelect.isNoWait()) {
                this.builder.append(" NOWAIT");
            } else if (plainSelect.isSkipLocked()) {
                this.builder.append(" SKIP LOCKED");
            }
        }
        if (plainSelect.getOptimizeFor() != null) {
            this.deparseOptimizeFor(plainSelect.getOptimizeFor());
        }
        if (plainSelect.getForXmlPath() != null) {
            this.builder.append(" FOR XML PATH(").append(plainSelect.getForXmlPath()).append(")");
        }
        if (plainSelect.getIntoTempTable() != null) {
            this.builder.append(" INTO TEMP ").append(plainSelect.getIntoTempTable());
        }
        if (plainSelect.isUseWithNoLog()) {
            this.builder.append(" WITH NO LOG");
        }
        return this.builder;
    }

    protected void deparseWhereClause(PlainSelect plainSelect) {
        if (plainSelect.getWhere() != null) {
            this.builder.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor, null);
        }
    }

    protected void deparseDistinctClause(Distinct distinct) {
        if (distinct != null) {
            if (distinct.isUseUnique()) {
                this.builder.append("UNIQUE ");
            } else {
                this.builder.append("DISTINCT ");
            }
            if (distinct.getOnSelectItems() != null) {
                this.builder.append("ON (");
                Iterator<SelectItem<?>> iter = distinct.getOnSelectItems().iterator();
                while (iter.hasNext()) {
                    SelectItem<?> selectItem = iter.next();
                    selectItem.accept(this, null);
                    if (!iter.hasNext()) continue;
                    this.builder.append(", ");
                }
                this.builder.append(") ");
            }
        }
    }

    protected void deparseSelectItemsClause(List<SelectItem<?>> selectItems) {
        if (selectItems != null) {
            Iterator<SelectItem<?>> iter = selectItems.iterator();
            while (iter.hasNext()) {
                SelectItem<?> selectItem = iter.next();
                selectItem.accept(this, null);
                if (!iter.hasNext()) continue;
                this.builder.append(", ");
            }
        }
    }

    protected void deparseOrderByElementsClause(PlainSelect plainSelect, List<OrderByElement> orderByElements) {
        if (orderByElements != null) {
            new OrderByDeParser(this.expressionVisitor, this.builder).deParse(plainSelect.isOracleSiblings(), orderByElements);
        }
    }

    @Override
    public <S> StringBuilder visit(SelectItem<?> selectItem, S context) {
        selectItem.getExpression().accept(this.expressionVisitor, context);
        if (selectItem.getAlias() != null) {
            this.builder.append(selectItem.getAlias().toString());
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Table tableName, S context) {
        SQLServerHints sqlServerHints;
        MySQLIndexHint indexHint;
        UnPivot unpivot;
        Pivot pivot;
        this.builder.append(tableName.getFullyQualifiedName());
        Alias alias = tableName.getAlias();
        if (alias != null) {
            this.builder.append(alias);
        }
        if ((pivot = tableName.getPivot()) != null) {
            pivot.accept(this, context);
        }
        if ((unpivot = tableName.getUnPivot()) != null) {
            unpivot.accept(this, context);
        }
        if ((indexHint = tableName.getIndexHint()) != null) {
            this.builder.append(indexHint);
        }
        if ((sqlServerHints = tableName.getSqlServerHints()) != null) {
            this.builder.append(sqlServerHints);
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Pivot pivot, S context) {
        this.builder.append(" PIVOT (").append(PlainSelect.getStringList(pivot.getFunctionItems()));
        this.builder.append(" FOR ");
        pivot.getForColumns().accept(this.expressionVisitor, context);
        this.builder.append(" IN ").append(PlainSelect.getStringList(pivot.getInItems(), true, true));
        this.builder.append(")");
        if (pivot.getAlias() != null) {
            this.builder.append(pivot.getAlias().toString());
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(UnPivot unpivot, S context) {
        boolean showOptions = unpivot.getIncludeNullsSpecified();
        boolean includeNulls = unpivot.getIncludeNulls();
        List<Column> unPivotClause = unpivot.getUnPivotClause();
        List<Column> unpivotForClause = unpivot.getUnPivotForClause();
        this.builder.append(" UNPIVOT").append(showOptions && includeNulls ? " INCLUDE NULLS" : "").append(showOptions && !includeNulls ? " EXCLUDE NULLS" : "").append(" (").append(PlainSelect.getStringList(unPivotClause, true, unPivotClause != null && unPivotClause.size() > 1)).append(" FOR ").append(PlainSelect.getStringList(unpivotForClause, true, unpivotForClause != null && unpivotForClause.size() > 1)).append(" IN ").append(PlainSelect.getStringList(unpivot.getUnPivotInClause(), true, true)).append(")");
        if (unpivot.getAlias() != null) {
            this.builder.append(unpivot.getAlias().toString());
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(PivotXml pivot, S context) {
        ExpressionList<Column> forColumns = pivot.getForColumns();
        this.builder.append(" PIVOT XML (").append(PlainSelect.getStringList(pivot.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(forColumns, true, forColumns != null && forColumns.size() > 1)).append(" IN (");
        if (pivot.isInAny()) {
            this.builder.append("ANY");
        } else if (pivot.getInSelect() != null) {
            this.builder.append(pivot.getInSelect());
        } else {
            this.builder.append(PlainSelect.getStringList(pivot.getInItems()));
        }
        this.builder.append("))");
        return this.builder;
    }

    public void visit(Offset offset) {
        this.builder.append(" OFFSET ");
        offset.getOffset().accept(this.expressionVisitor, null);
        if (offset.getOffsetParam() != null) {
            this.builder.append(" ").append(offset.getOffsetParam());
        }
    }

    public void visit(Fetch fetch) {
        this.builder.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.builder.append("FIRST ");
        } else {
            this.builder.append("NEXT ");
        }
        if (fetch.getExpression() != null) {
            fetch.getExpression().accept(this.expressionVisitor, null);
        }
        for (String p : fetch.getFetchParameters()) {
            this.builder.append(" ").append(p);
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }

    public void deparseJoin(Join join) {
        if (join.isGlobal()) {
            this.builder.append(" GLOBAL ");
        }
        if (join.isSimple() && join.isOuter()) {
            this.builder.append(", OUTER ");
        } else if (join.isSimple()) {
            this.builder.append(", ");
        } else {
            if (join.isNatural()) {
                this.builder.append(" NATURAL");
            }
            if (join.isRight()) {
                this.builder.append(" RIGHT");
            } else if (join.isFull()) {
                this.builder.append(" FULL");
            } else if (join.isLeft()) {
                this.builder.append(" LEFT");
            } else if (join.isCross()) {
                this.builder.append(" CROSS");
            }
            if (join.isOuter()) {
                this.builder.append(" OUTER");
            } else if (join.isInner()) {
                this.builder.append(" INNER");
            } else if (join.isSemi()) {
                this.builder.append(" SEMI");
            }
            if (join.isStraight()) {
                this.builder.append(" STRAIGHT_JOIN ");
            } else if (join.isApply()) {
                this.builder.append(" APPLY ");
            } else {
                if (join.getJoinHint() != null) {
                    this.builder.append(" ").append(join.getJoinHint());
                }
                this.builder.append(" JOIN ");
            }
        }
        FromItem fromItem = join.getFromItem();
        fromItem.accept(this, null);
        if (join.isWindowJoin()) {
            this.builder.append(" WITHIN ");
            this.builder.append(join.getJoinWindow().toString());
        }
        for (Expression onExpression : join.getOnExpressions()) {
            this.builder.append(" ON ");
            onExpression.accept(this.expressionVisitor, null);
        }
        if (!join.getUsingColumns().isEmpty()) {
            this.builder.append(" USING (");
            Iterator<Column> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                this.builder.append(column.toString());
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
        }
    }

    public void deparseLateralView(LateralView lateralView) {
        this.builder.append(" LATERAL VIEW");
        if (lateralView.isUsingOuter()) {
            this.builder.append(" OUTER");
        }
        this.builder.append(" ");
        lateralView.getGeneratorFunction().accept(this.expressionVisitor, null);
        if (lateralView.getTableAlias() != null) {
            this.builder.append(" ").append(lateralView.getTableAlias());
        }
        this.builder.append(" ").append(lateralView.getColumnAlias());
    }

    @Override
    public <S> StringBuilder visit(SetOperationList list, S context) {
        UnPivot unpivot;
        Pivot pivot;
        Alias alias;
        List<WithItem<?>> withItemsList = list.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.builder.append("WITH ");
            Iterator<WithItem<?>> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this, context);
                if (iter.hasNext()) {
                    this.builder.append(",");
                }
                this.builder.append(" ");
            }
        }
        for (int i = 0; i < list.getSelects().size(); ++i) {
            if (i != 0) {
                this.builder.append(' ').append(list.getOperations().get(i - 1)).append(' ');
            }
            list.getSelects().get(i).accept(this, context);
        }
        if (list.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.builder).deParse(list.getOrderByElements());
        }
        if (list.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.builder).deParse(list.getLimit());
        }
        if (list.getOffset() != null) {
            this.visit(list.getOffset());
        }
        if (list.getFetch() != null) {
            this.visit(list.getFetch());
        }
        if (list.getIsolation() != null) {
            this.builder.append(list.getIsolation().toString());
        }
        if ((alias = list.getAlias()) != null) {
            this.builder.append(alias);
        }
        if ((pivot = list.getPivot()) != null) {
            pivot.accept(this, context);
        }
        if ((unpivot = list.getUnPivot()) != null) {
            unpivot.accept(this, context);
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(WithItem<?> withItem, S context) {
        if (withItem.isRecursive()) {
            this.builder.append("RECURSIVE ");
        }
        this.builder.append(withItem.getAlias().getName());
        if (withItem.getWithItemList() != null) {
            this.builder.append(" ").append(PlainSelect.getStringList(withItem.getWithItemList(), true, true));
        }
        this.builder.append(" AS ");
        if (withItem.isMaterialized()) {
            this.builder.append("MATERIALIZED ");
        }
        StatementDeParser statementDeParser = new StatementDeParser((ExpressionDeParser)this.expressionVisitor, this, this.builder);
        statementDeParser.deParse((Statement)withItem.getParenthesedStatement());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(LateralSubSelect lateralSubSelect, S context) {
        this.builder.append(lateralSubSelect.getPrefix());
        this.visit((ParenthesedSelect)lateralSubSelect, (Object)context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TableStatement tableStatement, S context) {
        new TableStatementDeParser(this.expressionVisitor, this.builder).deParse(tableStatement);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TableFunction tableFunction, S context) {
        if (tableFunction.getPrefix() != null) {
            this.builder.append(tableFunction.getPrefix()).append(" ");
        }
        tableFunction.getFunction().accept(this.expressionVisitor, context);
        if (tableFunction.getWithClause() != null) {
            this.builder.append(" WITH ").append(tableFunction.getWithClause());
        }
        if (tableFunction.getAlias() != null) {
            this.builder.append(tableFunction.getAlias());
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedFromItem fromItem, S context) {
        this.builder.append("(");
        fromItem.getFromItem().accept(this, context);
        List<Join> joins = fromItem.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                if (join.isSimple()) {
                    this.builder.append(", ").append(join);
                    continue;
                }
                this.builder.append(" ").append(join);
            }
        }
        this.builder.append(")");
        if (fromItem.getAlias() != null) {
            this.builder.append(fromItem.getAlias().toString());
        }
        if (fromItem.getPivot() != null) {
            this.visit(fromItem.getPivot(), (Object)context);
        }
        if (fromItem.getUnPivot() != null) {
            this.visit(fromItem.getUnPivot(), (Object)context);
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Values values, S context) {
        new ValuesStatementDeParser(this.expressionVisitor, this.builder).deParse(values);
        return this.builder;
    }

    @Override
    public void visit(Values values) {
        SelectVisitor.super.visit(values);
    }

    @Override
    public void visit(ParenthesedSelect select) {
        this.visit(select, (Object)null);
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        this.visit(plainSelect, (Object)null);
    }

    @Override
    public void visit(SelectItem<?> selectExpressionItem) {
        this.visit((SelectItem)selectExpressionItem, (Object)null);
    }

    @Override
    public void visit(Table tableName) {
        this.visit(tableName, (Object)null);
    }

    @Override
    public void visit(Pivot pivot) {
        this.visit(pivot, (Object)null);
    }

    @Override
    public void visit(UnPivot unpivot) {
        this.visit(unpivot, (Object)null);
    }

    @Override
    public void visit(PivotXml pivot) {
        this.visit(pivot, (Object)null);
    }

    @Override
    public void visit(SetOperationList list) {
        this.visit(list, (Object)null);
    }

    @Override
    public void visit(WithItem<?> withItem) {
        this.visit((WithItem)withItem, (Object)null);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.visit(lateralSubSelect, (Object)null);
    }

    @Override
    public void visit(TableStatement tableStatement) {
        this.visit(tableStatement, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(FromQuery fromQuery, S context) {
        List<WithItem<?>> withItemsList = fromQuery.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.builder.append("WITH ");
            Iterator<WithItem<?>> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this, context);
                if (iter.hasNext()) {
                    this.builder.append(",");
                }
                this.builder.append(" ");
            }
        }
        if (fromQuery.isUsingFromKeyword()) {
            this.builder.append("FROM ");
        }
        fromQuery.getFromItem().accept(this, context);
        this.builder.append("\n");
        if (fromQuery.getLateralViews() != null) {
            for (LateralView lateralView : fromQuery.getLateralViews()) {
                this.deparseLateralView(lateralView);
            }
        }
        if (fromQuery.getJoins() != null) {
            for (Join join : fromQuery.getJoins()) {
                this.deparseJoin(join);
            }
        }
        for (PipeOperator operator : fromQuery.getPipeOperators()) {
            operator.accept(this, null);
        }
        return this.builder;
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.visit(tableFunction, (Object)null);
    }

    @Override
    public void visit(ParenthesedFromItem fromItem) {
        this.visit(fromItem, (Object)null);
    }

    private void deparseOptimizeFor(OptimizeFor optimizeFor) {
        this.builder.append(" OPTIMIZE FOR ");
        this.builder.append(optimizeFor.getRowCount());
        this.builder.append(" ROWS");
    }

    @Override
    void deParse(PlainSelect statement) {
        statement.accept(this, Optional.ofNullable(null));
    }

    @Override
    public StringBuilder visit(AggregatePipeOperator aggregate, Void context) {
        this.builder.append("|> ").append("AGGREGATE");
        int i = 0;
        for (SelectItem<?> selectItem : aggregate.getSelectItems()) {
            this.builder.append(i > 0 ? ", " : " ");
            selectItem.accept(this, context);
            ArrayList<String> selectItemsOrderSuffices = aggregate.getSelectItemsOrderSuffices();
            if (i < selectItemsOrderSuffices.size() && selectItemsOrderSuffices.get(i) != null && !selectItemsOrderSuffices.get(i).isEmpty()) {
                this.builder.append(" ").append(selectItemsOrderSuffices.get(i));
            }
            ++i;
        }
        this.builder.append("\n");
        if (!aggregate.getGroupItems().isEmpty()) {
            this.builder.append("\t").append("GROUP");
            if (aggregate.isUsingShortHandOrdering()) {
                this.builder.append(" AND ORDER");
            }
            this.builder.append(" BY");
            i = 0;
            for (SelectItem<?> selectItem : aggregate.getGroupItems()) {
                this.builder.append(i > 0 ? ", " : " ");
                selectItem.accept(this, context);
                ArrayList<String> groupItemsOrderSuffices = aggregate.getGroupItemsOrderSuffices();
                if (i < groupItemsOrderSuffices.size() && groupItemsOrderSuffices.get(i) != null && !groupItemsOrderSuffices.get(i).isEmpty()) {
                    this.builder.append(" ").append(groupItemsOrderSuffices.get(i));
                }
                ++i;
            }
            this.builder.append("\n");
        }
        return this.builder;
    }

    @Override
    public StringBuilder visit(AsPipeOperator as, Void context) {
        this.builder.append("|> ").append(as.getAlias());
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(CallPipeOperator call, Void context) {
        this.builder.append("|> CALL ");
        call.getTableFunction().accept(this);
        if (call.getAlias() != null) {
            this.builder.append(" ").append(call.getAlias());
        }
        return this.builder;
    }

    @Override
    public StringBuilder visit(DropPipeOperator drop, Void context) {
        this.builder.append("|> ").append("DROP ");
        drop.getColumns().accept(this.expressionVisitor, context);
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(ExtendPipeOperator extend, Void context) {
        return this.visit((SelectPipeOperator)extend, context);
    }

    @Override
    public StringBuilder visit(JoinPipeOperator join, Void context) {
        this.builder.append("|> ");
        this.deparseJoin(join.getJoin());
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(LimitPipeOperator limit, Void context) {
        this.builder.append("|> ").append("LIMIT ").append(limit.getLimitExpression());
        if (limit.getOffsetExpression() != null) {
            this.builder.append(" OFFSET ").append(limit.getOffsetExpression());
        }
        return this.builder;
    }

    @Override
    public StringBuilder visit(OrderByPipeOperator orderBy, Void context) {
        this.builder.append("|> ");
        new OrderByDeParser(this.expressionVisitor, this.builder).deParse(orderBy.getOrderByElements());
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(PivotPipeOperator pivot, Void context) {
        this.builder.append("|> ").append("PIVOT( ").append(pivot.getAggregateExpression()).append(" FOR ").append(pivot.getInputColumn()).append(" IN (").append(Select.getStringList(pivot.getPivotColumns())).append("))");
        if (pivot.getAlias() != null) {
            this.builder.append(" ").append(pivot.getAlias());
        }
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(RenamePipeOperator rename, Void context) {
        return this.builder;
    }

    @Override
    public StringBuilder visit(SelectPipeOperator select, Void context) {
        this.builder.append("|> ").append(select.getOperatorName());
        if (select.getModifier() != null && !select.getModifier().isEmpty()) {
            this.builder.append(" ").append(select.getModifier());
        }
        int i = 0;
        for (SelectItem<?> selectItem : select.getSelectItems()) {
            this.builder.append(i++ > 0 ? ", " : " ").append(selectItem);
        }
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(SetPipeOperator set, Void context) {
        this.builder.append("|> ").append("SET");
        int i = 0;
        for (UpdateSet updateSet : set.getUpdateSets()) {
            this.builder.append(i++ > 0 ? ", " : " ").append(updateSet);
        }
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(TableSamplePipeOperator tableSample, Void context) {
        this.builder.append("|> ").append("TABLESAMPLE SYSTEM (").append(tableSample.getPercent()).append(" PERCENT)");
        return this.builder;
    }

    @Override
    public StringBuilder visit(SetOperationPipeOperator setOperationPipeOperator, Void context) {
        this.builder.append("|> ").append((Object)setOperationPipeOperator.getSetOperationType());
        if (setOperationPipeOperator.getModifier() != null) {
            this.builder.append(" ").append(setOperationPipeOperator.getModifier());
        }
        int i = 0;
        for (ParenthesedSelect select : setOperationPipeOperator.getSelects()) {
            if (i++ > 0) {
                this.builder.append(", ");
            }
            this.builder.append(select);
        }
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(UnPivotPipeOperator unPivot, Void context) {
        this.builder.append("|> ").append("UNPIVOT( ").append(unPivot.getValuesColumn()).append(" FOR ").append(unPivot.getNameColumn()).append(" IN (").append(Select.getStringList(unPivot.getPivotColumns())).append("))");
        if (unPivot.getAlias() != null) {
            this.builder.append(" ").append(unPivot.getAlias());
        }
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(WherePipeOperator where, Void context) {
        this.builder.append("|> ").append("WHERE ");
        where.getExpression().accept(this.expressionVisitor, context);
        this.builder.append("\n");
        return this.builder;
    }

    @Override
    public StringBuilder visit(WindowPipeOperator window, Void context) {
        return this.visit((SelectPipeOperator)window, context);
    }
}

