﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/OriginationIdentityMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {
class ListPoolOriginationIdentitiesResult {
 public:
  AWS_PINPOINTSMSVOICEV2_API ListPoolOriginationIdentitiesResult() = default;
  AWS_PINPOINTSMSVOICEV2_API ListPoolOriginationIdentitiesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINTSMSVOICEV2_API ListPoolOriginationIdentitiesResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the pool.</p>
   */
  inline const Aws::String& GetPoolArn() const { return m_poolArn; }
  template <typename PoolArnT = Aws::String>
  void SetPoolArn(PoolArnT&& value) {
    m_poolArnHasBeenSet = true;
    m_poolArn = std::forward<PoolArnT>(value);
  }
  template <typename PoolArnT = Aws::String>
  ListPoolOriginationIdentitiesResult& WithPoolArn(PoolArnT&& value) {
    SetPoolArn(std::forward<PoolArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique PoolId of the pool.</p>
   */
  inline const Aws::String& GetPoolId() const { return m_poolId; }
  template <typename PoolIdT = Aws::String>
  void SetPoolId(PoolIdT&& value) {
    m_poolIdHasBeenSet = true;
    m_poolId = std::forward<PoolIdT>(value);
  }
  template <typename PoolIdT = Aws::String>
  ListPoolOriginationIdentitiesResult& WithPoolId(PoolIdT&& value) {
    SetPoolId(std::forward<PoolIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of any OriginationIdentityMetadata objects.</p>
   */
  inline const Aws::Vector<OriginationIdentityMetadata>& GetOriginationIdentities() const { return m_originationIdentities; }
  template <typename OriginationIdentitiesT = Aws::Vector<OriginationIdentityMetadata>>
  void SetOriginationIdentities(OriginationIdentitiesT&& value) {
    m_originationIdentitiesHasBeenSet = true;
    m_originationIdentities = std::forward<OriginationIdentitiesT>(value);
  }
  template <typename OriginationIdentitiesT = Aws::Vector<OriginationIdentityMetadata>>
  ListPoolOriginationIdentitiesResult& WithOriginationIdentities(OriginationIdentitiesT&& value) {
    SetOriginationIdentities(std::forward<OriginationIdentitiesT>(value));
    return *this;
  }
  template <typename OriginationIdentitiesT = OriginationIdentityMetadata>
  ListPoolOriginationIdentitiesResult& AddOriginationIdentities(OriginationIdentitiesT&& value) {
    m_originationIdentitiesHasBeenSet = true;
    m_originationIdentities.emplace_back(std::forward<OriginationIdentitiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to be used for the next set of paginated results. If this field is
   * empty then there are no more results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPoolOriginationIdentitiesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListPoolOriginationIdentitiesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_poolArn;

  Aws::String m_poolId;

  Aws::Vector<OriginationIdentityMetadata> m_originationIdentities;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_poolArnHasBeenSet = false;
  bool m_poolIdHasBeenSet = false;
  bool m_originationIdentitiesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
