/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.optionalusertools;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;

public class PickerUtilities {
    public static DateTimeFormatter createFormatterFromPatternString(String formatPattern, Locale locale) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(formatPattern).toFormatter(locale);
        return formatter;
    }

    public static boolean isLocalTimeInRange(LocalTime value, LocalTime optionalMinimum, LocalTime optionalMaximum, boolean inclusiveOfEndpoints) {
        LocalTime maximum;
        LocalTime minimum = optionalMinimum == null ? LocalTime.MIN : optionalMinimum;
        LocalTime localTime = maximum = optionalMaximum == null ? LocalTime.MAX : optionalMaximum;
        if (value == null) {
            return false;
        }
        if (maximum.isBefore(minimum) || maximum.equals(minimum)) {
            return false;
        }
        if (inclusiveOfEndpoints) {
            return !(!value.isAfter(minimum) && !value.equals(minimum) || !value.isBefore(maximum) && !value.equals(maximum));
        }
        return value.isAfter(minimum) && value.isBefore(maximum);
    }

    public static boolean isSameLocalDate(LocalDate first, LocalDate second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.isEqual(second);
    }

    public static boolean isSameYearMonth(YearMonth first, YearMonth second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    public static boolean isSameLocalTime(LocalTime first, LocalTime second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    public static String localDateTimeToString(LocalDateTime value, String emptyTimeString) {
        return value == null ? emptyTimeString : value.toString();
    }

    public static String localDateTimeToString(LocalDateTime value) {
        return value == null ? "" : value.toString();
    }

    public static String localDateToString(LocalDate date) {
        return PickerUtilities.localDateToString(date, "");
    }

    public static String localDateToString(LocalDate date, String emptyDateString) {
        return date == null ? emptyDateString : date.toString();
    }

    public static String localTimeToString(LocalTime time) {
        return time == null ? "" : time.toString();
    }

    public static String localTimeToString(LocalTime time, String emptyTimeString) {
        return time == null ? emptyTimeString : time.toString();
    }
}

