/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.deletebydate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.DataPoint;
import tim.prune.function.compress.MarkAndDeleteFunction;
import tim.prune.function.deletebydate.DateInfo;
import tim.prune.function.deletebydate.DateInfoList;
import tim.prune.function.deletebydate.DeletionTableModel;

public class DeleteByDateFunction
extends MarkAndDeleteFunction {
    private JDialog _dialog = null;
    private JTable _infoTable = null;
    private JPanel _selButtonPanel = null;
    private JButton _keepSelectedButton = null;
    private JButton _delSelectedButton = null;
    private DateInfoList _infoList = new DateInfoList();

    public DeleteByDateFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.deletebydate";
    }

    @Override
    public void begin() {
        TimeZone timeZone = TimezoneHelper.getSelectedTimezone(this.getConfig());
        DateInfo.setTimezone(timeZone);
        this._infoList.clearAll();
        int n = this._app.getTrackInfo().getTrack().getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n2);
            if (dataPoint != null) {
                if (dataPoint.hasTimestamp()) {
                    this._infoList.addPoint(dataPoint.getTimestamp().getCalendar(timeZone).getTime());
                } else {
                    this._infoList.addPoint(null);
                }
            }
            ++n2;
        }
        if (this._infoList.getNumEntries() < 2) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.deletebydate.onlyonedate");
        } else {
            if (this._dialog == null) {
                this._dialog = new JDialog(this._parentFrame, this.getName(), true);
                this._dialog.setLocationRelativeTo(this._parentFrame);
                this._dialog.setDefaultCloseOperation(2);
                this._dialog.getContentPane().add(this.makeDialogComponents());
                this._dialog.pack();
            }
            this._infoTable.clearSelection();
            this._selButtonPanel.setVisible(this._infoList.getNumEntries() > 4);
            this.enableButtons();
            this._dialog.setVisible(true);
        }
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.deletebydate.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DeleteByDateFunction.this._dialog.dispose();
                }
            }
        };
        this._infoTable = new JTable(new DeletionTableModel(this._infoList));
        this._infoTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = DeleteByDateFunction.this._infoTable.convertColumnIndexToModel(DeleteByDateFunction.this._infoTable.columnAtPoint(mouseEvent.getPoint()));
                if (n >= 2) {
                    DeleteByDateFunction.this.modifyAllCheckboxes(n == 3);
                }
            }
        });
        this._infoTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.enableButtons());
        JScrollPane jScrollPane = new JScrollPane(this._infoTable);
        jScrollPane.setPreferredSize(new Dimension(300, 180));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(2, 50, 2, 50));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        this._selButtonPanel = new JPanel();
        this._selButtonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this._selButtonPanel.setLayout(new FlowLayout(0));
        this._keepSelectedButton = new JButton(I18nManager.getText("button.keepselected"));
        this._keepSelectedButton.addActionListener(actionEvent -> this.changeSelectedRowsToKeep());
        this._selButtonPanel.add(this._keepSelectedButton);
        this._delSelectedButton = new JButton(I18nManager.getText("button.deleteselected"));
        this._delSelectedButton.addActionListener(actionEvent -> this.changeSelectedRowsToDelete());
        this._selButtonPanel.add(this._delSelectedButton);
        jPanel2.add((Component)this._selButtonPanel, "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> this.performDelete());
        jPanel3.add(jButton);
        jButton.addKeyListener(keyAdapter);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jButton2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DeleteByDateFunction.this._dialog.dispose();
                }
            }
        });
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void modifyAllCheckboxes(boolean bl) {
        int n = 0;
        while (n < this._infoList.getNumEntries()) {
            this._infoList.getDateInfo(n).setDeleteFlag(bl);
            ++n;
        }
        this.enableButtons();
    }

    private void changeSelectedRowsToKeep() {
        this.changeSelectedRows(false);
    }

    private void changeSelectedRowsToDelete() {
        this.changeSelectedRows(true);
    }

    private void changeSelectedRows(boolean bl) {
        int n = -1;
        int n2 = -1;
        int[] nArray = this._infoTable.getSelectedRows();
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            if (n == -1) {
                n = n5;
            }
            this._infoList.getDateInfo(n5).setDeleteFlag(bl);
            n2 = n5;
            ++n4;
        }
        ((AbstractTableModel)this._infoTable.getModel()).fireTableRowsUpdated(n, n2);
        this.enableButtons();
    }

    private void enableButtons() {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = this._infoTable.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (this._infoList.getDateInfo(n3).getDeleteFlag()) {
                bl2 = true;
            } else {
                bl = true;
            }
            ++n2;
        }
        this._delSelectedButton.setEnabled(bl);
        this._keepSelectedButton.setEnabled(bl2);
    }

    private void performDelete() {
        int n = 0;
        int n2 = this._app.getTrackInfo().getTrack().getNumPoints();
        int n3 = this._infoList.getNumEntries();
        this._app.getTrackInfo().clearAllMarkers();
        int n4 = 0;
        while (n4 < n2) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n4);
            if (dataPoint != null) {
                Date date = dataPoint.hasTimestamp() ? dataPoint.getTimestamp().getCalendar(TimezoneHelper.getSelectedTimezone(this.getConfig())).getTime() : null;
                boolean bl = false;
                int n5 = 0;
                while (n5 < n3) {
                    DateInfo dateInfo = this._infoList.getDateInfo(n5);
                    if (dateInfo.isDateless() && date == null || !dateInfo.isDateless() && date != null && dateInfo.isSameDate(date)) {
                        bl = dateInfo.getDeleteFlag();
                        break;
                    }
                    ++n5;
                }
                if (bl) {
                    this._app.getTrackInfo().markPointForDeletion(n4);
                    ++n;
                }
            }
            ++n4;
        }
        if (n > 0) {
            this.optionallyDeleteMarkedPoints(n);
        } else {
            UpdateMessageBroker.informSubscribers(4);
        }
        this._dialog.dispose();
    }
}

