/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.ParameterlessMethod;

public class DuplicatesMethod
extends ParameterlessMethod {
    private static final int NUM_POINTS_TO_BACKTRACK = 20;

    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        int n = track.getNumPoints();
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            DataPoint dataPoint;
            if (!(markingData.isPointMarkedForDeletion(n3) || trackDetails.isSegmentStart(n3) || (dataPoint = track.getPoint(n3)).hasMedia())) {
                int n4;
                int n5 = n4 = Math.max(0, n3 - 20);
                while (n5 < n3) {
                    if (!markingData.isPointMarkedForDeletion(n5) && dataPoint.isDuplicate(track.getPoint(n5))) {
                        markingData.markPointForDeletion(n3);
                        ++n2;
                        break;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return n2;
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.DUPLICATES;
    }

    static boolean recogniseString(String string) {
        return DuplicatesMethod.recogniseString(string, CompressionMethodType.DUPLICATES);
    }
}

