﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/savingsplans/SavingsPlansRequest.h>
#include <aws/savingsplans/SavingsPlans_EXPORTS.h>
#include <aws/savingsplans/model/SavingsPlanRateFilter.h>

#include <utility>

namespace Aws {
namespace SavingsPlans {
namespace Model {

/**
 */
class DescribeSavingsPlanRatesRequest : public SavingsPlansRequest {
 public:
  AWS_SAVINGSPLANS_API DescribeSavingsPlanRatesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeSavingsPlanRates"; }

  AWS_SAVINGSPLANS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the Savings Plan.</p>
   */
  inline const Aws::String& GetSavingsPlanId() const { return m_savingsPlanId; }
  inline bool SavingsPlanIdHasBeenSet() const { return m_savingsPlanIdHasBeenSet; }
  template <typename SavingsPlanIdT = Aws::String>
  void SetSavingsPlanId(SavingsPlanIdT&& value) {
    m_savingsPlanIdHasBeenSet = true;
    m_savingsPlanId = std::forward<SavingsPlanIdT>(value);
  }
  template <typename SavingsPlanIdT = Aws::String>
  DescribeSavingsPlanRatesRequest& WithSavingsPlanId(SavingsPlanIdT&& value) {
    SetSavingsPlanId(std::forward<SavingsPlanIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The filters.</p>
   */
  inline const Aws::Vector<SavingsPlanRateFilter>& GetFilters() const { return m_filters; }
  inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
  template <typename FiltersT = Aws::Vector<SavingsPlanRateFilter>>
  void SetFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters = std::forward<FiltersT>(value);
  }
  template <typename FiltersT = Aws::Vector<SavingsPlanRateFilter>>
  DescribeSavingsPlanRatesRequest& WithFilters(FiltersT&& value) {
    SetFilters(std::forward<FiltersT>(value));
    return *this;
  }
  template <typename FiltersT = SavingsPlanRateFilter>
  DescribeSavingsPlanRatesRequest& AddFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters.emplace_back(std::forward<FiltersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeSavingsPlanRatesRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to return with a single call. To retrieve
   * additional results, make another call with the returned token value.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline DescribeSavingsPlanRatesRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_savingsPlanId;

  Aws::Vector<SavingsPlanRateFilter> m_filters;

  Aws::String m_nextToken;

  int m_maxResults{0};
  bool m_savingsPlanIdHasBeenSet = false;
  bool m_filtersHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace SavingsPlans
}  // namespace Aws
