/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Draw/Line/LineParallel/Tests/LineParallelTest01.js
// Timestamp   : 2011-03-08 11:40:24
// Description : Draw parallels to polyline segments.

include('scripts/Developer/TestingDashboard/TdbTest.js');

function LineParallelTest01() {
    TdbTest.call(this, 'scripts/Draw/Line/LineParallel/Tests/LineParallelTest01.js');
}

LineParallelTest01.prototype = new TdbTest();

LineParallelTest01.prototype.test00 = function() {
    qDebug('running LineParallelTest01.test00()...');
    this.setUp();
    this.importFile('scripts/Draw/Line/LineParallel/Tests/data/polyline.dxf');
    this.clickOnWidget('MainWindow::MainToolsPanel::LineToolsPanelButton');
    this.clickOnWidget('MainWindow::LineToolsPanel::LineParallelButton');
    this.setToolOption('LineParallel/Distance',  [ 1, 0 ] );
    this.setToolOption('LineParallel/Number', '1');
    this.updateToolOptions();
    this.setZoom(23.258377425044095, new RVector(8.42069, 4.50195, 0) );
    var p = new RVector(-0.208592, 5.81691);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(23.258377425044095, new RVector(8.42069, 4.50195, 0) );
    var p = new RVector(3.145038, 10.245422);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(23.258377425044095, new RVector(8.42069, 4.50195, 0) );
    var p = new RVector(11.959066, 9.815469);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(23.258377425044095, new RVector(8.42069, 4.50195, 0) );
    var p = new RVector(15.355692, 3.452171);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    var p = new RVector(8.046498, 6.074882);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.RightButton, 2, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.RightButton, 0, 0);
    this.verifyDrawing('LineParallelTest01_000.dxf');
    this.tearDown();
    qDebug('finished LineParallelTest01.test00()');
};

