/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.collections;

import impl.org.controlsfx.collections.ChangeHelper;
import java.util.AbstractList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public final class MappingChange<E, F>
extends ListChangeListener.Change<F> {
    private final Map<E, F> map;
    private final ListChangeListener.Change<? extends E> original;
    private List<F> removed;
    public static final Map NOOP_MAP = new Map(){

        public Object map(Object original) {
            return original;
        }
    };

    public MappingChange(ListChangeListener.Change<? extends E> original, Map<E, F> map, ObservableList<F> list) {
        super(list);
        this.original = original;
        this.map = map;
    }

    @Override
    public boolean next() {
        return this.original.next();
    }

    @Override
    public void reset() {
        this.original.reset();
    }

    @Override
    public int getFrom() {
        return this.original.getFrom();
    }

    @Override
    public int getTo() {
        return this.original.getTo();
    }

    @Override
    public List<F> getRemoved() {
        if (this.removed == null) {
            this.removed = new AbstractList<F>(){

                @Override
                public F get(int index) {
                    return MappingChange.this.map.map(MappingChange.this.original.getRemoved().get(index));
                }

                @Override
                public int size() {
                    return MappingChange.this.original.getRemovedSize();
                }
            };
        }
        return this.removed;
    }

    @Override
    protected int[] getPermutation() {
        return new int[0];
    }

    @Override
    public boolean wasPermutated() {
        return this.original.wasPermutated();
    }

    @Override
    public boolean wasUpdated() {
        return this.original.wasUpdated();
    }

    @Override
    public int getPermutation(int i) {
        return this.original.getPermutation(i);
    }

    public String toString() {
        int size = 0;
        int pos = 0;
        int posToEnd = 0;
        while (this.next()) {
            ++posToEnd;
        }
        this.reset();
        while (this.next()) {
            ++size;
        }
        this.reset();
        StringBuilder b = new StringBuilder();
        b.append("{ ");
        while (this.next()) {
            if (this.wasPermutated()) {
                b.append(ChangeHelper.permChangeToString(this.getPermutation()));
            } else if (this.wasUpdated()) {
                b.append(ChangeHelper.updateChangeToString(this.getFrom(), this.getTo()));
            } else {
                b.append(ChangeHelper.addRemoveChangeToString(this.getFrom(), this.getTo(), this.getList(), this.getRemoved()));
            }
            if (pos == size) continue;
            b.append(", ");
        }
        b.append(" }");
        this.reset();
        pos = size - posToEnd;
        while (pos-- > 0) {
            this.next();
        }
        return b.toString();
    }

    public static interface Map<E, F> {
        public F map(E var1);
    }
}

