"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Loading = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const react_1 = require("@emotion/react");
const Identity_1 = require("../Identity");
const motions_1 = require("../Identity/motions");
const Loading = (_a) => {
    var { progress = undefined, size = 43, color = '#218fd1' } = _a, props = __rest(_a, ["progress", "size", "color"]);
    const pathLength = 125.68;
    const rotationOffset = -0.75;
    const rotationDelay = motions_1.DURATION.EXTRA_LONG * rotationOffset;
    const fillAnimation = (0, react_1.keyframes) `
    0% {
      stroke-dashoffset: ${pathLength + pathLength};
    }
    100% {
      stroke-dashoffset: 0;
    }
  `;
    return ((0, jsx_runtime_1.jsxs)("svg", Object.assign({ width: size, height: size, viewBox: "0 0 43 43", strokeWidth: "3", fill: "none" }, props, { children: [(0, jsx_runtime_1.jsx)("circle", { cx: "21.5", cy: "21.5", r: "20", stroke: Identity_1.COLOR.opaque(color, 0.08) }), (0, jsx_runtime_1.jsx)("circle", { css: !progress && {
                    animation: `${fillAnimation} ${motions_1.DURATION.EXTRA_LONG}ms ease-in-out infinite,
              ${motions_1.ANIMATION.rotate} ${motions_1.DURATION.EXTRA_LONG}ms linear ${rotationDelay}ms infinite`,
                    strokeDasharray: pathLength,
                    transformOrigin: '50% 50%',
                }, cx: "21.5", cy: "21.5", r: "20", stroke: color, strokeLinecap: "round", strokeDasharray: pathLength, strokeDashoffset: progress && `${pathLength - pathLength * progress}` })] })));
};
exports.Loading = Loading;
exports.Loading.defaultProps = {
    progress: undefined,
    size: 43,
};
