# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoImport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'target_url': 'str',
        'magnet_uri': 'str',
        'torrent_name': 'str',
        'state': 'VideoImportStateConstant',
        'error': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'video': 'Video'
    }

    attribute_map = {
        'id': 'id',
        'target_url': 'targetUrl',
        'magnet_uri': 'magnetUri',
        'torrent_name': 'torrentName',
        'state': 'state',
        'error': 'error',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'video': 'video'
    }

    def __init__(self, id=None, target_url=None, magnet_uri=None, torrent_name=None, state=None, error=None, created_at=None, updated_at=None, video=None, local_vars_configuration=None):  # noqa: E501
        """VideoImport - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._target_url = None
        self._magnet_uri = None
        self._torrent_name = None
        self._state = None
        self._error = None
        self._created_at = None
        self._updated_at = None
        self._video = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if target_url is not None:
            self.target_url = target_url
        if magnet_uri is not None:
            self.magnet_uri = magnet_uri
        if torrent_name is not None:
            self.torrent_name = torrent_name
        if state is not None:
            self.state = state
        if error is not None:
            self.error = error
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if video is not None:
            self.video = video

    @property
    def id(self):
        """Gets the id of this VideoImport.  # noqa: E501


        :return: The id of this VideoImport.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VideoImport.


        :param id: The id of this VideoImport.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def target_url(self):
        """Gets the target_url of this VideoImport.  # noqa: E501


        :return: The target_url of this VideoImport.  # noqa: E501
        :rtype: str
        """
        return self._target_url

    @target_url.setter
    def target_url(self, target_url):
        """Sets the target_url of this VideoImport.


        :param target_url: The target_url of this VideoImport.  # noqa: E501
        :type target_url: str
        """

        self._target_url = target_url

    @property
    def magnet_uri(self):
        """Gets the magnet_uri of this VideoImport.  # noqa: E501


        :return: The magnet_uri of this VideoImport.  # noqa: E501
        :rtype: str
        """
        return self._magnet_uri

    @magnet_uri.setter
    def magnet_uri(self, magnet_uri):
        """Sets the magnet_uri of this VideoImport.


        :param magnet_uri: The magnet_uri of this VideoImport.  # noqa: E501
        :type magnet_uri: str
        """

        self._magnet_uri = magnet_uri

    @property
    def torrent_name(self):
        """Gets the torrent_name of this VideoImport.  # noqa: E501


        :return: The torrent_name of this VideoImport.  # noqa: E501
        :rtype: str
        """
        return self._torrent_name

    @torrent_name.setter
    def torrent_name(self, torrent_name):
        """Sets the torrent_name of this VideoImport.


        :param torrent_name: The torrent_name of this VideoImport.  # noqa: E501
        :type torrent_name: str
        """

        self._torrent_name = torrent_name

    @property
    def state(self):
        """Gets the state of this VideoImport.  # noqa: E501


        :return: The state of this VideoImport.  # noqa: E501
        :rtype: VideoImportStateConstant
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this VideoImport.


        :param state: The state of this VideoImport.  # noqa: E501
        :type state: VideoImportStateConstant
        """

        self._state = state

    @property
    def error(self):
        """Gets the error of this VideoImport.  # noqa: E501


        :return: The error of this VideoImport.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this VideoImport.


        :param error: The error of this VideoImport.  # noqa: E501
        :type error: str
        """

        self._error = error

    @property
    def created_at(self):
        """Gets the created_at of this VideoImport.  # noqa: E501


        :return: The created_at of this VideoImport.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this VideoImport.


        :param created_at: The created_at of this VideoImport.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this VideoImport.  # noqa: E501


        :return: The updated_at of this VideoImport.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this VideoImport.


        :param updated_at: The updated_at of this VideoImport.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def video(self):
        """Gets the video of this VideoImport.  # noqa: E501


        :return: The video of this VideoImport.  # noqa: E501
        :rtype: Video
        """
        return self._video

    @video.setter
    def video(self, video):
        """Sets the video of this VideoImport.


        :param video: The video of this VideoImport.  # noqa: E501
        :type video: Video
        """

        self._video = video

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoImport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoImport):
            return True

        return self.to_dict() != other.to_dict()
