/* outdated_checker.c generated by valac 0.56.14, the Vala compiler
 * generated from outdated_checker.vala, do not modify */

/*
 *  Copyright (C) 2020-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <errno.h>
#include <glib-object.h>
#include <alpm.h>
#include <alpm_list.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
#define _alpm_release0(var) ((var == NULL) ? NULL : (var = (alpm_release (var), NULL)))
#define _alpm_config_unref0(var) ((var == NULL) ? NULL : (var = (alpm_config_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _alpm_list_free0(var) ((var == NULL) ? NULL : (var = (alpm_list_free (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

static gint _vala_main (gchar** args,
                 gint args_length1);
VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlpmConfig, alpm_config_unref)
VALA_EXTERN AlpmConfig* alpm_config_new (const gchar* path);
VALA_EXTERN AlpmConfig* alpm_config_construct (GType object_type,
                                   const gchar* path);
VALA_EXTERN alpm_handle_t* alpm_config_get_handle (AlpmConfig* self,
                                       gboolean files_db,
                                       gboolean tmp_db,
                                       gboolean copy_dbs);
VALA_EXTERN void alpm_config_register_syncdbs (AlpmConfig* self,
                                   alpm_handle_t* handle);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda4_ (alpm_pkg_t* pkg1,
                 alpm_pkg_t* pkg2);
static gint ___lambda4__gcompare_func (gconstpointer a,
                                gconstpointer b);
static void _g_free_alpm_list_fn_free (gconstpointer a);

static gboolean
uint_try_parse (const gchar* str,
                guint* _result_,
                const gchar** unparsed,
                guint _base)
{
	guint _vala__result_ = 0U;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gulong ulong_result = 0UL;
	gchar* _tmp0_ = NULL;
	gulong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gulong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtoul (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	ulong_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = ulong_result;
	if ((((gulong) 0) <= _tmp6_) && (_tmp6_ <= ((gulong) G_MAXUINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (guint) ulong_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXUINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GPtrArray* self;
		self = _data1_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gint
__lambda0_ (Block1Data* _data1_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data1_->self;
	result = _data1_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block1Data* _data1_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_ptr_array_ref (self);
	_data1_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gint
__lambda4_ (alpm_pkg_t* pkg1,
            alpm_pkg_t* pkg2)
{
	alpm_time_t date1 = 0LL;
	alpm_time_t _tmp0_;
	alpm_time_t _tmp1_;
	alpm_time_t date2 = 0LL;
	alpm_time_t _tmp2_;
	alpm_time_t _tmp3_;
	gint result;
	g_return_val_if_fail (pkg1 != NULL, 0);
	g_return_val_if_fail (pkg2 != NULL, 0);
	_tmp0_ = alpm_pkg_get_builddate (pkg1);
	_tmp1_ = _tmp0_;
	date1 = _tmp1_;
	_tmp2_ = alpm_pkg_get_builddate (pkg2);
	_tmp3_ = _tmp2_;
	date2 = _tmp3_;
	if (date1 < date2) {
		result = 1;
		return result;
	}
	if (date1 > date2) {
		result = -1;
		return result;
	}
	result = 0;
	return result;
}

static gint
___lambda4__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda4_ ((alpm_pkg_t*) a, (alpm_pkg_t*) b);
	return result;
}

static void
_g_free_alpm_list_fn_free (gconstpointer a)
{
	g_free (a);
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	guint years = 0U;
	AlpmConfig* alpm_config = NULL;
	AlpmConfig* _tmp11_;
	alpm_handle_t* alpm_handle = NULL;
	AlpmConfig* _tmp12_;
	alpm_handle_t* _tmp13_;
	alpm_handle_t* _tmp14_;
	AlpmConfig* _tmp15_;
	alpm_handle_t* _tmp16_;
	GDateTime* now = NULL;
	GDateTime* _tmp17_;
	GTimeSpan years_time = 0LL;
	GPtrArray* found = NULL;
	GPtrArray* _tmp18_;
	alpm_list_t* syncdbs = NULL;
	alpm_handle_t* _tmp19_;
	alpm_list_t* _tmp20_;
	alpm_list_t* _tmp21_;
	GPtrArray* _tmp42_;
	FILE* _tmp43_;
	GPtrArray* _tmp44_;
	gint result;
	years = (guint) 3;
	if (args_length1 > 2) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "Error: only one argument needed\n");
		result = 1;
		return result;
	}
	if (args_length1 == 2) {
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		guint nb = 0U;
		const gchar* _tmp7_;
		guint _tmp8_ = 0U;
		gboolean _tmp9_;
		_tmp2_ = args[1];
		if (g_strcmp0 (_tmp2_, "-h") == 0) {
			_tmp1_ = TRUE;
		} else {
			const gchar* _tmp3_;
			_tmp3_ = args[1];
			_tmp1_ = g_strcmp0 (_tmp3_, "--help") == 0;
		}
		if (_tmp1_) {
			FILE* _tmp4_;
			FILE* _tmp5_;
			FILE* _tmp6_;
			_tmp4_ = stdout;
			fprintf (_tmp4_, "Usage:  outdated-checker <number_of_years>\n\n");
			_tmp5_ = stdout;
			fprintf (_tmp5_, "Displays packages built a given number of years ago\n");
			_tmp6_ = stdout;
			fprintf (_tmp6_, "The number of years is optional, default to 3\n");
			result = 0;
			return result;
		}
		_tmp7_ = args[1];
		_tmp9_ = uint_try_parse (_tmp7_, &_tmp8_, NULL, (guint) 0);
		nb = _tmp8_;
		if (_tmp9_) {
			years = nb;
		} else {
			FILE* _tmp10_;
			_tmp10_ = stderr;
			fprintf (_tmp10_, "Error parsing number of years argument\n");
			result = 1;
			return result;
		}
	}
	_tmp11_ = alpm_config_new ("/etc/pacman.conf");
	alpm_config = _tmp11_;
	_tmp12_ = alpm_config;
	_tmp13_ = alpm_config_get_handle (_tmp12_, FALSE, FALSE, TRUE);
	alpm_handle = _tmp13_;
	_tmp14_ = alpm_handle;
	if (_tmp14_ == NULL) {
		result = 1;
		_alpm_release0 (alpm_handle);
		_alpm_config_unref0 (alpm_config);
		return result;
	}
	_tmp15_ = alpm_config;
	_tmp16_ = alpm_handle;
	alpm_config_register_syncdbs (_tmp15_, _tmp16_);
	_tmp17_ = g_date_time_new_now_utc ();
	now = _tmp17_;
	years_time = (G_TIME_SPAN_DAY * 365) * years;
	_tmp18_ = g_ptr_array_new_full ((guint) 0, NULL);
	found = _tmp18_;
	_tmp19_ = alpm_handle;
	_tmp20_ = alpm_get_syncdbs (_tmp19_);
	_tmp21_ = _tmp20_;
	syncdbs = _tmp21_;
	while (TRUE) {
		alpm_list_t* _tmp22_;
		alpm_db_t* db = NULL;
		alpm_list_t* _tmp23_;
		gconstpointer _tmp24_;
		alpm_list_t* cache = NULL;
		alpm_db_t* _tmp25_;
		alpm_list_t* _tmp26_;
		alpm_list_t* _tmp27_;
		_tmp22_ = syncdbs;
		if (!(_tmp22_ != NULL)) {
			break;
		}
		_tmp23_ = syncdbs;
		_tmp24_ = _tmp23_->data;
		db = (alpm_db_t*) _tmp24_;
		_tmp25_ = db;
		_tmp26_ = alpm_db_get_pkgcache (_tmp25_);
		_tmp27_ = _tmp26_;
		cache = _tmp27_;
		while (TRUE) {
			alpm_list_t* _tmp28_;
			alpm_pkg_t* pkg = NULL;
			alpm_list_t* _tmp29_;
			gconstpointer _tmp30_;
			alpm_pkg_t* _tmp31_;
			alpm_time_t _tmp32_;
			alpm_time_t _tmp33_;
			_tmp28_ = cache;
			if (!(_tmp28_ != NULL)) {
				break;
			}
			_tmp29_ = cache;
			_tmp30_ = _tmp29_->data;
			pkg = (alpm_pkg_t*) _tmp30_;
			_tmp31_ = pkg;
			_tmp32_ = alpm_pkg_get_builddate (_tmp31_);
			_tmp33_ = _tmp32_;
			if (_tmp33_ != ((alpm_time_t) 0)) {
				GDateTime* build_time = NULL;
				alpm_pkg_t* _tmp34_;
				alpm_time_t _tmp35_;
				alpm_time_t _tmp36_;
				GDateTime* _tmp37_;
				GTimeSpan elapsed_time = 0LL;
				GDateTime* _tmp38_;
				GDateTime* _tmp39_;
				_tmp34_ = pkg;
				_tmp35_ = alpm_pkg_get_builddate (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_date_time_new_from_unix_utc ((gint64) _tmp36_);
				build_time = _tmp37_;
				_tmp38_ = now;
				_tmp39_ = build_time;
				elapsed_time = g_date_time_difference (_tmp38_, _tmp39_);
				if (elapsed_time > years_time) {
					GPtrArray* _tmp40_;
					alpm_pkg_t* _tmp41_;
					_tmp40_ = found;
					_tmp41_ = pkg;
					g_ptr_array_add (_tmp40_, _tmp41_);
				}
				_g_date_time_unref0 (build_time);
			}
			cache = alpm_list_next (cache);
		}
		syncdbs = alpm_list_next (syncdbs);
	}
	_tmp42_ = found;
	vala_g_ptr_array_sort (_tmp42_, ___lambda4__gcompare_func);
	_tmp43_ = stdout;
	fprintf (_tmp43_, "Packages built over %u years ago:\n", years);
	_tmp44_ = found;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = _tmp44_;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			alpm_pkg_t* pkg = NULL;
			pkg = g_ptr_array_index (pkg_collection, pkg_index);
			{
				GDateTime* build_time = NULL;
				alpm_pkg_t* _tmp45_;
				alpm_time_t _tmp46_;
				alpm_time_t _tmp47_;
				GDateTime* _tmp48_;
				FILE* _tmp49_;
				alpm_pkg_t* _tmp50_;
				alpm_db_t* _tmp51_;
				alpm_db_t* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				alpm_pkg_t* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				GDateTime* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				alpm_pkg_t* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				alpm_list_t* requiredby = NULL;
				alpm_pkg_t* _tmp64_;
				alpm_list_t* _tmp65_;
				alpm_list_t* _tmp66_;
				_tmp45_ = pkg;
				_tmp46_ = alpm_pkg_get_builddate (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_date_time_new_from_unix_utc ((gint64) _tmp47_);
				build_time = _tmp48_;
				_tmp49_ = stdout;
				_tmp50_ = pkg;
				_tmp51_ = alpm_pkg_get_db (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = alpm_db_get_name (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = pkg;
				_tmp56_ = alpm_pkg_get_name (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = build_time;
				_tmp59_ = g_date_time_format (_tmp58_, "%x");
				_tmp60_ = _tmp59_;
				_tmp61_ = pkg;
				_tmp62_ = alpm_pkg_get_packager (_tmp61_);
				_tmp63_ = _tmp62_;
				fprintf (_tmp49_, "%s/%s: built the %s by %s\n", _tmp54_, _tmp57_, _tmp60_, _tmp63_);
				_g_free0 (_tmp60_);
				_tmp64_ = pkg;
				_tmp65_ = alpm_pkg_compute_requiredby (_tmp64_);
				requiredby = _tmp65_;
				_tmp66_ = requiredby;
				if (_tmp66_ != NULL) {
					FILE* _tmp67_;
					alpm_list_t* list = NULL;
					alpm_list_t* _tmp68_;
					alpm_list_t* _tmp73_;
					_tmp67_ = stdout;
					fprintf (_tmp67_, "  required by:\n");
					_tmp68_ = requiredby;
					list = _tmp68_;
					while (TRUE) {
						alpm_list_t* _tmp69_;
						FILE* _tmp70_;
						alpm_list_t* _tmp71_;
						gconstpointer _tmp72_;
						_tmp69_ = list;
						if (!(_tmp69_ != NULL)) {
							break;
						}
						_tmp70_ = stdout;
						_tmp71_ = list;
						_tmp72_ = _tmp71_->data;
						fprintf (_tmp70_, "    %s\n", (const gchar*) _tmp72_);
						list = alpm_list_next (list);
					}
					_tmp73_ = requiredby;
					alpm_list_free_inner (_tmp73_, _g_free_alpm_list_fn_free);
				}
				_alpm_list_free0 (requiredby);
				_g_date_time_unref0 (build_time);
			}
		}
	}
	result = 0;
	_g_ptr_array_unref0 (found);
	_g_date_time_unref0 (now);
	_alpm_release0 (alpm_handle);
	_alpm_config_unref0 (alpm_config);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

