/*
 * Partition types
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/* Note, _L32M means <32M (less), for example FAT16_L32M */

enum {
	BLKID_EMPTY_PARTITION			= 0x00,
	BLKID_FAT12_PARTITION			= 0x01,
	BLKID_XENIX_ROOT_PARTITION		= 0x02,
	BLKID_XENIX_USR_PARTITION		= 0x03,
	BLKID_FAT16_LESS32M_PARTITION		= 0x04,
	BLKID_DOS_EXTENDED_PARTITION		= 0x05,
	BLKID_FAT16_PARTITION			= 0x06, /* DOS 16-bit >=32M */
	BLKID_HPFS_NTFS_PARTITION		= 0x07, /* OS/2 IFS, eg, HPFS or NTFS or QNX */
	BLKID_AIX_PARTITION			= 0x08, /* AIX boot (AIX -- PS/2 port) or SplitDrive */
	BLKID_AIX_BOOTABLE_PARTITION		= 0x09, /* AIX data or Coherent */
	BLKID_OS2_BOOTMNGR_PARTITION		= 0x0a, /* OS/2 Boot Manager */
	BLKID_W95_FAT32_PARTITION		= 0x0b,
	BLKID_W95_FAT32_LBA_PARTITION		= 0x0c, /* LBA really is `Extended Int 13h' */
	BLKID_W95_FAT16_LBA_PARTITION		= 0x0e,
	BLKID_W95_EXTENDED_PARTITION		= 0x0f,
	BLKID_OPUS_PARTITION			= 0x10,
	BLKID_HIDDEN_FAT12_PARTITION		= 0x11,
	BLKID_COMPAQ_DIAGNOSTICS_PARTITION	= 0x12,
	BLKID_HIDDEN_FAT16_L32M_PARTITION	= 0x14,
	BLKID_HIDDEN_FAT16_PARTITION		= 0x16,
	BLKID_HIDDEN_HPFS_NTFS_PARTITION	= 0x17,
	BLKID_AST_SMARTSLEEP_PARTITION		= 0x18,
	BLKID_HIDDEN_W95_FAT32_PARTITION	= 0x1b,
	BLKID_HIDDEN_W95_FAT32LBA_PARTITION	= 0x1c,
	BLKID_HIDDEN_W95_FAT16LBA_PARTITION	= 0x1e,
	BLKID_NEC_DOS_PARTITION			= 0x24,
	BLKID_PLAN9_PARTITION			= 0x39,
	BLKID_PARTITIONMAGIC_PARTITION		= 0x3c,
	BLKID_VENIX80286_PARTITION		= 0x40,
	BLKID_PPC_PREP_BOOT_PARTITION		= 0x41,
	BLKID_SFS_PARTITION			= 0x42,
	BLKID_QNX_4X_PARTITION			= 0x4d,
	BLKID_QNX_4X_2ND_PARTITION		= 0x4e,
	BLKID_QNX_4X_3RD_PARTITION		= 0x4f,
	BLKID_DM_PARTITION			= 0x50,
	BLKID_DM6_AUX1_PARTITION		= 0x51, /* (or Novell) */
	BLKID_CPM_PARTITION			= 0x52, /* CP/M or Microport SysV/AT */
	BLKID_DM6_AUX3_PARTITION		= 0x53,
	BLKID_DM6_PARTITION			= 0x54,
	BLKID_EZ_DRIVE_PARTITION		= 0x55,
	BLKID_GOLDEN_BOW_PARTITION		= 0x56,
	BLKID_PRIAM_EDISK_PARTITION		= 0x5c,
	BLKID_SPEEDSTOR_PARTITION		= 0x61,
	BLKID_GNU_HURD_PARTITION		= 0x63, /* GNU HURD or Mach or Sys V/386 (such as ISC UNIX) */
	BLKID_UNIXWARE_PARTITION		= BLKID_GNU_HURD_PARTITION,
	BLKID_NETWARE_286_PARTITION		= 0x64,
	BLKID_NETWARE_386_PARTITION		= 0x65,
	BLKID_DISKSECURE_MULTIBOOT_PARTITION	= 0x70,
	BLKID_PC_IX_PARTITION			= 0x75,
	BLKID_OLD_MINIX_PARTITION		= 0x80, /* Minix 1.4a and earlier */
	BLKID_MINIX_PARTITION			= 0x81, /* Minix 1.4b and later */
	BLKID_LINUX_SWAP_PARTITION		= 0x82,
	BLKID_SOLARIS_X86_PARTITION		= BLKID_LINUX_SWAP_PARTITION,
	BLKID_LINUX_DATA_PARTITION		= 0x83,
	BLKID_OS2_HIDDEN_DRIVE_PARTITION	= 0x84,
	BLKID_LINUX_EXTENDED_PARTITION		= 0x85,
	BLKID_NTFS_VOL_SET1_PARTITION		= 0x86,
	BLKID_NTFS_VOL_SET2_PARTITION		= 0x87,
	BLKID_LINUX_PLAINTEXT_PARTITION		= 0x88,
	BLKID_LINUX_LVM_PARTITION		= 0x8e,
	BLKID_AMOEBA_PARTITION			= 0x93,
	BLKID_AMOEBA_BBT_PARTITION		= 0x94, /* (bad block table) */
	BLKID_BSD_OS_PARTITION			= 0x9f, /* BSDI */
	BLKID_THINKPAD_HIBERNATION_PARTITION	= 0xa0,
	BLKID_FREEBSD_PARTITION			= 0xa5, /* various BSD flavours */
	BLKID_OPENBSD_PARTITION			= 0xa6,
	BLKID_NEXTSTEP_PARTITION		= 0xa7,
	BLKID_DARWIN_UFS_PARTITION		= 0xa8,
	BLKID_NETBSD_PARTITION			= 0xa9,
	BLKID_DARWIN_BOOT_PARTITION		= 0xab,
	BLKID_HFS_HFS_PARTITION			= 0xaf,
	BLKID_BSDI_FS_PARTITION			= 0xb7,
	BLKID_BSDI_SWAP_PARTITION		= 0xb8,
	BLKID_BOOTWIZARD_HIDDEN_PARTITION	= 0xbb,
	BLKID_SOLARIS_BOOT_PARTITION		= 0xbe,
	BLKID_SOLARIS_PARTITION			= 0xbf,
	BLKID_DRDOS_FAT12_PARTITION		= 0xc1,
	BLKID_DRDOS_FAT16_L32M_PARTITION	= 0xc4,
	BLKID_DRDOS_FAT16_PARTITION		= 0xc6,
	BLKID_SYRINX_PARTITION			= 0xc7,
	BLKID_NONFS_DATA_PARTITION		= 0xda,
	BLKID_CPM_CTOS_PARTITION		= 0xdb, /* CP/M or Concurrent CP/M or Concurrent DOS or CTOS */
	BLKID_DELL_UTILITY_PARTITION		= 0xde, /* Dell PowerEdge Server utilities */
	BLKID_BOOTIT_PARTITION			= 0xdf, /* BootIt EMBRM */
	BLKID_DOS_ACCESS_PARTITION		= 0xe1, /* DOS access or SpeedStor 12-bit FAT extended partition */
	BLKID_DOS_RO_PARTITION			= 0xe3, /* DOS R/O or SpeedStor */
	BLKID_SPEEDSTOR_EXTENDED_PARTITION	= 0xe4, /* SpeedStor 16-bit FAT extended partition < 1024 cyl. */
	BLKID_BEOS_FS_PARTITION			= 0xeb,
	BLKID_GPT_PARTITION			= 0xee, /* Intel EFI GUID Partition Table */
	BLKID_EFI_SYSTEM_PARTITION		= 0xef, /* Intel EFI System Partition */
	BLKID_LINUX_PARISC_BOOT_PARTITION	= 0xf0, /* Linux/PA-RISC boot loader */
	BLKID_SPEEDSTOR1_PARTITION		= 0xf1,
	BLKID_SPEEDSTOR2_PARTITION		= 0xf4, /* SpeedStor large partition */
	BLKID_DOS_SECONDARY_PARTITION		= 0xf2, /* DOS 3.3+ secondary */
	BLKID_VMWARE_VMFS_PARTITION		= 0xfb,
	BLKID_VMWARE_VMKCORE_PARTITION		= 0xfc, /* VMware kernel dump partition */
	BLKID_LINUX_RAID_PARTITION		= 0xfd, /* New (2.2.x) raid partition with autodetect using persistent superblock */
	BLKID_LANSTEP_PARTITION			= 0xfe, /* SpeedStor >1024 cyl. or LANstep */
	BLKID_XENIX_BBT_PARTITION		= 0xff, /* Xenix Bad Block Table */
};
