/* ----------------------------------------------------------------------- *
 *
 *   Copyright 2011 Intel Corporation; author: H. Peter Anvin
 *
 *   Permission is hereby granted, free of charge, to any person
 *   obtaining a copy of this software and associated documentation
 *   files (the "Software"), to deal in the Software without
 *   restriction, including without limitation the rights to use,
 *   copy, modify, merge, publish, distribute, sublicense, and/or
 *   sell copies of the Software, and to permit persons to whom
 *   the Software is furnished to do so, subject to the following
 *   conditions:
 *
 *   The above copyright notice and this permission notice shall
 *   be included in all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 *   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *   OTHER DEALINGS IN THE SOFTWARE.
 *
 * ----------------------------------------------------------------------- */

/*
 * syslinux/sysappend.h
 *
 * List of the Syslinux sysappend strings
 */

#ifndef _SYSLINUX_SYSAPPEND_H
#define _SYSLINUX_SYSAPPEND_H

enum syslinux_sysappend {
    SYSAPPEND_IP,		/* PXELINUX: ip= address */
    SYSAPPEND_BOOTIF,		/* PXELINUX: BOOTIF= address */
    SYSAPPEND_SYSUUID,		/* System UUID from PXE or DMI */
    SYSAPPEND_VENDOR,		/* System or MB vendor from DMI */
    SYSAPPEND_PRODUCT,		/* System or MB product from DMI */
    SYSAPPEND_VERSION,		/* System or MB version from DMI */
    SYSAPPEND_SERIAL,		/* System or MB serial from DMI */
    SYSAPPEND_SKU,		/* System SKU from DMI */
    SYSAPPEND_FAMILY,		/* System family from DMI */
    SYSAPPEND_ASSET,		/* MB asset tag from DMI */
    SYSAPPEND_MAX		/* Total number of strings */
};

#endif
