// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef KDETVIFACE_H
#define KDETVIFACE_H

#include <dcopobject.h>
#include <dcopref.h>

/**
 * A DCOP interface for libkdetv.
 *
 * @author Richard Moore, rich@kde.org
 */
class KdetvIface : virtual public DCOPObject
{
    K_DCOP
k_dcop:
    /**
     * Starts capture.
     */
    virtual bool start()=0;

    /**
     * Start playing desired device. Restore previous channel,
     * launch source selection/wizard dialogs if necessary. Restore
     * picture settings.
     */
    virtual bool playDevice(const QString& dev, const QString& src, const QString& enc)=0;

    /**
     * Stops capture.
     */
    virtual void stop()=0;

    /**
     * Returns a DCOP reference to the ChannelStore.
     */
    virtual DCOPRef channelStoreIface()=0;

    /**
     * Returns a DCOP reference to the current Channel.
     */
    virtual DCOPRef channelIface()=0;

    /**
     * Returns the name of the current Channel.
     */
    virtual QString channelName() const=0;

    /**
     * Returns the number of the current Channel.
     */
    virtual int channelNumber() const=0;

    /**
     * Changes the channel to the one preceding the current, wrapping
     * round if we are currently showing the first channel.
     */
    virtual void channelDown()=0;

    /**
     * Changes the channel to the one following the current, wrapping
     * round if we are currently showing the last channel.
     */
    virtual void channelUp()=0;

    /**
     * Process the press of a number key (0-9) from keyboard, or lirc.
     */
    virtual void processNumberKeyEvent(int) = 0;

    /**
     *  Recall the previous channel.
     */
     virtual void previousChannel() = 0;

    //
    // Sound
    //

    /**
     * Mutes the sound.
     */
    virtual void toggleMute()=0;

    /**
     * Increases the volume.
     */
    virtual void volumeUp()=0;

    /**
     * Decreases the volume.
     */
    virtual void volumeDown()=0;

    /**
     * Sets the volume.
     */
    virtual void setVolume(int vol)=0;

    /**
     * Sets the volume.
     */
    virtual void setVolume(int left, int right)=0;

    /**
     * Audio mode selection
     */
    virtual void setAudioMode(const QString& mode)=0;

    //
    // IO
    //

    /**
     * Reload current channel file (discards changes since last load)
     */
    virtual void reloadChannels() = 0;

    /**
     * Save channel file
     */
    virtual void saveChannels() = 0;
};

#endif

// Local Variables:
// c-basic-offset: 4
// End:

