/***************************************************************************
                          devicewidgetimpl.cpp  -  description
                             -------------------
    begin                : Mon Jun 3 2002
    copyright            : (C) 2002 by Kevin Hessels, George Staikos, Dirk Ziegelmeier
    email                : khessels@shaw.ca, staikos@kde.org, dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <qcombobox.h>

#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "cfgdata.h"
#include "devicewidgetimpl.h"
#include "kdetv.h"
#include "sourcemanager.h"


DeviceWidgetImpl::DeviceWidgetImpl(QWidget *parent, Kdetv *ktv, ConfigData* cfg)
    : DeviceWidget(parent),
      SettingsDialogPage(i18n("Device"),
                         i18n("Configure Device Options"),
                         "kcmpci"),
      _ktv(ktv),
      _srcm(ktv->sourceManager()),
      _cfg(cfg)
{
    connect(_device, SIGNAL(highlighted(const QString &)),
            this, SLOT(slotChangeSources(const QString &)));
} // DeviceWidgetImpl constructor


DeviceWidgetImpl::~DeviceWidgetImpl()
{
} // DeviceWidgetImpl destructor

void DeviceWidgetImpl::setup()
{
    _device->clear();
    _device->insertStringList(_srcm->deviceList());
    slotChangeSources(_device->currentText());

    if (_srcm->deviceList().isEmpty()) {
        KMessageBox::error(0L,
                           i18n("No devices found.\nFor more information, please read the FAQ at\nhttp://www.kwintv.org"),
                           i18n("Error: No Devices Found"));
    }

    // preselect current device
    if (_srcm->hasDevice()) {
        _device->setCurrentText(_srcm->device());
        _source->setCurrentText(_srcm->source());
        _encoding->setCurrentText(_srcm->encoding());
    }
}

void DeviceWidgetImpl::apply()
{
    if ((!_srcm->hasDevice())                           ||
        (_srcm->device()   != _device->currentText())   ||
        (_srcm->source()   != _source->currentText())   ||
        (_srcm->encoding() != _encoding->currentText())    ) {
        _ktv->playDevice(_device->currentText(), _source->currentText(), _encoding->currentText());
    }
}

void DeviceWidgetImpl::defaults()
{
}

/***************************************************************************
 *
 * Protected Slots
 *
 ***************************************************************************/

void DeviceWidgetImpl::slotChangeSources(const QString &dev)
{
    _source->clear();
    _source->insertStringList(_srcm->sourcesFor(dev));

    _encoding->clear();
    _encoding->insertStringList(_srcm->encodingsFor(dev));
} // slotChangeSources

#include "devicewidgetimpl.moc"
