/***************************************************************************
                           kdetvsettingswidgetimpl.cpp
                           ------------------------------
    begin                : Sun Oct 19 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <klocale.h>
#include <kwin.h>
#include <qcombobox.h>
#include <qcheckbox.h>

#include "mainwindow.h"
#include "kdetvsettingswidgetimpl.h"


KdetvSettingsWidgetImpl::KdetvSettingsWidgetImpl(QWidget* parent, MainWindow* mw)
    : KdetvSettingsWidget(parent),
      SettingsDialogPage(i18n("GUI"),
                         i18n("Configure GUI Options"),
                         "kcmkwm"),
      _mw(mw)
{
}

KdetvSettingsWidgetImpl::~KdetvSettingsWidgetImpl()
{
}

void KdetvSettingsWidgetImpl::setup()
{
    _disableScreenSaver->setChecked(_mw->_disableSaver);
    _saverCombo->setCurrentItem(_mw->_screenSaverMode);
    _stayOnTop->setChecked(_mw->_staysOnTop);

    _enableNormal->setChecked(_mw->_viewNormalEnabled);
    _enableFull->setChecked(_mw->_viewFullEnabled);
    _enableTV->setChecked(_mw->_viewTVEnabled);
    //    _enableDesktop->setChecked(_mw->_viewDesktopEnabled);
}

void KdetvSettingsWidgetImpl::defaults()
{
    _disableScreenSaver->setChecked(true);
    _saverCombo->setCurrentItem(1);
    _stayOnTop->setChecked(false);

    _enableNormal->setChecked(true);
    _enableFull->setChecked(true);
    _enableTV->setChecked(true);
    //    _enableDesktop->setChecked(true);
}

void KdetvSettingsWidgetImpl::apply()
{
    _mw->_disableSaver    = _disableScreenSaver->isChecked();
    _mw->_screenSaverMode = _saverCombo->currentItem();
    bool staysOnTop = _mw->_staysOnTop;
    _mw->_staysOnTop      = _stayOnTop->isChecked();
    if (staysOnTop != _mw->_staysOnTop)
        {
            if (_mw->_staysOnTop)	
                KWin::setState(_mw->winId(), NET::StaysOnTop);
            else
                KWin::clearState(_mw->winId(), NET::StaysOnTop);
        }

    _mw->_viewNormalEnabled  = _enableNormal->isChecked();
    _mw->_viewFullEnabled    = _enableFull->isChecked();
    _mw->_viewTVEnabled      = _enableTV->isChecked();
    //    _mw->_viewDesktopEnabled = _enableDesktop->isChecked();

    // Ensure at least one is selected
    if (!_mw->_viewNormalEnabled &&
        !_mw->_viewFullEnabled &&
        !_mw->_viewTVEnabled) {
        //	!_mw->_viewDesktopEnabled) {
        _mw->_viewNormalEnabled = true;
    }

    _mw->checkScreenSaver();
}

#include "kdetvsettingswidgetimpl.moc"
