/**
 * kconfproperty.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef KCONFPROPERTY_H
#define KCONFPROPERTY_H

#include "propertyeditor/property.h"

#include "entrytoken.h"

#include <qvariant.h>
#include <qmap.h>
#include <qstring.h>


namespace KConfigEditor
{
    class KConfigProperty : public PropertyLib::Property
    {
    public:
        KConfigProperty( EntryToken *token );

        virtual QString name() const;
        virtual void setName( const QString &name );

        virtual int type() const;
        virtual void setType(int type);

        virtual QVariant value() const;
        virtual void setValue( const QVariant &value, bool rememberOldValue = true );

        virtual QString description() const;
        virtual void setDescription( const QString &description );

        virtual void setValueList( const QMap<QString, QVariant> &vars );

        /**Tells if the property can be saved to a stream, xml, etc.
           There is a possibility to use "GUI" properties that aren't
           stored but used only in a GUI.*/
        virtual bool allowSaving();
        /**Tells is the property is read only.*/
        virtual bool isReadOnly();

        EntryToken* token() const;
    private:
        EntryToken *m_token;
    };
}

#endif
