/***************************************************************************
                          kfilereplaceview.h  -  description
                             -------------------
    begin                : sam oct 16 15:28:00 CEST 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEREPLACEVIEW_H
#define KFILEREPLACEVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qlistview.h>
#include <qpixmap.h>
#include <knewpanner.h>

class KFileReplaceDoc;

/** The KFileReplaceView class provides the view widget for the KFileReplaceApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KFileReplaceView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the KFileReplaceApp class to manipulate and display
	* the document structure provided by the KFileReplaceDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
 	*/
class KFileReplaceView : public KNewPanner
{
  Q_OBJECT

public:
  /** Constructor for the main view */
  KFileReplaceView(QWidget *parent=0,const char *name=0,Orientation orient=Vertical,Units units=Percent,int pos=50);
  /** Destructor for the main view */
  ~KFileReplaceView();

	/** returns a pointer to the document connected to the view instance. Mind that this method requires a KFileReplaceApp instance as a parent
		* widget to get to the window document pointer by calling the KFileReplaceApp::getDocument() method.
		*
		* @see KFileReplaceApp#getDocument
		*/
	KFileReplaceDoc* getDocument() const;
	int ListView_AddFullItem(bool bSuccess, char *szName, char *szDirectory, uint nOldSize, uint nNewSize, int nNbRepl, char *szErrMsg=0);
	int ListView_UpdateItem(QListViewItem *lvi, bool bSuccess, uint nNewSize, int nNbRepl, char *szErrMsg=0);
	
  /** contains the implementation for printing functionality */
	void print(QPrinter* m_pPrinter);
  /** Initialize lists
 */
  void init();
	void slotStringAdd();
	
private:
 	QListView *m_ResultList;
	QListView *m_StringsList;
	QPixmap m_pmIconSuccess;
	QPixmap m_pmIconError;
	QPixmap m_pmIconString;


public:
	QListView *getStringsList() {return m_StringsList;}
	QListView *getResultList() {return m_ResultList;}
	QPixmap getIconString() {return m_pmIconString;}
	
};

#endif // KFILEREPLACEVIEW_H














