/***************************************************************************
                          struct.h  -  description
                             -------------------
    begin                : Wed Jul 5 2000
    copyright            : (C) 2000 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STRUCT_H
#define STRUCT_H

#include "resource.h"

#include <stdio.h>
class QWidget;

// Header of the Archive
struct KArchiveHeader // size must be 2048
{
	char szPgm[11]; // Must be "KFileCod01" if the file is a KFileCoder archive : like MZ for EXE files
	DWORD dwAlgorithmUsed; // Number of the algorithm which is used to encode datas. In future versions, the could be many algorithms usables
	DWORD dwFlags; // Properties of the archive
	BYTE cHashTestPass[ENCODING_LEN]; // hash of data encoded with the password: we can say if the password is correct
	BYTE cEncodedPasswordTestMixer[ENCODING_LEN]; // number used to mix the password hash table
	BYTE cMixerCodingMixer[ENCODING_LEN]; // random number calculated on archive creation, used to encode all other random numbers
	char cReserved[1980]; // Reserved for future use (size to the total must be 2048)
};

struct KAlgoInfo
{
	char szName[128];
	char szDescription[128];
	int (*addFileFunction)(QWidget *wWin, const char *szFilename, const BYTE *cPassword, FILE *fFileToAdd, FILE *fArchive, BYTE *cHashControl, QWORD *qwCompressedFileSize, QWORD *qwEncodedFileSize);
	int (*extractFilesFunction)(QWidget *wWin, const char *szFilename, const BYTE *cPassword, FILE *fFileToDecode, FILE *fArchive, BYTE *cHashControl, QWORD qwOriginalFileSize, QWORD qwEncodedFileSize);
};

#endif // STRUCT_H
