/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : lun mai  3 20:19:52 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@free.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// kde includes
#include <kaboutdata.h>
#include <kcmdlineargs.h>

// standard includes
#include <stdio.h>
#include <stdlib.h>

// app includes
#include "kfilecoder.h"
#include "struct.h"

KApplication *g_app;

// ===========================================================================================================================
static KCmdLineOptions g_options[] =
{
	{"+[URL]", I18N_NOOP("URL of archive (*.kfc) to open (can be file:/... if local file)"), 0},
	{0, 0, 0}
};

// ===========================================================================================================================
int main(int argc, char* argv[])
{
	if (sizeof(KArchiveHeader) != 2048)
	{	printf("sizeof(KArchiveHeader) != 2048 (is %d)\n", (int)sizeof(KArchiveHeader));
		return EXIT_FAILURE;
	}
	
	KAboutData about("kfilecoder", "KFileCoder", VERSION, I18N_NOOP("Encode files in an archive with a password"), KAboutData::License_GPL, "Francois Dupoux");

	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(g_options);
    
	KApplication app;
	g_app = &app;

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
 
	if (app.isRestored())
	{
		RESTORE(KFileCoderApp);
	}
	else
	{
		KFileCoderApp* kfilecoder = new KFileCoderApp;
		kfilecoder->show();

		// KFileCoder must open document
		if (args->count())
			kfilecoder->openURL(args->arg(0));
	}

	args->clear();
	return app.exec();
}  
 




