/*
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _DIFFVIEW_H_
#define _DIFFVIEW_H_

#include <qtableview.h>
#include <qlist.h>

#include <difference.h>

class DiffViewItem;
class GeneralSettings;
class DiffModel;
class KDiffView;

class DiffViewItemList : public QList<DiffViewItem>
{
protected:
    virtual int compareItems(QCollection::Item item1, QCollection::Item item2);
};


class DiffView : public QTableView
{
    Q_OBJECT
    
public:

	DiffView( GeneralSettings* settings, bool withlinenos,
	          QWidget *parent=0, const char *name=0 );

	void addLine(const QString &line, Difference::Type type, int no=-1, int otherNo=-1);
	QString stringAtLine(int lineno);
	void setCenterLine(int lineno);
	void setInverted(int lineno, bool inverted);
	int count();
	void removeAtOffset(int offset);
	void insertAtOffset(const QString &line, Difference::Type type, int offset);
	void setCenterOffset(int offset);
	QString stringAtOffset(int offset);

	virtual void setFont(const QFont &font);
	virtual void setTabWidth( uint tabWidth );
	virtual int cellWidth(int col);
	virtual int cellHeight(int row);
	virtual void paintCell(QPainter *p, int row, int col);
	virtual void wheelEvent(QWheelEvent *);
	int rowPos( int row );
	int findLine(int lineno);
	int minScrollId();
	int maxScrollId();
	int pageStep();
	int getScrollId();
	int totalHeight() { return QTableView::totalHeight(); };
	int totalWidth() { return QTableView::totalWidth(); };
	int xOffset() { return QTableView::xOffset(); };

public slots:
	void scrollToId( int id );
	void setXOffset( int off ) { QTableView::setXOffset( off ); };

private:
	GeneralSettings*          m_settings;
	DiffViewItemList          items;
	bool                      linenos;
	int                       textwidth;
	uint                      m_tabWidth;

};

class DiffConnectWidget : public QWidget
{
	Q_OBJECT

public:
	DiffConnectWidget( DiffModel* model, GeneralSettings* settings, KDiffView* parent, const char* name=0);
	~DiffConnectWidget();

	void setDiffViews( DiffView* left, DiffView* right );
	void setModel( DiffModel* model );
	QSize sizeHint() const;

protected:
	void paintEvent( QPaintEvent* e );
	QPointArray makeTopBezier( int tl, int tr );
	QPointArray makeBottomBezier( int bl, int br );
	QPointArray makeConnectPoly( const QPointArray& topBezier, const QPointArray& bottomBezier );

private:
	DiffModel*           m_model;
	GeneralSettings*     m_settings;
	KDiffView*           m_diffView;
	DiffView*            m_leftView;
	DiffView*            m_rightView;

};

#endif

// Local Variables:
// c-basic-offset: 4
// End:
