/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.kawa.functions.Apply;
import gnu.kawa.functions.ApplyToArgs;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.functions.IsEqv;
import gnu.kawa.functions.MultiplyOp;
import gnu.kawa.functions.NumberCompare;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReaderDispatch;
import gnu.kawa.lispexpr.ReaderDispatchMisc;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.kawa.lispexpr.ReaderQuote;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.xml.XmlNamespace;
import gnu.lists.AbstractFormat;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Namespace;
import gnu.mapping.PropertySet;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Unit;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import kawa.lang.Eval;
import kawa.lang.Lambda;
import kawa.lang.Translator;
import kawa.repl;
import kawa.standard.expt;
import kawa.standard.map;
import kawa.standard.not;

public class Scheme
extends LispLanguage {
    public static final Environment nullEnvironment = Environment.make("null-environment");
    public static final Environment r4Environment = Environment.make("r4rs-environment", nullEnvironment);
    public static final Environment r5Environment = Environment.make("r5rs-environment", r4Environment);
    protected static final SimpleEnvironment kawaEnvironment = Environment.make("kawa-environment", r5Environment);
    public static LangPrimType booleanType;
    public static final Scheme instance;
    public static final InstanceOf instanceOf;
    public static final not not;
    public static final map map;
    public static final map forEach;
    public static final IsEq isEq;
    public static final IsEqv isEqv;
    public static final IsEqual isEqual;
    public static final repl repl;
    public static final NumberCompare numEqu;
    public static final NumberCompare numGrt;
    public static final NumberCompare numGEq;
    public static final NumberCompare numLss;
    public static final NumberCompare numLEq;
    public static final Apply apply;
    public static final ApplyToArgs applyToArgs;
    static final Declaration applyFieldDecl;
    public static final Lambda lambda;
    public static final AbstractFormat writeFormat;
    public static final AbstractFormat displayFormat;
    static Hashtable types;
    public static final Namespace unitNamespace;

    public static Scheme getInstance() {
        return instance;
    }

    public static Environment builtin() {
        return kawaEnvironment;
    }

    private void initScheme() {
        this.environ = nullEnvironment;
        this.defSntxStFld("lambda", "kawa.standard.Scheme", "lambda");
        this.defSntxStFld("quote", "kawa.lang.Quote", "plainQuote");
        this.defSntxStFld("%define", "kawa.standard.define", "defineRaw");
        this.defSntxStFld("define", "kawa.lib.prim_syntax");
        this.defSntxStFld("if", "kawa.lib.prim_syntax");
        this.defSntxStFld("set!", "kawa.standard.set_b", "set");
        this.defSntxStFld("cond", "kawa.lib.std_syntax");
        this.defSntxStFld("case", "kawa.lib.std_syntax");
        this.defSntxStFld("and", "kawa.lib.std_syntax");
        this.defSntxStFld("or", "kawa.lib.std_syntax");
        this.defSntxStFld("%let", "kawa.standard.let", "let");
        this.defSntxStFld("let", "kawa.lib.std_syntax");
        this.defSntxStFld("let*", "kawa.lib.std_syntax");
        this.defSntxStFld("letrec", "kawa.lib.prim_syntax");
        this.defSntxStFld("begin", "kawa.standard.begin", "begin");
        this.defSntxStFld("do", "kawa.lib.std_syntax");
        this.defSntxStFld("delay", "kawa.lib.std_syntax");
        this.defProcStFld("%make-promise", "kawa.lib.std_syntax");
        this.defSntxStFld("quasiquote", "kawa.lang.Quote", "quasiQuote");
        this.defSntxStFld("define-syntax", "kawa.lib.prim_syntax");
        this.defSntxStFld("let-syntax", "kawa.standard.let_syntax", "let_syntax");
        this.defSntxStFld("letrec-syntax", "kawa.standard.let_syntax", "letrec_syntax");
        this.defSntxStFld("syntax-rules", "kawa.standard.syntax_rules", "syntax_rules");
        nullEnvironment.setLocked();
        this.environ = r4Environment;
        this.defProcStFld("not", "kawa.standard.Scheme");
        this.defProcStFld("boolean?", "kawa.lib.misc");
        this.defProcStFld("eq?", "kawa.standard.Scheme", "isEq");
        this.defProcStFld("eqv?", "kawa.standard.Scheme", "isEqv");
        this.defProcStFld("equal?", "kawa.standard.Scheme", "isEqual");
        this.defProcStFld("pair?", "kawa.lib.lists");
        this.defProcStFld("cons", "kawa.lib.lists");
        this.defProcStFld("car", "kawa.lib.lists");
        this.defProcStFld("cdr", "kawa.lib.lists");
        this.defProcStFld("set-car!", "kawa.lib.lists");
        this.defProcStFld("set-cdr!", "kawa.lib.lists");
        this.defProcStFld("caar", "kawa.lib.lists");
        this.defProcStFld("cadr", "kawa.lib.lists");
        this.defProcStFld("cdar", "kawa.lib.lists");
        this.defProcStFld("cddr", "kawa.lib.lists");
        this.defProcStFld("caaar", "kawa.lib.lists");
        this.defProcStFld("caadr", "kawa.lib.lists");
        this.defProcStFld("cadar", "kawa.lib.lists");
        this.defProcStFld("caddr", "kawa.lib.lists");
        this.defProcStFld("cdaar", "kawa.lib.lists");
        this.defProcStFld("cdadr", "kawa.lib.lists");
        this.defProcStFld("cddar", "kawa.lib.lists");
        this.defProcStFld("cdddr", "kawa.lib.lists");
        this.defProcStFld("caaaar", "kawa.lib.lists");
        this.defProcStFld("caaadr", "kawa.lib.lists");
        this.defProcStFld("caadar", "kawa.lib.lists");
        this.defProcStFld("caaddr", "kawa.lib.lists");
        this.defProcStFld("cadaar", "kawa.lib.lists");
        this.defProcStFld("cadadr", "kawa.lib.lists");
        this.defProcStFld("caddar", "kawa.lib.lists");
        this.defProcStFld("cadddr", "kawa.lib.lists");
        this.defProcStFld("cdaaar", "kawa.lib.lists");
        this.defProcStFld("cdaadr", "kawa.lib.lists");
        this.defProcStFld("cdadar", "kawa.lib.lists");
        this.defProcStFld("cdaddr", "kawa.lib.lists");
        this.defProcStFld("cddaar", "kawa.lib.lists");
        this.defProcStFld("cddadr", "kawa.lib.lists");
        this.defProcStFld("cdddar", "kawa.lib.lists");
        this.defProcStFld("cddddr", "kawa.lib.lists");
        this.defProcStFld("null?", "kawa.lib.lists");
        this.defProcStFld("list?", "kawa.lib.lists");
        this.defProcStFld("length", "kawa.lib.lists");
        this.defProcStFld("append", "kawa.standard.append", "append");
        this.defProcStFld("reverse", "kawa.lib.lists");
        this.defProcStFld("reverse!", "kawa.lib.lists");
        this.defProcStFld("list-tail", "kawa.lib.lists");
        this.defProcStFld("list-ref", "kawa.lib.lists");
        this.defProcStFld("memq", "kawa.lib.lists");
        this.defProcStFld("memv", "kawa.lib.lists");
        this.defProcStFld("member", "kawa.lib.lists");
        this.defProcStFld("assq", "kawa.lib.lists");
        this.defProcStFld("assv", "kawa.lib.lists");
        this.defProcStFld("assoc", "kawa.lib.lists");
        this.defProcStFld("symbol?", "kawa.lib.misc");
        this.defProcStFld("symbol->string", "kawa.lib.misc");
        this.defProcStFld("string->symbol", "kawa.lib.misc");
        this.defProcStFld("number?", "kawa.lib.numbers");
        this.defProcStFld("quantity?", "kawa.lib.numbers");
        this.defProcStFld("complex?", "kawa.lib.numbers");
        this.defProcStFld("real?", "kawa.lib.numbers");
        this.defProcStFld("rational?", "kawa.lib.numbers");
        this.defProcStFld("integer?", "kawa.lib.numbers");
        this.defProcStFld("exact?", "kawa.lib.numbers");
        this.defProcStFld("inexact?", "kawa.lib.numbers");
        this.defProcStFld("=", "kawa.standard.Scheme", "numEqu");
        this.defProcStFld("<", "kawa.standard.Scheme", "numLss");
        this.defProcStFld(">", "kawa.standard.Scheme", "numGrt");
        this.defProcStFld("<=", "kawa.standard.Scheme", "numLEq");
        this.defProcStFld(">=", "kawa.standard.Scheme", "numGEq");
        this.defProcStFld("zero?", "kawa.lib.numbers");
        this.defProcStFld("positive?", "kawa.lib.numbers");
        this.defProcStFld("negative?", "kawa.lib.numbers");
        this.defProcStFld("odd?", "kawa.lib.numbers");
        this.defProcStFld("even?", "kawa.lib.numbers");
        this.defProcStFld("max", "kawa.lib.numbers");
        this.defProcStFld("min", "kawa.lib.numbers");
        this.defProcStFld("+", "gnu.kawa.functions.AddOp", "$Pl");
        this.defProcStFld("-", "gnu.kawa.functions.AddOp", "$Mn");
        this.defProcStFld("*", "gnu.kawa.functions.MultiplyOp", "$St");
        this.defProcStFld("/", "gnu.kawa.functions.DivideOp", "$Sl");
        this.defProcStFld("abs", "kawa.lib.numbers");
        this.defProcStFld("quotient", "kawa.lib.numbers");
        this.defProcStFld("remainder", "kawa.lib.numbers");
        this.defProcStFld("modulo", "kawa.lib.numbers");
        this.defProcStFld("gcd", "kawa.lib.numbers");
        this.defProcStFld("lcm", "kawa.lib.numbers");
        this.defProcStFld("numerator", "kawa.lib.numbers");
        this.defProcStFld("denominator", "kawa.lib.numbers");
        this.defProcStFld("floor", "kawa.lib.numbers");
        this.defProcStFld("ceiling", "kawa.lib.numbers");
        this.defProcStFld("truncate", "kawa.lib.numbers");
        this.defProcStFld("round", "kawa.lib.numbers");
        this.defProcStFld("rationalize", "kawa.lib.numbers");
        this.defProcStFld("exp", "kawa.lib.numbers");
        this.defProcStFld("log", "kawa.lib.numbers");
        this.defProcStFld("sin", "kawa.lib.numbers");
        this.defProcStFld("cos", "kawa.lib.numbers");
        this.defProcStFld("tan", "kawa.lib.numbers");
        this.defProcStFld("asin", "kawa.lib.numbers");
        this.defProcStFld("acos", "kawa.lib.numbers");
        this.defProcStFld("atan", "kawa.lib.numbers");
        this.defProcStFld("sqrt", "kawa.lib.numbers");
        this.defProcStFld("expt", "kawa.standard.expt");
        this.defProcStFld("make-rectangular", "kawa.lib.numbers");
        this.defProcStFld("make-polar", "kawa.lib.numbers");
        this.defProcStFld("real-part", "kawa.lib.numbers");
        this.defProcStFld("imag-part", "kawa.lib.numbers");
        this.defProcStFld("magnitude", "kawa.lib.numbers");
        this.defProcStFld("angle", "kawa.lib.numbers");
        this.defProcStFld("exact->inexact", "kawa.lib.numbers");
        this.defProcStFld("inexact->exact", "kawa.lib.numbers");
        this.defProcStFld("number->string", "kawa.lib.numbers");
        this.defProcStFld("string->number", "kawa.lib.numbers");
        this.defProcStFld("char?", "kawa.lib.characters");
        this.defProcStFld("char=?", "kawa.lib.characters");
        this.defProcStFld("char<?", "kawa.lib.characters");
        this.defProcStFld("char>?", "kawa.lib.characters");
        this.defProcStFld("char<=?", "kawa.lib.characters");
        this.defProcStFld("char>=?", "kawa.lib.characters");
        this.defProcStFld("char-ci=?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-ci<?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-ci>?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-ci<=?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-ci>=?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-alphabetic?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-numeric?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-whitespace?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-upper-case?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-lower-case?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-title-case?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char->integer", "kawa.lib.characters");
        this.defProcStFld("integer->char", "kawa.lib.characters");
        this.defProcStFld("char-upcase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-downcase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-titlecase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-foldcase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("char-general-category", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string?", "kawa.lib.strings");
        this.defProcStFld("make-string", "kawa.lib.strings");
        this.defProcStFld("string-length", "kawa.lib.strings");
        this.defProcStFld("string-ref", "kawa.lib.strings");
        this.defProcStFld("string-set!", "kawa.lib.strings");
        this.defProcStFld("string=?", "kawa.lib.strings");
        this.defProcStFld("string<?", "kawa.lib.strings");
        this.defProcStFld("string>?", "kawa.lib.strings");
        this.defProcStFld("string<=?", "kawa.lib.strings");
        this.defProcStFld("string>=?", "kawa.lib.strings");
        this.defProcStFld("string-ci=?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-ci<?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-ci>?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-ci<=?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-ci>=?", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-normalize-nfd", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-normalize-nfkd", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-normalize-nfc", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-normalize-nfkc", "kawa.lib.rnrs.unicode");
        this.defProcStFld("substring", "kawa.lib.strings");
        this.defProcStFld("string-append", "kawa.lib.strings");
        this.defProcStFld("string-append/shared", "kawa.lib.strings");
        this.defProcStFld("string->list", "kawa.lib.strings");
        this.defProcStFld("list->string", "kawa.lib.strings");
        this.defProcStFld("string-copy", "kawa.lib.strings");
        this.defProcStFld("string-fill!", "kawa.lib.strings");
        this.defProcStFld("vector?", "kawa.lib.vectors");
        this.defProcStFld("make-vector", "kawa.lib.vectors");
        this.defProcStFld("vector-length", "kawa.lib.vectors");
        this.defProcStFld("vector-ref", "kawa.lib.vectors");
        this.defProcStFld("vector-set!", "kawa.lib.vectors");
        this.defProcStFld("list->vector", "kawa.lib.vectors");
        this.defProcStFld("vector->list", "kawa.lib.vectors");
        this.defProcStFld("vector-fill!", "kawa.lib.vectors");
        this.defProcStFld("vector-append", "kawa.standard.vector_append", "vectorAppend");
        this.defProcStFld("values-append", "gnu.kawa.functions.AppendValues", "appendValues");
        this.defProcStFld("procedure?", "kawa.lib.misc");
        this.defProcStFld("apply", "kawa.standard.Scheme", "apply");
        this.defProcStFld("map", "kawa.standard.Scheme", "map");
        this.defProcStFld("for-each", "kawa.standard.Scheme", "forEach");
        this.defProcStFld("call-with-current-continuation", "kawa.standard.callcc", "callcc");
        this.defProcStFld("call/cc", "kawa.standard.callcc", "callcc");
        this.defProcStFld("force", "kawa.lib.misc");
        this.defProcStFld("call-with-input-file", "kawa.lib.ports");
        this.defProcStFld("call-with-output-file", "kawa.lib.ports");
        this.defProcStFld("input-port?", "kawa.lib.ports");
        this.defProcStFld("output-port?", "kawa.lib.ports");
        this.defProcStFld("current-input-port", "kawa.lib.ports");
        this.defProcStFld("current-output-port", "kawa.lib.ports");
        this.defProcStFld("with-input-from-file", "kawa.lib.ports");
        this.defProcStFld("with-output-to-file", "kawa.lib.ports");
        this.defProcStFld("open-input-file", "kawa.lib.ports");
        this.defProcStFld("open-output-file", "kawa.lib.ports");
        this.defProcStFld("close-input-port", "kawa.lib.ports");
        this.defProcStFld("close-output-port", "kawa.lib.ports");
        this.defProcStFld("read", "kawa.lib.ports");
        this.defProcStFld("read-line", "kawa.lib.ports");
        this.defProcStFld("read-char", "kawa.standard.readchar", "readChar");
        this.defProcStFld("peek-char", "kawa.standard.readchar", "peekChar");
        this.defProcStFld("eof-object?", "kawa.lib.ports");
        this.defProcStFld("char-ready?", "kawa.lib.ports");
        this.defProcStFld("write", "kawa.lib.ports");
        this.defProcStFld("display", "kawa.lib.ports");
        this.defProcStFld("print-as-xml", "gnu.xquery.lang.XQuery", "writeFormat");
        this.defProcStFld("write-char", "kawa.lib.ports");
        this.defProcStFld("newline", "kawa.lib.ports");
        this.defProcStFld("load", "kawa.standard.load", "load");
        this.defProcStFld("load-relative", "kawa.standard.load", "loadRelative");
        this.defProcStFld("transcript-off", "kawa.lib.ports");
        this.defProcStFld("transcript-on", "kawa.lib.ports");
        this.defProcStFld("call-with-input-string", "kawa.lib.ports");
        this.defProcStFld("open-input-string", "kawa.lib.ports");
        this.defProcStFld("open-output-string", "kawa.lib.ports");
        this.defProcStFld("get-output-string", "kawa.lib.ports");
        this.defProcStFld("call-with-output-string", "kawa.lib.ports");
        this.defProcStFld("force-output", "kawa.lib.ports");
        this.defProcStFld("port-line", "kawa.lib.ports");
        this.defProcStFld("set-port-line!", "kawa.lib.ports");
        this.defProcStFld("port-column", "kawa.lib.ports");
        this.defProcStFld("current-error-port", "kawa.lib.ports");
        this.defProcStFld("input-port-line-number", "kawa.lib.ports");
        this.defProcStFld("set-input-port-line-number!", "kawa.lib.ports");
        this.defProcStFld("input-port-column-number", "kawa.lib.ports");
        this.defProcStFld("input-port-read-state", "kawa.lib.ports");
        this.defProcStFld("default-prompter", "kawa.lib.ports");
        this.defProcStFld("input-port-prompter", "kawa.lib.ports");
        this.defProcStFld("set-input-port-prompter!", "kawa.lib.ports");
        this.defProcStFld("base-uri", "kawa.lib.misc");
        this.defProcStFld("%syntax-error", "kawa.standard.syntax_error", "syntax_error");
        this.defProcStFld("syntax-error", "kawa.lib.prim_syntax");
        r4Environment.setLocked();
        this.environ = r5Environment;
        this.defProcStFld("values", "kawa.lib.misc");
        this.defProcStFld("call-with-values", "kawa.standard.call_with_values", "callWithValues");
        this.defSntxStFld("let-values", "kawa.lib.syntax");
        this.defSntxStFld("let*-values", "kawa.lib.syntax");
        this.defSntxStFld("case-lambda", "kawa.lib.syntax");
        this.defSntxStFld("receive", "kawa.lib.syntax");
        this.defProcStFld("eval", "kawa.lang.Eval");
        this.defProcStFld("repl", "kawa.standard.Scheme", "repl");
        this.defProcStFld("scheme-report-environment", "kawa.lib.misc");
        this.defProcStFld("null-environment", "kawa.lib.misc");
        this.defProcStFld("interaction-environment", "kawa.lib.misc");
        this.defProcStFld("dynamic-wind", "kawa.lib.misc");
        r5Environment.setLocked();
        this.environ = kawaEnvironment;
        this.defSntxStFld("define-private", "kawa.lib.prim_syntax");
        this.defSntxStFld("define-constant", "kawa.lib.prim_syntax");
        this.defSntxStFld("define-autoload", "kawa.standard.define_autoload", "define_autoload");
        this.defSntxStFld("define-autoloads-from-file", "kawa.standard.define_autoload", "define_autoloads_from_file");
        this.defProcStFld("exit", "kawa.lib.thread");
        this.defProcStFld("bitwise-arithmetic-shift", "kawa.lib.numbers");
        this.defProcStFld("arithmetic-shift", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-arithmetic-shift"));
        this.defProcStFld("ash", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-arithmetic-shift"));
        this.defProcStFld("bitwise-arithmetic-shift-left", "kawa.lib.numbers");
        this.defProcStFld("bitwise-arithmetic-shift-right", "kawa.lib.numbers");
        this.defProcStFld("bitwise-and", "kawa.lib.numbers");
        this.defProcStFld("logand", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-and"));
        this.defProcStFld("bitwise-ior", "kawa.lib.numbers");
        this.defProcStFld("logior", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-ior"));
        this.defProcStFld("bitwise-xor", "kawa.lib.numbers");
        this.defProcStFld("logxor", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-xor"));
        this.defProcStFld("bitwise-if", "kawa.lib.numbers");
        this.defProcStFld("bitwise-not", "kawa.lib.numbers");
        this.defProcStFld("lognot", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-not"));
        this.defProcStFld("logop", "kawa.lib.numbers");
        this.defProcStFld("bitwise-bit-set?", "kawa.lib.numbers");
        this.defProcStFld("logbit?", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-bit-set?"));
        this.defProcStFld("logtest", "kawa.lib.numbers");
        this.defProcStFld("bitwise-bit-count", "kawa.lib.numbers");
        this.defProcStFld("logcount", "kawa.lib.numbers");
        this.defProcStFld("bitwise-copy-bit", "kawa.lib.numbers");
        this.defProcStFld("bitwise-copy-bit-field", "kawa.lib.numbers");
        this.defProcStFld("bitwise-bit-field", "kawa.lib.numbers");
        this.defProcStFld("bit-extract", "kawa.lib.numbers", Compilation.mangleNameIfNeeded("bitwise-bit-field"));
        this.defProcStFld("bitwise-length", "kawa.lib.numbers");
        this.defProcStFld("integer-length", "kawa.lib.numbers", "bitwise$Mnlength");
        this.defProcStFld("bitwise-first-bit-set", "kawa.lib.numbers");
        this.defProcStFld("bitwise-rotate-bit-field", "kawa.lib.numbers");
        this.defProcStFld("bitwise-reverse-bit-field", "kawa.lib.numbers");
        this.defProcStFld("string-upcase!", "kawa.lib.strings");
        this.defProcStFld("string-downcase!", "kawa.lib.strings");
        this.defProcStFld("string-capitalize!", "kawa.lib.strings");
        this.defProcStFld("string-upcase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-downcase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-titlecase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-foldcase", "kawa.lib.rnrs.unicode");
        this.defProcStFld("string-capitalize", "kawa.lib.strings");
        this.defSntxStFld("primitive-virtual-method", "kawa.standard.prim_method", "virtual_method");
        this.defSntxStFld("primitive-static-method", "kawa.standard.prim_method", "static_method");
        this.defSntxStFld("primitive-interface-method", "kawa.standard.prim_method", "interface_method");
        this.defSntxStFld("primitive-constructor", "kawa.lib.reflection");
        this.defSntxStFld("primitive-op1", "kawa.standard.prim_method", "op1");
        this.defSntxStFld("primitive-get-field", "kawa.lib.reflection");
        this.defSntxStFld("primitive-set-field", "kawa.lib.reflection");
        this.defSntxStFld("primitive-get-static", "kawa.lib.reflection");
        this.defSntxStFld("primitive-set-static", "kawa.lib.reflection");
        this.defSntxStFld("primitive-array-new", "kawa.lib.reflection");
        this.defSntxStFld("primitive-array-get", "kawa.lib.reflection");
        this.defSntxStFld("primitive-array-set", "kawa.lib.reflection");
        this.defSntxStFld("primitive-array-length", "kawa.lib.reflection");
        this.defProcStFld("subtype?", "kawa.lib.reflection");
        this.defProcStFld("primitive-throw", "kawa.standard.prim_throw", "primitiveThrow");
        this.defSntxStFld("try-finally", "kawa.lib.syntax");
        this.defSntxStFld("try-catch", "kawa.lib.prim_syntax");
        this.defProcStFld("throw", "kawa.standard.throw_name", "throwName");
        this.defProcStFld("catch", "kawa.lib.syntax");
        this.defProcStFld("error", "kawa.lib.misc");
        this.defProcStFld("as", "gnu.kawa.functions.Convert", "as");
        this.defProcStFld("instance?", "kawa.standard.Scheme", "instanceOf");
        this.defSntxStFld("synchronized", "kawa.lib.syntax");
        this.defSntxStFld("object", "kawa.standard.object", "objectSyntax");
        this.defSntxStFld("define-class", "kawa.standard.define_class", "define_class");
        this.defSntxStFld("define-simple-class", "kawa.standard.define_class", "define_simple_class");
        this.defSntxStFld("this", "kawa.standard.thisRef", "thisSyntax");
        this.defProcStFld("make", "gnu.kawa.reflect.Invoke", "make");
        this.defProcStFld("slot-ref", "gnu.kawa.reflect.SlotGet", "slotRef");
        this.defProcStFld("slot-set!", "gnu.kawa.reflect.SlotSet", "set$Mnfield$Ex");
        this.defProcStFld("field", "gnu.kawa.reflect.SlotGet");
        this.defProcStFld("class-methods", "gnu.kawa.reflect.ClassMethods", "classMethods");
        this.defProcStFld("static-field", "gnu.kawa.reflect.SlotGet", "staticField");
        this.defProcStFld("invoke", "gnu.kawa.reflect.Invoke", "invoke");
        this.defProcStFld("invoke-static", "gnu.kawa.reflect.Invoke", "invokeStatic");
        this.defProcStFld("invoke-special", "gnu.kawa.reflect.Invoke", "invokeSpecial");
        this.defSntxStFld("define-macro", "kawa.lib.syntax");
        this.defSntxStFld("%define-macro", "kawa.standard.define_syntax", "define_macro");
        this.defSntxStFld("define-syntax-case", "kawa.lib.syntax");
        this.defSntxStFld("syntax-case", "kawa.standard.syntax_case", "syntax_case");
        this.defSntxStFld("%define-syntax", "kawa.standard.define_syntax", "define_syntax");
        this.defSntxStFld("syntax", "kawa.standard.syntax", "syntax");
        this.defSntxStFld("quasisyntax", "kawa.standard.syntax", "quasiSyntax");
        this.defProcStFld("syntax-object->datum", "kawa.lib.std_syntax");
        this.defProcStFld("datum->syntax-object", "kawa.lib.std_syntax");
        this.defProcStFld("syntax->expression", "kawa.lib.prim_syntax");
        this.defProcStFld("syntax-body->expression", "kawa.lib.prim_syntax");
        this.defProcStFld("generate-temporaries", "kawa.lib.std_syntax");
        this.defSntxStFld("with-syntax", "kawa.lib.std_syntax");
        this.defProcStFld("identifier?", "kawa.lib.std_syntax");
        this.defProcStFld("free-identifier=?", "kawa.lib.std_syntax");
        this.defProcStFld("syntax-source", "kawa.lib.std_syntax");
        this.defProcStFld("syntax-line", "kawa.lib.std_syntax");
        this.defProcStFld("syntax-column", "kawa.lib.std_syntax");
        this.defSntxStFld("define-for-syntax", "kawa.lib.prim_syntax");
        this.defSntxStFld("include", "kawa.lib.files");
        this.defSntxStFld("include-relative", "kawa.lib.files");
        this.defProcStFld("file-exists?", "kawa.lib.files");
        this.defProcStFld("file-directory?", "kawa.lib.files");
        this.defProcStFld("file-readable?", "kawa.lib.files");
        this.defProcStFld("file-writable?", "kawa.lib.files");
        this.defProcStFld("delete-file", "kawa.lib.files");
        this.defProcStFld("system-tmpdir", "kawa.lib.files");
        this.defProcStFld("make-temporary-file", "kawa.lib.files");
        this.defProcStFld("rename-file", "kawa.lib.files");
        this.defProcStFld("copy-file", "kawa.lib.files");
        this.defProcStFld("create-directory", "kawa.lib.files");
        this.defProcStFld("->pathname", "kawa.lib.files");
        this.define("port-char-encoding", Boolean.TRUE);
        this.define("symbol-read-case", "P");
        this.defProcStFld("system", "kawa.lib.system");
        this.defProcStFld("make-process", "kawa.lib.system");
        this.defProcStFld("tokenize-string-to-string-array", "kawa.lib.system");
        this.defProcStFld("tokenize-string-using-shell", "kawa.lib.system");
        this.defProcStFld("command-parse", "kawa.lib.system");
        this.defProcStFld("record-accessor", "kawa.lib.reflection");
        this.defProcStFld("record-modifier", "kawa.lib.reflection");
        this.defProcStFld("record-predicate", "kawa.lib.reflection");
        this.defProcStFld("record-constructor", "kawa.lib.reflection");
        this.defProcStFld("make-record-type", "kawa.lib.reflection");
        this.defProcStFld("record-type-descriptor", "kawa.lib.reflection");
        this.defProcStFld("record-type-name", "kawa.lib.reflection");
        this.defProcStFld("record-type-field-names", "kawa.lib.reflection");
        this.defProcStFld("record?", "kawa.lib.reflection");
        this.defSntxStFld("define-record-type", "gnu.kawa.slib.DefineRecordType");
        this.defSntxStFld("when", "kawa.lib.syntax");
        this.defSntxStFld("unless", "kawa.lib.syntax");
        this.defSntxStFld("fluid-let", "kawa.standard.fluid_let", "fluid_let");
        this.defSntxStFld("constant-fold", "kawa.standard.constant_fold", "constant_fold");
        this.defProcStFld("make-parameter", "kawa.lib.parameters");
        this.defSntxStFld("parameterize", "kawa.lib.parameters");
        this.defProcStFld("compile-file", "kawa.lib.system");
        this.defProcStFld("environment-bound?", "kawa.lib.misc");
        this.defProcStFld("scheme-implementation-version", "kawa.lib.misc");
        this.defProcStFld("scheme-window", "kawa.lib.windows");
        this.defSntxStFld("define-procedure", "kawa.lib.std_syntax");
        this.defProcStFld("add-procedure-properties", "kawa.lib.std_syntax");
        this.defProcStFld("make-procedure", "gnu.kawa.functions.MakeProcedure", "makeProcedure");
        this.defProcStFld("procedure-property", "kawa.lib.misc");
        this.defProcStFld("set-procedure-property!", "kawa.lib.misc");
        this.defSntxStFld("provide", "kawa.lib.misc");
        this.defSntxStFld("test-begin", "kawa.lib.misc");
        this.defProcStFld("namespace", "kawa.lib.misc");
        this.defProcStFld("quantity->number", "kawa.lib.numbers");
        this.defProcStFld("quantity->unit", "kawa.lib.numbers");
        this.defProcStFld("make-quantity", "kawa.lib.numbers");
        this.defSntxStFld("define-namespace", "gnu.kawa.lispexpr.DefineNamespace", "define_namespace");
        this.defSntxStFld("define-xml-namespace", "gnu.kawa.lispexpr.DefineNamespace", "define_xml_namespace");
        this.defSntxStFld("define-private-namespace", "gnu.kawa.lispexpr.DefineNamespace", "define_private_namespace");
        this.defSntxStFld("define-unit", "kawa.standard.define_unit", "define_unit");
        this.defSntxStFld("define-base-unit", "kawa.standard.define_unit", "define_base_unit");
        this.defProcStFld("duration", "kawa.lib.numbers");
        this.defProcStFld("gentemp", "kawa.lib.syntax");
        this.defSntxStFld("defmacro", "kawa.lib.syntax");
        this.defProcStFld("setter", "gnu.kawa.functions.Setter", "setter");
        this.defSntxStFld("resource-url", "kawa.lib.files");
        this.defProcStFld("resolve-uri", "kawa.lib.files");
        this.defSntxStFld("module-uri", "kawa.lib.files");
        this.defSntxStFld("future", "kawa.lib.thread");
        this.defProcStFld("sleep", "kawa.lib.thread");
        this.defProcStFld("runnable", "kawa.lib.thread");
        this.defSntxStFld("trace", "kawa.lib.trace");
        this.defSntxStFld("untrace", "kawa.lib.trace");
        this.defProcStFld("format", "gnu.kawa.functions.Format");
        this.defProcStFld("parse-format", "gnu.kawa.functions.ParseFormat", "parseFormat");
        this.defProcStFld("make-element", "gnu.kawa.xml.MakeElement", "makeElement");
        this.defProcStFld("make-attribute", "gnu.kawa.xml.MakeAttribute", "makeAttribute");
        this.defProcStFld("map-values", "gnu.kawa.functions.ValuesMap", "valuesMap");
        this.defProcStFld("children", "gnu.kawa.xml.Children", "children");
        this.defProcStFld("attributes", "gnu.kawa.xml.Attributes");
        this.defProcStFld("unescaped-data", "gnu.kawa.xml.MakeUnescapedData", "unescapedData");
        this.defProcStFld("keyword?", "kawa.lib.keywords");
        this.defProcStFld("keyword->string", "kawa.lib.keywords");
        this.defProcStFld("string->keyword", "kawa.lib.keywords");
        this.defSntxStFld("location", "kawa.standard.location", "location");
        this.defSntxStFld("define-alias", "kawa.standard.define_alias", "define_alias");
        this.defSntxStFld("define-variable", "kawa.standard.define_variable", "define_variable");
        this.defSntxStFld("define-member-alias", "kawa.standard.define_member_alias", "define_member_alias");
        this.defSntxStFld("import", "kawa.lib.syntax");
        this.defSntxStFld("require", "kawa.standard.require", "require");
        this.defSntxStFld("module-name", "kawa.standard.module_name", "module_name");
        this.defSntxStFld("module-extends", "kawa.standard.module_extends", "module_extends");
        this.defSntxStFld("module-implements", "kawa.standard.module_implements", "module_implements");
        this.defSntxStFld("module-static", "kawa.standard.module_static", "module_static");
        this.defSntxStFld("module-export", "kawa.standard.export", "module_export");
        this.defSntxStFld("export", "kawa.standard.export", "export");
        this.defSntxStFld("module-compile-options", "kawa.standard.module_compile_options", "module_compile_options");
        this.defSntxStFld("with-compile-options", "kawa.standard.with_compile_options", "with_compile_options");
        this.defProcStFld("array?", "kawa.lib.arrays");
        this.defProcStFld("array-rank", "kawa.lib.arrays");
        this.defProcStFld("make-array", "kawa.lib.arrays");
        this.defProcStFld("array", "kawa.lib.arrays");
        this.defProcStFld("array-start", "kawa.lib.arrays");
        this.defProcStFld("array-end", "kawa.lib.arrays");
        this.defProcStFld("shape", "kawa.lib.arrays");
        this.defProcStFld("array-ref", "gnu.kawa.functions.ArrayRef", "arrayRef");
        this.defProcStFld("array-set!", "gnu.kawa.functions.ArraySet", "arraySet");
        this.defProcStFld("share-array", "kawa.lib.arrays");
        this.defProcStFld("s8vector?", "kawa.lib.uniform");
        this.defProcStFld("make-s8vector", "kawa.lib.uniform");
        this.defProcStFld("s8vector", "kawa.lib.uniform");
        this.defProcStFld("s8vector-length", "kawa.lib.uniform");
        this.defProcStFld("s8vector-ref", "kawa.lib.uniform");
        this.defProcStFld("s8vector-set!", "kawa.lib.uniform");
        this.defProcStFld("s8vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->s8vector", "kawa.lib.uniform");
        this.defProcStFld("u8vector?", "kawa.lib.uniform");
        this.defProcStFld("make-u8vector", "kawa.lib.uniform");
        this.defProcStFld("u8vector", "kawa.lib.uniform");
        this.defProcStFld("u8vector-length", "kawa.lib.uniform");
        this.defProcStFld("u8vector-ref", "kawa.lib.uniform");
        this.defProcStFld("u8vector-set!", "kawa.lib.uniform");
        this.defProcStFld("u8vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->u8vector", "kawa.lib.uniform");
        this.defProcStFld("s16vector?", "kawa.lib.uniform");
        this.defProcStFld("make-s16vector", "kawa.lib.uniform");
        this.defProcStFld("s16vector", "kawa.lib.uniform");
        this.defProcStFld("s16vector-length", "kawa.lib.uniform");
        this.defProcStFld("s16vector-ref", "kawa.lib.uniform");
        this.defProcStFld("s16vector-set!", "kawa.lib.uniform");
        this.defProcStFld("s16vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->s16vector", "kawa.lib.uniform");
        this.defProcStFld("u16vector?", "kawa.lib.uniform");
        this.defProcStFld("make-u16vector", "kawa.lib.uniform");
        this.defProcStFld("u16vector", "kawa.lib.uniform");
        this.defProcStFld("u16vector-length", "kawa.lib.uniform");
        this.defProcStFld("u16vector-ref", "kawa.lib.uniform");
        this.defProcStFld("u16vector-set!", "kawa.lib.uniform");
        this.defProcStFld("u16vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->u16vector", "kawa.lib.uniform");
        this.defProcStFld("s32vector?", "kawa.lib.uniform");
        this.defProcStFld("make-s32vector", "kawa.lib.uniform");
        this.defProcStFld("s32vector", "kawa.lib.uniform");
        this.defProcStFld("s32vector-length", "kawa.lib.uniform");
        this.defProcStFld("s32vector-ref", "kawa.lib.uniform");
        this.defProcStFld("s32vector-set!", "kawa.lib.uniform");
        this.defProcStFld("s32vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->s32vector", "kawa.lib.uniform");
        this.defProcStFld("u32vector?", "kawa.lib.uniform");
        this.defProcStFld("make-u32vector", "kawa.lib.uniform");
        this.defProcStFld("u32vector", "kawa.lib.uniform");
        this.defProcStFld("u32vector-length", "kawa.lib.uniform");
        this.defProcStFld("u32vector-ref", "kawa.lib.uniform");
        this.defProcStFld("u32vector-set!", "kawa.lib.uniform");
        this.defProcStFld("u32vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->u32vector", "kawa.lib.uniform");
        this.defProcStFld("s64vector?", "kawa.lib.uniform");
        this.defProcStFld("make-s64vector", "kawa.lib.uniform");
        this.defProcStFld("s64vector", "kawa.lib.uniform");
        this.defProcStFld("s64vector-length", "kawa.lib.uniform");
        this.defProcStFld("s64vector-ref", "kawa.lib.uniform");
        this.defProcStFld("s64vector-set!", "kawa.lib.uniform");
        this.defProcStFld("s64vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->s64vector", "kawa.lib.uniform");
        this.defProcStFld("u64vector?", "kawa.lib.uniform");
        this.defProcStFld("make-u64vector", "kawa.lib.uniform");
        this.defProcStFld("u64vector", "kawa.lib.uniform");
        this.defProcStFld("u64vector-length", "kawa.lib.uniform");
        this.defProcStFld("u64vector-ref", "kawa.lib.uniform");
        this.defProcStFld("u64vector-set!", "kawa.lib.uniform");
        this.defProcStFld("u64vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->u64vector", "kawa.lib.uniform");
        this.defProcStFld("f32vector?", "kawa.lib.uniform");
        this.defProcStFld("make-f32vector", "kawa.lib.uniform");
        this.defProcStFld("f32vector", "kawa.lib.uniform");
        this.defProcStFld("f32vector-length", "kawa.lib.uniform");
        this.defProcStFld("f32vector-ref", "kawa.lib.uniform");
        this.defProcStFld("f32vector-set!", "kawa.lib.uniform");
        this.defProcStFld("f32vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->f32vector", "kawa.lib.uniform");
        this.defProcStFld("f64vector?", "kawa.lib.uniform");
        this.defProcStFld("make-f64vector", "kawa.lib.uniform");
        this.defProcStFld("f64vector", "kawa.lib.uniform");
        this.defProcStFld("f64vector-length", "kawa.lib.uniform");
        this.defProcStFld("f64vector-ref", "kawa.lib.uniform");
        this.defProcStFld("f64vector-set!", "kawa.lib.uniform");
        this.defProcStFld("f64vector->list", "kawa.lib.uniform");
        this.defProcStFld("list->f64vector", "kawa.lib.uniform");
        this.defSntxStFld("cut", "gnu.kawa.slib.cut");
        this.defSntxStFld("cute", "gnu.kawa.slib.cut");
        this.defSntxStFld("cond-expand", "kawa.lib.syntax");
        this.defSntxStFld("%cond-expand", "kawa.lib.syntax");
        this.defAliasStFld("*print-base*", "gnu.kawa.functions.DisplayFormat", "outBase");
        this.defAliasStFld("*print-radix*", "gnu.kawa.functions.DisplayFormat", "outRadix");
        this.defAliasStFld("*print-right-margin*", "gnu.text.PrettyWriter", "lineLengthLoc");
        this.defAliasStFld("*print-miser-width*", "gnu.text.PrettyWriter", "miserWidthLoc");
        this.defAliasStFld("html", "gnu.kawa.xml.XmlNamespace", "HTML");
        this.defAliasStFld("unit", "kawa.standard.Scheme", "unitNamespace");
        this.defAliasStFld("path", "gnu.kawa.lispexpr.LangObjType", "pathType");
        this.defAliasStFld("filepath", "gnu.kawa.lispexpr.LangObjType", "filepathType");
        this.defAliasStFld("URI", "gnu.kawa.lispexpr.LangObjType", "URIType");
        this.defAliasStFld("vector", "gnu.kawa.lispexpr.LangObjType", "vectorType");
        this.defAliasStFld("string", "gnu.kawa.lispexpr.LangObjType", "stringType");
        this.defAliasStFld("list", "gnu.kawa.lispexpr.LangObjType", "listType");
        this.defAliasStFld("regex", "gnu.kawa.lispexpr.LangObjType", "regexType");
        this.defProcStFld("path?", "kawa.lib.files");
        this.defProcStFld("filepath?", "kawa.lib.files");
        this.defProcStFld("URI?", "kawa.lib.files");
        this.defProcStFld("absolute-path?", "kawa.lib.files");
        this.defProcStFld("path-scheme", "kawa.lib.files");
        this.defProcStFld("path-authority", "kawa.lib.files");
        this.defProcStFld("path-user-info", "kawa.lib.files");
        this.defProcStFld("path-host", "kawa.lib.files");
        this.defProcStFld("path-port", "kawa.lib.files");
        this.defProcStFld("path-file", "kawa.lib.files");
        this.defProcStFld("path-parent", "kawa.lib.files");
        this.defProcStFld("path-directory", "kawa.lib.files");
        this.defProcStFld("path-last", "kawa.lib.files");
        this.defProcStFld("path-extension", "kawa.lib.files");
        this.defProcStFld("path-fragment", "kawa.lib.files");
        this.defProcStFld("path-query", "kawa.lib.files");
        kawaEnvironment.setLocked();
    }

    public Scheme() {
        this.environ = kawaEnvironment;
        this.userEnv = this.getNewEnvironment();
    }

    protected Scheme(Environment environment) {
        this.environ = environment;
    }

    public String getName() {
        return "Scheme";
    }

    public static Object eval(String string, Environment environment) {
        return Scheme.eval(new CharArrayInPort(string), environment);
    }

    public static Object eval(InPort inPort, Environment environment) {
        SourceMessages sourceMessages = new SourceMessages();
        try {
            LispReader lispReader = (LispReader)Language.getDefaultLanguage().getLexer(inPort, sourceMessages);
            Object object2 = ReaderParens.readList(lispReader, 0, 1, -1);
            if (sourceMessages.seenErrors()) {
                throw new SyntaxException(sourceMessages);
            }
            return Eval.evalBody(object2, environment, sourceMessages);
        }
        catch (SyntaxException syntaxException) {
            throw new RuntimeException("eval: errors while compiling:\n" + syntaxException.getMessages().toString(20));
        }
        catch (IOException iOException) {
            throw new RuntimeException("eval: I/O exception: " + iOException.toString());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }

    public static Object eval(Object object2, Environment environment) {
        try {
            return Eval.eval(object2, environment);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }

    public AbstractFormat getFormat(boolean bl) {
        return bl ? writeFormat : displayFormat;
    }

    public int getNamespaceOf(Declaration declaration) {
        return 3;
    }

    public static Type getTypeValue(Expression expression) {
        return Scheme.getInstance().getTypeFor(expression);
    }

    public static Type getNamedType(String string) {
        Type type;
        if (types == null) {
            booleanType = new LangPrimType(Type.booleanType, Scheme.getInstance());
            types = new Hashtable();
            types.put("void", LangPrimType.voidType);
            types.put("int", LangPrimType.intType);
            types.put("char", LangPrimType.charType);
            types.put("boolean", booleanType);
            types.put("byte", LangPrimType.byteType);
            types.put("short", LangPrimType.shortType);
            types.put("long", LangPrimType.longType);
            types.put("float", LangPrimType.floatType);
            types.put("double", LangPrimType.doubleType);
            types.put("never-returns", Type.neverReturnsType);
            types.put("Object", Type.objectType);
            types.put("String", Type.toStringType);
            types.put("object", Type.objectType);
            types.put("number", ClassType.make("gnu.math.Numeric"));
            types.put("quantity", ClassType.make("gnu.math.Quantity"));
            types.put("complex", ClassType.make("gnu.math.Complex"));
            types.put("real", ClassType.make("gnu.math.RealNum"));
            types.put("rational", ClassType.make("gnu.math.RatNum"));
            types.put("integer", LangObjType.integerType);
            types.put("symbol", ClassType.make("gnu.mapping.Symbol"));
            types.put("keyword", ClassType.make("gnu.expr.Keyword"));
            types.put("pair", ClassType.make("gnu.lists.Pair"));
            types.put("pair-with-position", ClassType.make("gnu.lists.PairWithPosition"));
            types.put("string", ClassType.make("java.lang.CharSequence"));
            types.put("constant-string", ClassType.make("java.lang.String"));
            types.put("abstract-string", ClassType.make("gnu.lists.CharSeq"));
            types.put("character", ClassType.make("gnu.text.Char"));
            types.put("vector", LangObjType.vectorType);
            types.put("string", LangObjType.stringType);
            types.put("list", LangObjType.listType);
            types.put("function", ClassType.make("gnu.mapping.Procedure"));
            types.put("procedure", ClassType.make("gnu.mapping.Procedure"));
            types.put("input-port", ClassType.make("gnu.mapping.InPort"));
            types.put("output-port", ClassType.make("gnu.mapping.OutPort"));
            types.put("string-output-port", ClassType.make("gnu.mapping.CharArrayOutPort"));
            types.put("record", ClassType.make("kawa.lang.Record"));
            types.put("type", LangObjType.typeType);
            types.put("class-type", LangObjType.typeClassType);
            types.put("class", LangObjType.typeClass);
            types.put("s8vector", ClassType.make("gnu.lists.S8Vector"));
            types.put("u8vector", ClassType.make("gnu.lists.U8Vector"));
            types.put("s16vector", ClassType.make("gnu.lists.S16Vector"));
            types.put("u16vector", ClassType.make("gnu.lists.U16Vector"));
            types.put("s32vector", ClassType.make("gnu.lists.S32Vector"));
            types.put("u32vector", ClassType.make("gnu.lists.U32Vector"));
            types.put("s64vector", ClassType.make("gnu.lists.S64Vector"));
            types.put("u64vector", ClassType.make("gnu.lists.U64Vector"));
            types.put("f32vector", ClassType.make("gnu.lists.F32Vector"));
            types.put("f64vector", ClassType.make("gnu.lists.F64Vector"));
            types.put("document", ClassType.make("gnu.lists.TreeList"));
            types.put("readtable", ClassType.make("gnu.kawa.lispexpr.ReadTable"));
        }
        if ((type = (Type)types.get(string)) == null && (string.startsWith("elisp:") || string.startsWith("clisp:"))) {
            int n = string.indexOf(58);
            Class clazz = Scheme.getNamedType(string.substring(n + 1)).getReflectClass();
            String string2 = string.substring(0, n);
            Language language = Language.getInstance(string2);
            if (language == null) {
                throw new RuntimeException("unknown type '" + string + "' - unknown language '" + string2 + '\'');
            }
            type = language.getTypeFor(clazz);
            if (type != null) {
                types.put(string, type);
            }
        }
        return type;
    }

    public Type getTypeFor(Class clazz) {
        String string = clazz.getName();
        if (clazz.isPrimitive()) {
            return Scheme.getNamedType(string);
        }
        if ("java.lang.String".equals(string)) {
            return Type.toStringType;
        }
        if ("gnu.math.IntNum".equals(string)) {
            return LangObjType.integerType;
        }
        if ("gnu.lists.FVector".equals(string)) {
            return LangObjType.vectorType;
        }
        if ("gnu.lists.LList".equals(string)) {
            return LangObjType.listType;
        }
        if ("gnu.text.Path".equals(string)) {
            return LangObjType.pathType;
        }
        if ("gnu.text.URIPath".equals(string)) {
            return LangObjType.URIType;
        }
        if ("gnu.text.FilePath".equals(string)) {
            return LangObjType.filepathType;
        }
        if ("java.lang.Class".equals(string)) {
            return LangObjType.typeClass;
        }
        if ("gnu.bytecode.Type".equals(string)) {
            return LangObjType.typeType;
        }
        if ("gnu.bytecode.ClassType".equals(string)) {
            return LangObjType.typeClassType;
        }
        return Type.make(clazz);
    }

    public static Type string2Type(String string) {
        Type type;
        if (string.endsWith("[]")) {
            type = Scheme.string2Type(string.substring(0, string.length() - 2));
            if (type != null) {
                type = ArrayType.make(type);
            }
        } else {
            type = Scheme.getNamedType(string);
        }
        if (type != null) {
            return type;
        }
        type = Language.string2Type(string);
        if (type != null) {
            types.put(string, type);
        }
        return type;
    }

    public Type getTypeFor(String string) {
        return Scheme.string2Type(string);
    }

    public static Type exp2Type(Expression expression) {
        return Scheme.getInstance().getTypeFor(expression);
    }

    public Expression checkDefaultBinding(Symbol symbol, Translator translator) {
        Object object2;
        Object object3;
        char c;
        int n;
        Object object4;
        block51: {
            Namespace namespace = symbol.getNamespace();
            String string = symbol.getLocalPart();
            if (namespace instanceof XmlNamespace) {
                return QuoteExp.getInstance(((XmlNamespace)namespace).get(string));
            }
            if (namespace.getName() == unitNamespace.getName() && (object4 = Unit.lookup(string)) != null) {
                return QuoteExp.getInstance(object4);
            }
            object4 = symbol.toString();
            n = ((String)object4).length();
            if (n == 0) {
                return null;
            }
            if (n > 1 && ((String)object4).charAt(n - 1) == '?' && (c = string.length()) > '\u0001') {
                String string2 = string.substring(0, c - '\u0001').intern();
                object3 = namespace.getSymbol(string2);
                Expression expression = translator.rewrite(object3, false);
                if (expression instanceof ReferenceExp) {
                    object2 = ((ReferenceExp)expression).getBinding();
                    if (object2 == null || ((Declaration)object2).getFlag(65536)) {
                        expression = null;
                    }
                } else if (!(expression instanceof QuoteExp)) {
                    expression = null;
                }
                if (expression != null) {
                    object2 = new LambdaExp(1);
                    ((PropertySet)object2).setSymbol(symbol);
                    Declaration declaration = ((ScopeExp)object2).addDeclaration((Object)null);
                    ((LambdaExp)object2).body = new ApplyExp(instanceOf, new Expression[]{new ReferenceExp(declaration), expression});
                    return object2;
                }
            }
            if ((c = ((String)object4).charAt(0)) == '-' || c == '+' || Character.digit(c, 10) >= 0) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    char c2 = ((String)object4).charAt(n2);
                    if (Character.digit(c2, 10) >= 0) {
                        n3 = n3 < 3 ? 2 : (n3 < 5 ? 4 : 5);
                        continue;
                    }
                    if ((c2 == '+' || c2 == '-') && n3 == 0) {
                        n3 = 1;
                        continue;
                    }
                    if (c2 == '.' && n3 < 3) {
                        n3 = 3;
                        continue;
                    }
                    if (c2 != 'e' && c2 != 'E' || n3 != 2 && n3 != 4 || n2 + 1 >= n) break;
                    int n4 = n2 + 1;
                    char c3 = ((String)object4).charAt(n4);
                    if ((c3 == '-' || c3 == '+') && ++n4 < n) {
                        c3 = ((String)object4).charAt(n4);
                    }
                    if (Character.digit(c3, 10) < 0) break;
                    n3 = 5;
                    n2 = n4 + 1;
                }
                if (n2 < n && n3 > 1) {
                    int n5;
                    DFloNum dFloNum = new DFloNum(((String)object4).substring(0, n2));
                    boolean bl = false;
                    Vector<Object> vector = new Vector<Object>();
                    while (n2 < n) {
                        int n6;
                        if ((n5 = ((String)object4).charAt(n2++)) == 42) {
                            if (n2 == n) break block51;
                            n5 = ((String)object4).charAt(n2++);
                        } else if (n5 == 47) {
                            if (n2 == n || bl) break block51;
                            bl = true;
                            n5 = ((String)object4).charAt(n2++);
                        }
                        int n7 = n2 - 1;
                        while (true) {
                            if (!Character.isLetter((char)n5)) {
                                n6 = n2 - 1;
                                if (n6 != n7) break;
                                break block51;
                            }
                            if (n2 == n) {
                                n6 = n2;
                                n5 = 49;
                                break;
                            }
                            n5 = ((String)object4).charAt(n2++);
                        }
                        vector.addElement(((String)object4).substring(n7, n6));
                        boolean bl2 = false;
                        if (n5 == 94) {
                            bl2 = true;
                            if (n2 == n) break block51;
                            n5 = ((String)object4).charAt(n2++);
                        }
                        boolean bl3 = bl;
                        if (n5 == 43) {
                            bl2 = true;
                            if (n2 == n) break block51;
                            n5 = ((String)object4).charAt(n2++);
                        } else if (n5 == 45) {
                            bl2 = true;
                            if (n2 == n) break block51;
                            n5 = ((String)object4).charAt(n2++);
                            bl3 = !bl3;
                        }
                        int n8 = 0;
                        int n9 = 0;
                        while (true) {
                            int n10;
                            if ((n10 = Character.digit((char)n5, 10)) <= 0) {
                                --n2;
                                break;
                            }
                            n9 = 10 * n9 + n10;
                            ++n8;
                            if (n2 == n) break;
                            n5 = ((String)object4).charAt(n2++);
                        }
                        if (n8 == 0) {
                            n9 = 1;
                            if (bl2) break block51;
                        }
                        if (bl3) {
                            n9 = -n9;
                        }
                        vector.addElement(IntNum.make(n9));
                    }
                    if (n2 == n) {
                        n5 = vector.size() >> 1;
                        Expression[] expressionArray = new Expression[n5];
                        for (n2 = 0; n2 < n5; ++n2) {
                            String string3 = (String)vector.elementAt(2 * n2);
                            Symbol symbol2 = unitNamespace.getSymbol(string3.intern());
                            Expression expression = translator.rewrite(symbol2);
                            IntNum intNum = (IntNum)vector.elementAt(2 * n2 + 1);
                            if (intNum.longValue() != 1L) {
                                expression = new ApplyExp(expt.expt, new Expression[]{expression, QuoteExp.getInstance(intNum)});
                            }
                            expressionArray[n2] = expression;
                        }
                        Expression expression = n5 == 1 ? expressionArray[0] : new ApplyExp(MultiplyOp.$St, expressionArray);
                        return new ApplyExp(MultiplyOp.$St, new Expression[]{QuoteExp.getInstance(dFloNum), expression});
                    }
                }
            }
        }
        if (n > 2 && c == '<' && ((String)object4).charAt(n - 1) == '>') {
            object4 = ((String)object4).substring(1, n - 1);
            n -= 2;
        }
        int n11 = 0;
        while (n > 2 && ((String)object4).charAt(n - 2) == '[' && ((String)object4).charAt(n - 1) == ']') {
            n -= 2;
            ++n11;
        }
        object3 = object4;
        if (n11 != 0) {
            object3 = ((String)object4).substring(0, n);
        }
        try {
            Class clazz;
            object2 = Scheme.getNamedType((String)object3);
            if (object2 != null) {
                while (--n11 >= 0) {
                    object2 = ArrayType.make((Type)object2);
                }
                return QuoteExp.getInstance(object2);
            }
            object2 = Type.lookupType((String)object3);
            if (object2 instanceof PrimType) {
                clazz = ((Type)object2).getReflectClass();
            } else {
                if (((String)object3).indexOf(46) < 0) {
                    object3 = translator.classPrefix + Compilation.mangleNameIfNeeded((String)object3);
                }
                clazz = ClassType.getContextClass((String)object3);
            }
            if (clazz != null) {
                if (n11 > 0) {
                    object2 = Type.make(clazz);
                    while (--n11 >= 0) {
                        object2 = ArrayType.make((Type)object2);
                    }
                    clazz = ((Type)object2).getReflectClass();
                }
                return QuoteExp.getInstance(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            object2 = ArrayClassLoader.getContextPackage((String)object4);
            if (object2 != null) {
                return QuoteExp.getInstance(object2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Expression makeApply(Expression expression, Expression[] expressionArray) {
        Expression[] expressionArray2 = new Expression[expressionArray.length + 1];
        expressionArray2[0] = expression;
        System.arraycopy(expressionArray, 0, expressionArray2, 1, expressionArray.length);
        return new ApplyExp(new ReferenceExp(applyFieldDecl), expressionArray2);
    }

    public Symbol asSymbol(String string) {
        return Namespace.EmptyNamespace.getSymbol(string);
    }

    public ReadTable createReadTable() {
        ReadTable readTable = ReadTable.createInitial();
        readTable.postfixLookupOperator = (char)58;
        ReaderDispatch readerDispatch = (ReaderDispatch)readTable.lookup(35);
        readerDispatch.set(39, new ReaderQuote(this.asSymbol("syntax")));
        readerDispatch.set(96, new ReaderQuote(this.asSymbol("quasisyntax")));
        readerDispatch.set(44, ReaderDispatchMisc.getInstance());
        readTable.putReaderCtorFld("path", "gnu.kawa.lispexpr.LangObjType", "pathType");
        readTable.putReaderCtorFld("filepath", "gnu.kawa.lispexpr.LangObjType", "filepathType");
        readTable.putReaderCtorFld("URI", "gnu.kawa.lispexpr.LangObjType", "URIType");
        readTable.putReaderCtorFld("namespace", "kawa.lib.misc", "namespace");
        readTable.putReaderCtorFld("duration", "kawa.lib.numbers", "duration");
        readTable.setFinalColonIsKeyword(true);
        return readTable;
    }

    public static void registerEnvironment() {
        Language.setDefaults(Scheme.getInstance());
    }

    static {
        instance = new Scheme(kawaEnvironment);
        instanceOf = new InstanceOf(instance, "instance?");
        not = new not(instance, "not");
        applyToArgs = new ApplyToArgs("apply-to-args", instance);
        applyFieldDecl = Declaration.getDeclarationFromStatic("kawa.standard.Scheme", "applyToArgs");
        map = new map(true, applyToArgs, applyFieldDecl);
        forEach = new map(false, applyToArgs, applyFieldDecl);
        apply = new Apply("apply", applyToArgs);
        isEq = new IsEq(instance, "eq?");
        isEqv = new IsEqv(instance, "eqv?", isEq);
        isEqual = new IsEqual(instance, "equal?");
        numEqu = NumberCompare.make(instance, "=", 8);
        numGrt = NumberCompare.make(instance, ">", 16);
        numGEq = NumberCompare.make(instance, ">=", 24);
        numLss = NumberCompare.make(instance, "<", 4);
        numLEq = NumberCompare.make(instance, "<=", 12);
        Scheme.instance.environ.addLocation(LispLanguage.lookup_sym, null, Translator.getNamedPartLocation);
        repl = new repl(instance);
        instance.initScheme();
        lambda = new Lambda();
        lambda.setKeywords(Special.optional, Special.rest, Special.key);
        writeFormat = new DisplayFormat(true, 'S');
        displayFormat = new DisplayFormat(false, 'S');
        unitNamespace = Namespace.make("http://kawa.gnu.org/unit", "unit");
    }
}

