/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.FString;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongType;
import gnu.text.FilePath;
import gnu.text.Path;
import gnu.text.URIStringPath;
import gnu.text.URLPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIPath
extends Path
implements Comparable<URIPath> {
    final URI uri;

    URIPath(URI uRI) {
        this.uri = uRI;
    }

    public static URIPath coerceToURIPathOrNull(Object object2) {
        String string;
        if (object2 instanceof URIPath) {
            return (URIPath)object2;
        }
        if (object2 instanceof URL) {
            return URLPath.valueOf((URL)object2);
        }
        if (object2 instanceof URI) {
            return URIPath.valueOf((URI)object2);
        }
        if (object2 instanceof File || object2 instanceof Path || object2 instanceof FString) {
            string = object2.toString();
        } else if (object2 instanceof String) {
            string = (String)object2;
        } else {
            return null;
        }
        return URIPath.valueOf(string);
    }

    public static URIPath makeURI(Object object2) {
        URIPath uRIPath = URIPath.coerceToURIPathOrNull(object2);
        if (uRIPath == null) {
            throw new WrongType((String)null, -4, object2, "URI");
        }
        return uRIPath;
    }

    public static URIPath valueOf(URI uRI) {
        return new URIPath(uRI);
    }

    public static URIPath valueOf(String string) {
        try {
            return new URIStringPath(new URI(URIPath.encodeForUri(string, 'I')), string);
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    @Override
    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    @Override
    public boolean exists() {
        try {
            URLConnection uRLConnection = this.toURL().openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                return ((HttpURLConnection)uRLConnection).getResponseCode() == 200;
            }
            return uRLConnection.getLastModified() != 0L;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public long getLastModified() {
        return URLPath.getLastModified(this.toURL());
    }

    @Override
    public long getContentLength() {
        return URLPath.getContentLength(this.toURL());
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public String toURIString() {
        return this.uri.toString();
    }

    @Override
    public Path resolve(String string) {
        URI uRI;
        if (Path.uriSchemeSpecified(string)) {
            return URIPath.valueOf(string);
        }
        char c = File.separatorChar;
        if (c != '/') {
            if (string.length() >= 2 && (string.charAt(1) == ':' && Character.isLetter(string.charAt(0)) || string.charAt(0) == c && string.charAt(1) == c)) {
                return FilePath.valueOf(new File(string));
            }
            string = string.replace(c, '/');
        }
        try {
            uRI = this.uri.resolve(new URI(null, string, null));
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
        return URIPath.valueOf(uRI);
    }

    @Override
    public int compareTo(URIPath uRIPath) {
        return this.uri.compareTo(uRIPath.uri);
    }

    public boolean equals(Object object2) {
        return object2 instanceof URIPath && this.uri.equals(((URIPath)object2).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.toURIString();
    }

    @Override
    public URL toURL() {
        return Path.toURL(this.uri.toString());
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return URLPath.openInputStream(this.toURL());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return URLPath.openOutputStream(this.toURL());
    }

    @Override
    public String getScheme() {
        return this.uri.getScheme();
    }

    @Override
    public String getHost() {
        return this.uri.getHost();
    }

    @Override
    public String getAuthority() {
        return this.uri.getAuthority();
    }

    @Override
    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    @Override
    public int getPort() {
        return this.uri.getPort();
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    @Override
    public String getQuery() {
        return this.uri.getQuery();
    }

    @Override
    public String getFragment() {
        return this.uri.getFragment();
    }

    @Override
    public Path getCanonical() {
        if (this.isAbsolute()) {
            URI uRI = this.uri.normalize();
            if (uRI == this.uri) {
                return this;
            }
            return URIPath.valueOf(uRI);
        }
        return this.getAbsolute().getCanonical();
    }

    public static String encodeForUri(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) >= 55296 && n3 < 56320 && n2 < n) {
                n3 = (n3 - 55296) * 1024 + (string.charAt(n2++) - 56320) + 65536;
            }
            if (c == 'H' ? n3 >= 32 && n3 <= 126 : n3 >= 97 && n3 <= 122 || n3 >= 65 && n3 <= 90 || n3 >= 48 && n3 <= 57 || n3 == 45 || n3 == 95 || n3 == 46 || n3 == 126 || c == 'I' && (n3 == 59 || n3 == 47 || n3 == 63 || n3 == 58 || n3 == 42 || n3 == 39 || n3 == 40 || n3 == 41 || n3 == 64 || n3 == 38 || n3 == 61 || n3 == 43 || n3 == 36 || n3 == 44 || n3 == 91 || n3 == 93 || n3 == 35 || n3 == 33 || n3 == 37)) {
                stringBuffer.append((char)n3);
                continue;
            }
            int n4 = stringBuffer.length();
            int n5 = 0;
            int n6 = n3 < 128 ? 1 : (n3 < 2048 ? 2 : (n3 < 65536 ? 3 : 4));
            do {
                int n7;
                int n8;
                int n9 = n8 = n5 == 0 ? 7 : 6 - n5;
                if (n3 < 1 << n8) {
                    n7 = n3;
                    if (n5 > 0) {
                        n7 |= 65408 >> n5 & 0xFF;
                    }
                    n3 = 0;
                } else {
                    n7 = 0x80 | n3 & 0x3F;
                    n3 >>= 6;
                }
                ++n5;
                for (int i = 0; i <= 1; ++i) {
                    int n10 = n7 & 0xF;
                    stringBuffer.insert(n4, (char)(n10 <= 9 ? n10 + 48 : n10 - 10 + 65));
                    n7 >>= 4;
                }
                stringBuffer.insert(n4, '%');
            } while (n3 != 0);
        }
        return stringBuffer.toString();
    }
}

