/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Location;
import gnu.mapping.Symbol;
import gnu.text.SourceLocator;

public class UnboundLocationException
extends RuntimeException {
    public Object symbol;
    Location location;
    String filename;
    int line;
    int column;

    public UnboundLocationException() {
    }

    public UnboundLocationException(Object object2) {
        this.symbol = object2;
    }

    public UnboundLocationException(Object object2, String string, int n, int n2) {
        this.symbol = object2;
        this.filename = string;
        this.line = n;
        this.column = n2;
    }

    public UnboundLocationException(Object object2, SourceLocator sourceLocator) {
        this.symbol = object2;
        if (sourceLocator != null) {
            this.filename = sourceLocator.getFileName();
            this.line = sourceLocator.getLineNumber();
            this.column = sourceLocator.getColumnNumber();
        }
    }

    public UnboundLocationException(Location location2) {
        this.location = location2;
    }

    public UnboundLocationException(Object object2, String string) {
        super(string);
        this.symbol = object2;
    }

    public void setLine(String string, int n, int n2) {
        this.filename = string;
        this.line = n;
        this.column = n2;
    }

    public String getMessage() {
        Symbol symbol;
        String string = super.getMessage();
        if (string != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filename != null || this.line > 0) {
            if (this.filename != null) {
                stringBuffer.append(this.filename);
            }
            if (this.line >= 0) {
                stringBuffer.append(':');
                stringBuffer.append(this.line);
                if (this.column > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(this.column);
                }
            }
            stringBuffer.append(": ");
        }
        Symbol symbol2 = symbol = this.location == null ? null : this.location.getKeySymbol();
        if (symbol != null) {
            stringBuffer.append("unbound location ");
            stringBuffer.append(symbol);
            Object object2 = this.location.getKeyProperty();
            if (object2 != null) {
                stringBuffer.append(" (property ");
                stringBuffer.append(object2);
                stringBuffer.append(')');
            }
        } else if (this.symbol != null) {
            stringBuffer.append("unbound location ");
            stringBuffer.append(this.symbol);
        } else {
            stringBuffer.append("unbound location");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getMessage();
    }
}

