/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.AttributePredicate;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.ElementPredicate;
import gnu.lists.ItemPredicate;
import gnu.lists.NodePredicate;
import gnu.lists.PositionConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.TreePosition;
import gnu.lists.XConsumer;
import gnu.text.Char;
import java.io.PrintWriter;

public class TreeList
extends AbstractSequence
implements Appendable,
XConsumer,
PositionConsumer,
Consumable {
    public Object[] objects;
    public int oindex;
    public char[] data;
    public int gapStart;
    public int gapEnd;
    public int attrStart;
    public int docStart;
    public static final int MAX_CHAR_SHORT = 40959;
    static final int MIN_INT_SHORT = -4096;
    static final int MAX_INT_SHORT = 8191;
    static final int INT_SHORT_ZERO = 49152;
    static final int OBJECT_REF_SHORT = 57344;
    static final int OBJECT_REF_SHORT_INDEX_MAX = 4095;
    static final char OBJECT_REF_FOLLOWS = '\uf10d';
    static final char POSITION_REF_FOLLOWS = '\uf10e';
    protected static final char POSITION_PAIR_FOLLOWS = '\uf10f';
    static final int BYTE_PREFIX = 61440;
    static final char BOOL_FALSE = '\uf100';
    static final char BOOL_TRUE = '\uf101';
    public static final int INT_FOLLOWS = 61698;
    static final int LONG_FOLLOWS = 61699;
    static final int FLOAT_FOLLOWS = 61700;
    static final int DOUBLE_FOLLOWS = 61701;
    static final int CHAR_FOLLOWS = 61702;
    static final int COMMENT = 61719;
    protected static final int PROCESSING_INSTRUCTION = 61716;
    static final int CDATA_SECTION = 61717;
    static final int JOINER = 61718;
    protected static final int BEGIN_ATTRIBUTE_LONG = 61705;
    public static final int BEGIN_ATTRIBUTE_LONG_SIZE = 5;
    static final int END_ATTRIBUTE = 61706;
    public static final int END_ATTRIBUTE_SIZE = 1;
    protected static final int BEGIN_DOCUMENT = 61712;
    protected static final int END_DOCUMENT = 61713;
    public static final int BEGIN_ENTITY = 61714;
    public static final int BEGIN_ENTITY_SIZE = 5;
    protected static final int END_ENTITY = 61715;
    protected static final int DOCUMENT_URI = 61720;
    protected static final int BEGIN_ELEMENT_SHORT = 40960;
    protected static final int BEGIN_ELEMENT_SHORT_INDEX_MAX = 4095;
    protected static final int END_ELEMENT_SHORT = 61707;
    protected static final int BEGIN_ELEMENT_LONG = 61704;
    protected static final int END_ELEMENT_LONG = 61708;
    int currentParent = -1;

    public TreeList() {
        this.resizeObjects();
        this.gapEnd = 200;
        this.data = new char[this.gapEnd];
    }

    public TreeList(TreeList treeList, int n, int n2) {
        this();
        treeList.consumeIRange(n, n2, this);
    }

    public TreeList(TreeList treeList) {
        this(treeList, 0, treeList.data.length);
    }

    public void clear() {
        this.gapStart = 0;
        this.gapEnd = this.data.length;
        this.attrStart = 0;
        if (this.gapEnd > 1500) {
            this.gapEnd = 200;
            this.data = new char[this.gapEnd];
        }
        this.objects = null;
        this.oindex = 0;
        this.resizeObjects();
    }

    public void ensureSpace(int n) {
        int n2 = this.gapEnd - this.gapStart;
        if (n > n2) {
            int n3;
            int n4 = this.data.length;
            int n5 = 2 * n4;
            int n6 = n4 - n2 + n;
            if (n5 < n6) {
                n5 = n6;
            }
            char[] cArray = new char[n5];
            if (this.gapStart > 0) {
                System.arraycopy(this.data, 0, cArray, 0, this.gapStart);
            }
            if ((n3 = n4 - this.gapEnd) > 0) {
                System.arraycopy(this.data, this.gapEnd, cArray, n5 - n3, n3);
            }
            this.gapEnd = n5 - n3;
            this.data = cArray;
        }
    }

    public final void resizeObjects() {
        Object[] objectArray;
        if (this.objects == null) {
            boolean bl = false;
            int n = 100;
            objectArray = new Object[n];
        } else {
            int n = this.objects.length;
            int n2 = 2 * n;
            objectArray = new Object[n2];
            System.arraycopy(this.objects, 0, objectArray, 0, n);
        }
        this.objects = objectArray;
    }

    public int find(Object object2) {
        if (this.oindex == this.objects.length) {
            this.resizeObjects();
        }
        this.objects[this.oindex] = object2;
        return this.oindex++;
    }

    protected final int getIntN(int n) {
        return this.data[n] << 16 | this.data[n + 1] & 0xFFFF;
    }

    protected final long getLongN(int n) {
        char[] cArray = this.data;
        return ((long)cArray[n] & 0xFFFFL) << 48 | ((long)cArray[n + 1] & 0xFFFFL) << 32 | ((long)cArray[n + 2] & 0xFFFFL) << 16 | (long)cArray[n + 3] & 0xFFFFL;
    }

    public final void setIntN(int n, int n2) {
        this.data[n] = (char)(n2 >> 16);
        this.data[n + 1] = (char)n2;
    }

    public void consume(SeqPosition seqPosition) {
        this.ensureSpace(3);
        int n = this.find(seqPosition.copy());
        this.data[this.gapStart++] = 61710;
        this.setIntN(this.gapStart, n);
        this.gapStart += 2;
    }

    public void writePosition(AbstractSequence abstractSequence, int n) {
        this.ensureSpace(5);
        this.data[this.gapStart] = 61711;
        int n2 = this.find(abstractSequence);
        this.setIntN(this.gapStart + 1, n2);
        this.setIntN(this.gapStart + 3, n);
        this.gapStart += 5;
    }

    public void writeObject(Object object2) {
        this.ensureSpace(3);
        int n = this.find(object2);
        if (n < 4096) {
            this.data[this.gapStart++] = (char)(0xE000 | n);
        } else {
            this.data[this.gapStart++] = 61709;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void writeDocumentUri(Object object2) {
        this.ensureSpace(3);
        int n = this.find(object2);
        this.data[this.gapStart++] = 61720;
        this.setIntN(this.gapStart, n);
        this.gapStart += 2;
    }

    public void writeComment(char[] cArray, int n, int n2) {
        this.ensureSpace(3 + n2);
        int n3 = this.gapStart;
        this.data[n3++] = 61719;
        this.setIntN(n3, n2);
        System.arraycopy(cArray, n, this.data, n3 += 2, n2);
        this.gapStart = n3 + n2;
    }

    public void writeComment(String string, int n, int n2) {
        this.ensureSpace(3 + n2);
        int n3 = this.gapStart;
        this.data[n3++] = 61719;
        this.setIntN(n3, n2);
        string.getChars(n, n + n2, this.data, n3 += 2);
        this.gapStart = n3 + n2;
    }

    public void writeProcessingInstruction(String string, char[] cArray, int n, int n2) {
        this.ensureSpace(5 + n2);
        int n3 = this.gapStart;
        this.data[n3++] = 61716;
        int n4 = this.find(string);
        this.setIntN(n3, n4);
        this.setIntN(n3 + 2, n2);
        System.arraycopy(cArray, n, this.data, n3 += 4, n2);
        this.gapStart = n3 + n2;
    }

    public void writeProcessingInstruction(String string, String string2, int n, int n2) {
        this.ensureSpace(5 + n2);
        int n3 = this.gapStart;
        this.data[n3++] = 61716;
        int n4 = this.find(string);
        this.setIntN(n3, n4);
        this.setIntN(n3 + 2, n2);
        string2.getChars(n, n + n2, this.data, n3 += 4);
        this.gapStart = n3 + n2;
    }

    public void startElement(Object object2) {
        this.startElement(this.find(object2));
    }

    public void startDocument() {
        this.ensureSpace(6);
        --this.gapEnd;
        int n = this.gapStart;
        this.data[n] = 61712;
        if (this.docStart != 0) {
            throw new Error("nested document");
        }
        this.docStart = n + 1;
        this.setIntN(n + 1, this.gapEnd - this.data.length);
        this.setIntN(n + 3, this.currentParent == -1 ? -1 : this.currentParent - n);
        this.currentParent = n;
        this.gapStart = n + 5;
        this.currentParent = n;
        this.data[this.gapEnd] = 61713;
    }

    public void endDocument() {
        if (this.data[this.gapEnd] != '\uf111' || this.docStart <= 0 || this.data[this.currentParent] != '\uf110') {
            throw new Error("unexpected endDocument");
        }
        ++this.gapEnd;
        this.setIntN(this.docStart, this.gapStart - this.docStart + 1);
        this.docStart = 0;
        this.data[this.gapStart++] = 61713;
        int n = this.getIntN(this.currentParent + 3);
        this.currentParent = n >= -1 ? n : this.currentParent + n;
    }

    public void beginEntity(Object object2) {
        if (this.gapStart != 0) {
            return;
        }
        this.ensureSpace(6);
        --this.gapEnd;
        int n = this.gapStart;
        this.data[n] = 61714;
        this.setIntN(n + 1, this.find(object2));
        this.setIntN(n + 3, this.currentParent == -1 ? -1 : this.currentParent - n);
        this.gapStart = n + 5;
        this.currentParent = n;
        this.data[this.gapEnd] = 61715;
    }

    public void endEntity() {
        if (this.gapEnd + 1 != this.data.length || this.data[this.gapEnd] != '\uf113') {
            return;
        }
        if (this.data[this.currentParent] != '\uf112') {
            throw new Error("unexpected endEntity");
        }
        ++this.gapEnd;
        this.data[this.gapStart++] = 61715;
        int n = this.getIntN(this.currentParent + 3);
        this.currentParent = n >= -1 ? n : this.currentParent + n;
    }

    public void startElement(int n) {
        this.ensureSpace(10);
        this.gapEnd -= 7;
        this.data[this.gapStart++] = 61704;
        this.setIntN(this.gapStart, this.gapEnd - this.data.length);
        this.gapStart += 2;
        this.data[this.gapEnd] = 61708;
        this.setIntN(this.gapEnd + 1, n);
        this.setIntN(this.gapEnd + 3, this.gapStart - 3);
        this.setIntN(this.gapEnd + 5, this.currentParent);
        this.currentParent = this.gapStart - 3;
    }

    public void setElementName(int n, int n2) {
        if (this.data[n] == '\uf108') {
            int n3;
            n = n3 + ((n3 = this.getIntN(n + 1)) < 0 ? this.data.length : n);
        }
        if (n < this.gapEnd) {
            throw new Error("setElementName before gapEnd");
        }
        this.setIntN(n + 1, n2);
    }

    public void endElement() {
        int n;
        if (this.data[this.gapEnd] != '\uf10c') {
            throw new Error("unexpected endElement");
        }
        int n2 = this.getIntN(this.gapEnd + 1);
        int n3 = this.getIntN(this.gapEnd + 3);
        this.currentParent = n = this.getIntN(this.gapEnd + 5);
        this.gapEnd += 7;
        int n4 = this.gapStart - n3;
        int n5 = n3 - n;
        if (n2 < 4095 && n4 < 65536 && n5 < 65536) {
            this.data[n3] = (char)(0xA000 | n2);
            this.data[n3 + 1] = (char)n4;
            this.data[n3 + 2] = (char)n5;
            this.data[this.gapStart] = 61707;
            this.data[this.gapStart + 1] = (char)n4;
            this.gapStart += 2;
        } else {
            this.data[n3] = 61704;
            this.setIntN(n3 + 1, n4);
            this.data[this.gapStart] = 61708;
            this.setIntN(this.gapStart + 1, n2);
            this.setIntN(this.gapStart + 3, -n4);
            if (n >= this.gapStart || n3 <= this.gapStart) {
                n -= this.gapStart;
            }
            this.setIntN(this.gapStart + 5, n);
            this.gapStart += 7;
        }
    }

    public void startAttribute(Object object2) {
        this.startAttribute(this.find(object2));
    }

    public void startAttribute(int n) {
        this.ensureSpace(6);
        --this.gapEnd;
        this.data[this.gapStart++] = 61705;
        if (this.attrStart != 0) {
            throw new Error("nested attribute");
        }
        this.attrStart = this.gapStart;
        this.setIntN(this.gapStart, n);
        this.setIntN(this.gapStart + 2, this.gapEnd - this.data.length);
        this.gapStart += 4;
        this.data[this.gapEnd] = 61706;
    }

    public void setAttributeName(int n, int n2) {
        this.setIntN(n + 1, n2);
    }

    public void endAttribute() {
        if (this.attrStart <= 0) {
            return;
        }
        if (this.data[this.gapEnd] != '\uf10a') {
            throw new Error("unexpected endAttribute");
        }
        ++this.gapEnd;
        this.setIntN(this.attrStart + 2, this.gapStart - this.attrStart + 1);
        this.attrStart = 0;
        this.data[this.gapStart++] = 61706;
    }

    public Consumer append(char c) {
        this.write(c);
        return this;
    }

    public void write(int n) {
        this.ensureSpace(3);
        if (n <= 40959) {
            this.data[this.gapStart++] = (char)n;
        } else if (n < 65536) {
            this.data[this.gapStart++] = 61702;
            this.data[this.gapStart++] = (char)n;
        } else {
            Char.print(n, this);
        }
    }

    public void writeBoolean(boolean bl) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = bl ? 61697 : 61696;
    }

    public void writeByte(int n) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = (char)(61440 + (n & 0xFF));
    }

    public void writeInt(int n) {
        this.ensureSpace(3);
        if (n >= -4096 && n <= 8191) {
            this.data[this.gapStart++] = (char)(49152 + n);
        } else {
            this.data[this.gapStart++] = 61698;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void writeLong(long l) {
        this.ensureSpace(5);
        this.data[this.gapStart++] = 61699;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public void writeFloat(float f) {
        this.ensureSpace(3);
        int n = Float.floatToIntBits(f);
        this.data[this.gapStart++] = 61700;
        this.data[this.gapStart++] = (char)(n >>> 16);
        this.data[this.gapStart++] = (char)n;
    }

    public void writeDouble(double d) {
        this.ensureSpace(5);
        long l = Double.doubleToLongBits(d);
        this.data[this.gapStart++] = 61701;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public boolean ignoring() {
        return false;
    }

    public void writeJoiner() {
        this.ensureSpace(1);
        this.data[this.gapStart++] = 61718;
    }

    public void write(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            this.writeJoiner();
        }
        this.ensureSpace(n2);
        while (n2 > 0) {
            char c = cArray[n++];
            --n2;
            if (c <= '\u9fff') {
                this.data[this.gapStart++] = c;
                continue;
            }
            this.write(c);
            this.ensureSpace(n2);
        }
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public void write(CharSequence charSequence, int n, int n2) {
        if (n2 == 0) {
            this.writeJoiner();
        }
        this.ensureSpace(n2);
        while (n2 > 0) {
            char c = charSequence.charAt(n++);
            --n2;
            if (c <= '\u9fff') {
                this.data[this.gapStart++] = c;
                continue;
            }
            this.write(c);
            this.ensureSpace(n2);
        }
    }

    public void writeCDATA(char[] cArray, int n, int n2) {
        this.ensureSpace(3 + n2);
        int n3 = this.gapStart;
        this.data[n3++] = 61717;
        this.setIntN(n3, n2);
        System.arraycopy(cArray, n, this.data, n3 += 2, n2);
        this.gapStart = n3 + n2;
    }

    public Consumer append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public Consumer append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        for (int i = n; i < n2; ++i) {
            this.append(charSequence.charAt(i));
        }
        return this;
    }

    public boolean isEmpty() {
        int n = this.gapStart == 0 ? this.gapEnd : 0;
        return n == this.data.length;
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while ((n2 = this.nextPos(n2)) != 0) {
            ++n;
        }
        return n;
    }

    public int createPos(int n, boolean bl) {
        return this.createRelativePos(0, n, bl);
    }

    public final int posToDataIndex(int n) {
        if (n == -1) {
            return this.data.length;
        }
        int n2 = n >>> 1;
        if ((n & 1) != 0) {
            --n2;
        }
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if ((n & 1) != 0) {
            if ((n2 = this.nextDataIndex(n2)) < 0) {
                return this.data.length;
            }
            if (n2 == this.gapStart) {
                n2 += this.gapEnd - this.gapStart;
            }
        }
        return n2;
    }

    public int firstChildPos(int n) {
        int n2 = this.gotoChildrenStart(this.posToDataIndex(n));
        if (n2 < 0) {
            return 0;
        }
        return n2 << 1;
    }

    public final int gotoChildrenStart(int n) {
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        if (c >= '\ua000' && c <= '\uafff' || c == '\uf108') {
            n += 3;
        } else if (c == '\uf110' || c == '\uf112') {
            n += 5;
        } else {
            return -1;
        }
        while (true) {
            if (n >= this.gapStart) {
                n += this.gapEnd - this.gapStart;
            }
            if ((c = this.data[n]) == '\uf109') {
                int n2;
                n = n2 + ((n2 = this.getIntN(n + 3)) < 0 ? this.data.length : n);
                continue;
            }
            if (c == '\uf10a' || c == '\uf116') {
                ++n;
                continue;
            }
            if (c != '\uf118') break;
            n += 3;
        }
        return n;
    }

    public int parentPos(int n) {
        int n2 = this.posToDataIndex(n);
        do {
            if ((n2 = this.parentOrEntityI(n2)) != -1) continue;
            return -1;
        } while (this.data[n2] == '\uf112');
        return n2 << 1;
    }

    public int parentOrEntityPos(int n) {
        int n2 = this.parentOrEntityI(this.posToDataIndex(n));
        return n2 < 0 ? -1 : n2 << 1;
    }

    public int parentOrEntityI(int n) {
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        if (c == '\uf110' || c == '\uf112') {
            int n2 = this.getIntN(n + 3);
            if (n2 >= -1) {
                return n2;
            }
            return n + n2;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            char c2 = this.data[n + 2];
            return c2 == '\u0000' ? -1 : n - c2;
        }
        if (c == '\uf108') {
            int n3;
            int n4;
            if ((n4 = this.getIntN((n3 += (n3 = this.getIntN(n + 1)) < 0 ? this.data.length : n) + 5)) == 0) {
                return -1;
            }
            if (n4 < 0) {
                n4 += n3;
            }
            return n4;
        }
        block6: while (true) {
            if (n == this.gapStart) {
                n = this.gapEnd;
            }
            if (n == this.data.length) {
                return -1;
            }
            c = this.data[n];
            switch (c) {
                case '\uf10b': {
                    return n - this.data[n + 1];
                }
                case '\uf10c': {
                    int n5 = this.getIntN(n + 3);
                    if (n5 < 0) {
                        n5 += n;
                    }
                    return n5;
                }
                case '\uf10a': {
                    ++n;
                    continue block6;
                }
                case '\uf111': {
                    return -1;
                }
            }
            if ((n = this.nextDataIndex(n)) < 0) break;
        }
        return -1;
    }

    public int getAttributeCount(int n) {
        int n2 = 0;
        int n3 = this.firstAttributePos(n);
        while (n3 != 0 && this.getNextKind(n3) == 35) {
            ++n2;
            n3 = this.nextPos(n3);
        }
        return n2;
    }

    public boolean gotoAttributesStart(TreePosition treePosition) {
        int n = this.gotoAttributesStart(treePosition.ipos >> 1);
        if (n < 0) {
            return false;
        }
        treePosition.push(this, n << 1);
        return true;
    }

    public int firstAttributePos(int n) {
        int n2 = this.gotoAttributesStart(this.posToDataIndex(n));
        return n2 < 0 ? 0 : n2 << 1;
    }

    public int gotoAttributesStart(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        if (c >= '\ua000' && c <= '\uafff' || c == '\uf108') {
            return n + 3;
        }
        return -1;
    }

    public Object get(int n) {
        int n2 = 0;
        while (--n >= 0) {
            if ((n2 = this.nextPos(n2)) != 0) continue;
            throw new IndexOutOfBoundsException();
        }
        return this.getPosNext(n2);
    }

    public boolean consumeNext(int n, Consumer consumer) {
        if (!this.hasNext(n)) {
            return false;
        }
        int n2 = this.posToDataIndex(n);
        int n3 = this.nextNodeIndex(n2, Integer.MAX_VALUE);
        if (n3 == n2) {
            n3 = this.nextDataIndex(n2);
        }
        if (n3 >= 0) {
            this.consumeIRange(n2, n3, consumer);
        }
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        this.consumeIRange(this.posToDataIndex(n), this.posToDataIndex(n2), consumer);
    }

    public int consumeIRange(int n, int n2, Consumer consumer) {
        int n3;
        block41: {
            char c;
            int n4;
            n3 = n;
            int n5 = n4 = n <= this.gapStart && n2 > this.gapStart ? this.gapStart : n2;
            block25: while (true) {
                int n6;
                int n7;
                if (n3 >= n4) {
                    if (n3 != this.gapStart || n2 <= this.gapEnd) break block41;
                    n3 = this.gapEnd;
                    n4 = n2;
                }
                if ((c = this.data[n3++]) <= '\u9fff') {
                    int n8 = n3 - 1;
                    n7 = n4;
                    while (n3 < n7) {
                        if ((c = this.data[n3++]) <= '\u9fff') continue;
                        --n3;
                        break;
                    }
                    consumer.write(this.data, n8, n3 - n8);
                    continue;
                }
                if (c >= '\ue000' && c <= '\uefff') {
                    consumer.writeObject(this.objects[c - 57344]);
                    continue;
                }
                if (c >= '\ua000' && c <= '\uafff') {
                    n6 = c - 40960;
                    consumer.startElement(this.objects[n6]);
                    n3 += 2;
                    continue;
                }
                if (c >= '\ub000' && c <= '\udfff') {
                    consumer.writeInt(c - 49152);
                    continue;
                }
                switch (c) {
                    case '\uf110': {
                        consumer.startDocument();
                        n3 += 4;
                        continue block25;
                    }
                    case '\uf111': {
                        consumer.endDocument();
                        continue block25;
                    }
                    case '\uf112': {
                        if (consumer instanceof TreeList) {
                            ((TreeList)consumer).beginEntity(this.objects[this.getIntN(n3)]);
                        }
                        n3 += 4;
                        continue block25;
                    }
                    case '\uf113': {
                        if (!(consumer instanceof TreeList)) continue block25;
                        ((TreeList)consumer).endEntity();
                        continue block25;
                    }
                    case '\uf118': {
                        if (consumer instanceof TreeList) {
                            ((TreeList)consumer).writeDocumentUri(this.objects[this.getIntN(n3)]);
                        }
                        n3 += 2;
                        continue block25;
                    }
                    case '\uf117': {
                        int n9 = this.getIntN(n3);
                        n3 += 2;
                        if (consumer instanceof XConsumer) {
                            ((XConsumer)consumer).writeComment(this.data, n3, n9);
                        }
                        n3 += n9;
                        continue block25;
                    }
                    case '\uf115': {
                        int n10 = this.getIntN(n3);
                        n3 += 2;
                        if (consumer instanceof XConsumer) {
                            ((XConsumer)consumer).writeCDATA(this.data, n3, n10);
                        } else {
                            consumer.write(this.data, n3, n10);
                        }
                        n3 += n10;
                        continue block25;
                    }
                    case '\uf114': {
                        String string = (String)this.objects[this.getIntN(n3)];
                        n7 = this.getIntN(n3 + 2);
                        n3 += 4;
                        if (consumer instanceof XConsumer) {
                            ((XConsumer)consumer).writeProcessingInstruction(string, this.data, n3, n7);
                        }
                        n3 += n7;
                        continue block25;
                    }
                    case '\uf100': 
                    case '\uf101': {
                        consumer.writeBoolean(c != '\uf100');
                        continue block25;
                    }
                    case '\uf116': {
                        consumer.write("");
                        continue block25;
                    }
                    case '\uf106': {
                        consumer.write(this.data, n3, '\u0001' + c - 61702);
                        ++n3;
                        continue block25;
                    }
                    case '\uf10f': {
                        AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n3)];
                        n7 = this.getIntN(n3 + 2);
                        if (consumer instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)consumer)).writePosition(abstractSequence, n7);
                        } else {
                            consumer.writeObject(abstractSequence.getIteratorAtPos(n7));
                        }
                        n3 += 4;
                        continue block25;
                    }
                    case '\uf10e': {
                        if (consumer instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)consumer)).consume((SeqPosition)this.objects[this.getIntN(n3)]);
                            n3 += 2;
                            continue block25;
                        }
                    }
                    case '\uf10d': {
                        consumer.writeObject(this.objects[this.getIntN(n3)]);
                        n3 += 2;
                        continue block25;
                    }
                    case '\uf10b': {
                        ++n3;
                        consumer.endElement();
                        continue block25;
                    }
                    case '\uf108': {
                        n6 = this.getIntN(n3);
                        n6 += n6 >= 0 ? n3 - 1 : this.data.length;
                        n3 += 2;
                        n6 = this.getIntN(n6 + 1);
                        consumer.startElement(this.objects[n6]);
                        continue block25;
                    }
                    case '\uf10c': {
                        n6 = this.getIntN(n3);
                        consumer.endElement();
                        n3 += 6;
                        continue block25;
                    }
                    case '\uf109': {
                        n6 = this.getIntN(n3);
                        consumer.startAttribute(this.objects[n6]);
                        n3 += 4;
                        continue block25;
                    }
                    case '\uf10a': {
                        consumer.endAttribute();
                        continue block25;
                    }
                    case '\uf102': {
                        consumer.writeInt(this.getIntN(n3));
                        n3 += 2;
                        continue block25;
                    }
                    case '\uf104': {
                        consumer.writeFloat(Float.intBitsToFloat(this.getIntN(n3)));
                        n3 += 2;
                        continue block25;
                    }
                    case '\uf103': {
                        consumer.writeLong(this.getLongN(n3));
                        n3 += 4;
                        continue block25;
                    }
                    case '\uf105': {
                        consumer.writeDouble(Double.longBitsToDouble(this.getLongN(n3)));
                        n3 += 4;
                        continue block25;
                    }
                }
                break;
            }
            throw new Error("unknown code:" + c);
        }
        return n3;
    }

    public void toString(String string, StringBuffer stringBuffer) {
        int n = 0;
        int n2 = this.gapStart;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block21: while (n < n2 || n == this.gapStart && (n = this.gapEnd) != (n2 = this.data.length)) {
            int n3;
            int n4;
            char c;
            if ((c = this.data[n++]) <= '\u9fff') {
                int n5 = n - 1;
                n4 = n2;
                while (n < n4) {
                    if ((c = this.data[n++]) <= '\u9fff') continue;
                    --n;
                    break;
                }
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                stringBuffer.append(this.data, n5, n - n5);
                bl = false;
                continue;
            }
            if (c >= '\ue000' && c <= '\uefff') {
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                if (bl) {
                    stringBuffer.append(string);
                } else {
                    bl = true;
                }
                stringBuffer.append(this.objects[c - 57344]);
                continue;
            }
            if (c >= '\ua000' && c <= '\uafff') {
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                n3 = c - 40960;
                if (bl) {
                    stringBuffer.append(string);
                }
                stringBuffer.append('<');
                stringBuffer.append(this.objects[n3].toString());
                n += 2;
                bl = false;
                bl2 = true;
                continue;
            }
            if (c >= '\ub000' && c <= '\udfff') {
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                if (bl) {
                    stringBuffer.append(string);
                } else {
                    bl = true;
                }
                stringBuffer.append(c - 49152);
                continue;
            }
            switch (c) {
                case '\uf110': 
                case '\uf112': {
                    n += 4;
                    continue block21;
                }
                case '\uf118': {
                    n += 2;
                    continue block21;
                }
                case '\uf117': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    n3 = this.getIntN(n);
                    stringBuffer.append("<!--");
                    stringBuffer.append(this.data, n += 2, n3);
                    stringBuffer.append("-->");
                    n += n3;
                    continue block21;
                }
                case '\uf115': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    n3 = this.getIntN(n);
                    stringBuffer.append("<![CDATA[");
                    stringBuffer.append(this.data, n += 2, n3);
                    stringBuffer.append("]]>");
                    n += n3;
                    continue block21;
                }
                case '\uf114': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    stringBuffer.append("<?");
                    n3 = this.getIntN(n);
                    stringBuffer.append(this.objects[n3]);
                    n3 = this.getIntN(n += 2);
                    n += 2;
                    if (n3 > 0) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this.data, n, n3);
                        n += n3;
                    }
                    stringBuffer.append("?>");
                    continue block21;
                }
                case '\uf111': 
                case '\uf113': {
                    continue block21;
                }
                case '\uf100': 
                case '\uf101': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(c != '\uf100');
                    continue block21;
                }
                case '\uf116': {
                    continue block21;
                }
                case '\uf106': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    stringBuffer.append(this.data, n, '\u0001' + c - 61702);
                    bl = false;
                    ++n;
                    continue block21;
                }
                case '\uf10f': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n)];
                    n4 = this.getIntN(n + 2);
                    stringBuffer.append(abstractSequence.getIteratorAtPos(n4));
                    n += 4;
                    continue block21;
                }
                case '\uf10d': 
                case '\uf10e': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(this.objects[this.getIntN(n)]);
                    n += 2;
                    continue block21;
                }
                case '\uf108': {
                    n3 = this.getIntN(n);
                    n3 += n3 >= 0 ? n - 1 : this.data.length;
                    n += 2;
                    n3 = this.getIntN(n3 + 1);
                    if (bl2) {
                        stringBuffer.append('>');
                    } else if (bl) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append('<');
                    stringBuffer.append(this.objects[n3]);
                    bl = false;
                    bl2 = true;
                    continue block21;
                }
                case '\uf10b': 
                case '\uf10c': {
                    if (c == '\uf10b') {
                        n3 = this.data[n++];
                        n3 = this.data[n - 2 - n3] - 40960;
                    } else {
                        n3 = this.getIntN(n);
                        n += 6;
                    }
                    if (bl2) {
                        stringBuffer.append("/>");
                    } else {
                        stringBuffer.append("</");
                        stringBuffer.append(this.objects[n3]);
                        stringBuffer.append('>');
                    }
                    bl2 = false;
                    bl = true;
                    continue block21;
                }
                case '\uf109': {
                    n3 = this.getIntN(n);
                    stringBuffer.append(' ');
                    stringBuffer.append(this.objects[n3]);
                    stringBuffer.append("=\"");
                    bl3 = true;
                    bl2 = false;
                    n += 4;
                    continue block21;
                }
                case '\uf10a': {
                    stringBuffer.append('\"');
                    bl3 = false;
                    bl2 = true;
                    bl = false;
                    continue block21;
                }
                case '\uf102': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(this.getIntN(n));
                    n += 2;
                    continue block21;
                }
                case '\uf104': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(Float.intBitsToFloat(this.getIntN(n)));
                    n += 2;
                    continue block21;
                }
                case '\uf103': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(this.getLongN(n));
                    n += 4;
                    continue block21;
                }
                case '\uf105': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(Double.longBitsToDouble(this.getLongN(n)));
                    n += 4;
                    continue block21;
                }
            }
            throw new Error("unknown code:" + c);
        }
    }

    public boolean hasNext(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return false;
        }
        char c = this.data[n2];
        return c != '\uf10a' && c != '\uf10b' && c != '\uf10c' && c != '\uf111';
    }

    public int getNextKind(int n) {
        return this.getNextKindI(this.posToDataIndex(n));
    }

    public int getNextKindI(int n) {
        if (n == this.data.length) {
            return 0;
        }
        char c = this.data[n];
        if (c <= '\u9fff') {
            return 29;
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return 32;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return 33;
        }
        if ((c & 0xFF00) == 61440) {
            return 28;
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return 22;
        }
        switch (c) {
            case '\uf100': 
            case '\uf101': {
                return 27;
            }
            case '\uf102': {
                return 22;
            }
            case '\uf103': {
                return 24;
            }
            case '\uf104': {
                return 25;
            }
            case '\uf105': {
                return 26;
            }
            case '\uf106': 
            case '\uf110': {
                return 34;
            }
            case '\uf112': {
                return this.getNextKind(n + 5 << 1);
            }
            case '\uf108': {
                return 33;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': 
            case '\uf113': {
                return 0;
            }
            case '\uf109': {
                return 35;
            }
            case '\uf115': {
                return 31;
            }
            case '\uf117': {
                return 36;
            }
            case '\uf114': {
                return 37;
            }
        }
        return 32;
    }

    public Object getNextTypeObject(int n) {
        char c;
        int n2 = this.posToDataIndex(n);
        while (true) {
            if (n2 == this.data.length) {
                return null;
            }
            c = this.data[n2];
            if (c != '\uf112') break;
            n2 += 5;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            n2 = c - 40960;
        } else if (c == '\uf108') {
            int n3;
            n2 = this.getIntN((n3 += (n3 = this.getIntN(n2 + 1)) < 0 ? this.data.length : n2) + 1);
        } else if (c == '\uf109') {
            n2 = this.getIntN(n2 + 1);
        } else if (c == '\uf114') {
            n2 = this.getIntN(n2 + 1);
        } else {
            return null;
        }
        return n2 < 0 ? null : this.objects[n2];
    }

    public String getNextTypeName(int n) {
        Object object2 = this.getNextTypeObject(n);
        return object2 == null ? null : object2.toString();
    }

    public Object getPosPrevious(int n) {
        if ((n & 1) != 0 && n != -1) {
            return this.getPosNext(n - 3);
        }
        return super.getPosPrevious(n);
    }

    private Object copyToList(int n, int n2) {
        return new TreeList(this, n, n2);
    }

    public int getPosNextInt(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 < this.data.length) {
            char c = this.data[n2];
            if (c >= '\ub000' && c <= '\udfff') {
                return c - 49152;
            }
            if (c == '\uf102') {
                return this.getIntN(n2 + 1);
            }
        }
        return ((Number)this.getPosNext(n)).intValue();
    }

    public Object getPosNext(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return Sequence.eofValue;
        }
        char c = this.data[n2];
        if (c <= '\u9fff') {
            return Convert.toObject(c);
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return this.objects[c - 57344];
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return this.copyToList(n2, n2 + this.data[n2 + 1] + 2);
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return Convert.toObject(c - 49152);
        }
        switch (c) {
            case '\uf110': {
                int n3 = this.getIntN(n2 + 1);
                n3 += n3 < 0 ? this.data.length : n2;
                return this.copyToList(n2, ++n3);
            }
            case '\uf100': 
            case '\uf101': {
                return Convert.toObject(c != '\uf100');
            }
            case '\uf102': {
                return Convert.toObject(this.getIntN(n2 + 1));
            }
            case '\uf103': {
                return Convert.toObject(this.getLongN(n2 + 1));
            }
            case '\uf104': {
                return Convert.toObject(Float.intBitsToFloat(this.getIntN(n2 + 1)));
            }
            case '\uf105': {
                return Convert.toObject(Double.longBitsToDouble(this.getLongN(n2 + 1)));
            }
            case '\uf106': {
                return Convert.toObject(this.data[n2 + 1]);
            }
            case '\uf109': {
                int n4 = this.getIntN(n2 + 3);
                return this.copyToList(n2, (n4 += n4 < 0 ? this.data.length : n2) + 1);
            }
            case '\uf108': {
                int n5 = this.getIntN(n2 + 1);
                return this.copyToList(n2, (n5 += n5 < 0 ? this.data.length : n2) + 7);
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': {
                return Sequence.eofValue;
            }
            case '\uf10d': 
            case '\uf10e': {
                return this.objects[this.getIntN(n2 + 1)];
            }
            case '\uf116': {
                return "";
            }
            case '\uf10f': {
                AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n2 + 1)];
                n = this.getIntN(n2 + 3);
                return abstractSequence.getIteratorAtPos(n);
            }
        }
        throw this.unsupported("getPosNext, code=" + Integer.toHexString(c));
    }

    public void stringValue(int n, int n2, StringBuffer stringBuffer) {
        int n3 = n;
        while (n3 < n2 && n3 >= 0) {
            n3 = this.stringValue(false, n3, stringBuffer);
        }
    }

    public int stringValue(int n, StringBuffer stringBuffer) {
        int n2 = this.nextNodeIndex(n, Integer.MAX_VALUE);
        if (n2 > n) {
            this.stringValue(n, n2, stringBuffer);
            return n;
        }
        return this.stringValue(false, n, stringBuffer);
    }

    public int stringValue(boolean bl, int n, StringBuffer stringBuffer) {
        Object object2 = null;
        int n2 = 0;
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        ++n;
        boolean bl2 = false;
        if (c <= '\u9fff') {
            stringBuffer.append(c);
            return n;
        }
        if (c >= '\ue000' && c <= '\uefff') {
            if (bl2) {
                stringBuffer.append(' ');
            }
            object2 = this.objects[c - 57344];
            bl2 = false;
        } else if (c >= '\ua000' && c <= '\uafff') {
            n2 = n + 2;
            n = this.data[n] + n + 1;
        } else {
            if ((c & 0xFF00) == 61440) {
                stringBuffer.append(c & 0xFF);
                return n;
            }
            if (c >= '\ub000' && c <= '\udfff') {
                stringBuffer.append(c - 49152);
                return n;
            }
            switch (c) {
                case '\uf118': {
                    return n + 2;
                }
                case '\uf114': {
                    n += 2;
                }
                case '\uf115': 
                case '\uf117': {
                    int n3 = this.getIntN(n);
                    n += 2;
                    if (!bl || c == '\uf115') {
                        stringBuffer.append(this.data, n, n3);
                    }
                    return n + n3;
                }
                case '\uf100': 
                case '\uf101': {
                    if (bl2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(c != '\uf100');
                    bl2 = true;
                    return n;
                }
                case '\uf102': {
                    if (bl2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(this.getIntN(n));
                    bl2 = true;
                    return n + 2;
                }
                case '\uf103': {
                    if (bl2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(this.getLongN(n));
                    bl2 = true;
                    return n + 4;
                }
                case '\uf104': {
                    if (bl2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(Float.intBitsToFloat(this.getIntN(n)));
                    bl2 = true;
                    return n + 2;
                }
                case '\uf105': {
                    if (bl2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(Double.longBitsToDouble(this.getLongN(n)));
                    bl2 = true;
                    return n + 4;
                }
                case '\uf106': {
                    bl2 = false;
                    stringBuffer.append(this.data[n]);
                    return n + 1;
                }
                case '\uf110': 
                case '\uf112': {
                    n2 = n + 4;
                    n = this.nextDataIndex(n - 1);
                    break;
                }
                case '\uf108': {
                    bl2 = false;
                    n2 = n + 2;
                    int n4 = this.getIntN(n);
                    n = (n4 += n4 < 0 ? this.data.length : n - 1) + 7;
                    break;
                }
                case '\uf116': {
                    bl2 = false;
                    break;
                }
                case '\uf10a': 
                case '\uf10b': 
                case '\uf10c': 
                case '\uf111': 
                case '\uf113': {
                    return -1;
                }
                case '\uf109': {
                    int n5;
                    if (!bl) {
                        n2 = n + 4;
                    }
                    n = n5 + ((n5 = this.getIntN(n + 2)) < 0 ? this.data.length + 1 : n);
                    break;
                }
                case '\uf10f': {
                    AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n)];
                    int n6 = this.getIntN(n + 2);
                    ((TreeList)abstractSequence).stringValue(bl, n6 >> 1, stringBuffer);
                    n += 4;
                    break;
                }
                default: {
                    throw new Error("unimplemented: " + Integer.toHexString(c) + " at:" + n);
                }
            }
        }
        if (object2 != null) {
            stringBuffer.append(object2);
        }
        if (n2 > 0) {
            while ((n2 = this.stringValue(true, n2, stringBuffer)) >= 0) {
            }
        }
        return n;
    }

    public int createRelativePos(int n, int n2, boolean bl) {
        if (bl) {
            if (n2 == 0) {
                if ((n & 1) != 0) {
                    return n;
                }
                if (n == 0) {
                    return 1;
                }
            }
            --n2;
        }
        if (n2 < 0) {
            throw this.unsupported("backwards createRelativePos");
        }
        int n3 = this.posToDataIndex(n);
        while (--n2 >= 0) {
            if ((n3 = this.nextDataIndex(n3)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        if (n3 >= this.gapEnd) {
            n3 -= this.gapEnd - this.gapStart;
        }
        return bl ? n3 + 1 << 1 | 1 : n3 << 1;
    }

    public final int nextNodeIndex(int n, int n2) {
        if ((n2 | Integer.MIN_VALUE) == -1) {
            n2 = this.data.length;
        }
        block7: while (true) {
            if (n == this.gapStart) {
                n = this.gapEnd;
            }
            if (n >= n2) {
                return n;
            }
            char c = this.data[n];
            if (c <= '\u9fff' || c >= '\ue000' && c <= '\uefff' || c >= '\ub000' && c <= '\udfff' || (c & 0xFF00) == 61440) {
                ++n;
                continue;
            }
            if (c >= '\ua000' && c <= '\uafff') {
                return n;
            }
            switch (c) {
                case '\uf118': {
                    n += 3;
                    continue block7;
                }
                case '\uf116': {
                    ++n;
                    continue block7;
                }
                case '\uf108': 
                case '\uf109': 
                case '\uf110': 
                case '\uf114': 
                case '\uf117': {
                    return n;
                }
                case '\uf112': {
                    n += 5;
                    continue block7;
                }
                case '\uf10a': 
                case '\uf10b': 
                case '\uf10c': 
                case '\uf111': 
                case '\uf113': {
                    return n;
                }
            }
            n = this.nextDataIndex(n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int nextMatching(int n, ItemPredicate itemPredicate, int n2, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n3 = this.posToDataIndex(n);
        int n4 = this.posToDataIndex(n2);
        int n5 = n3;
        if (itemPredicate instanceof NodePredicate) {
            n5 = this.nextNodeIndex(n5, n4);
        }
        boolean bl5 = false;
        if (itemPredicate instanceof ElementPredicate) {
            bl4 = true;
            bl3 = true;
            bl2 = false;
        } else if (itemPredicate instanceof AttributePredicate) {
            bl4 = true;
            bl3 = false;
            bl2 = false;
        } else {
            bl4 = true;
            bl3 = true;
            bl2 = true;
        }
        while (true) {
            int n6;
            block45: {
                char c;
                block44: {
                    if (n5 == this.gapStart) {
                        n5 = this.gapEnd;
                    }
                    if (n5 >= n4 && n4 != -1) {
                        return 0;
                    }
                    c = this.data[n5];
                    if (c > '\u9fff' && (c < '\ue000' || c > '\uefff') && (c < '\ub000' || c > '\udfff')) break block44;
                    if (bl2 && itemPredicate.isInstancePos(this, n5 << 1)) {
                        if (n5 < this.gapEnd) return n5 << 1;
                        n5 -= this.gapEnd - this.gapStart;
                        return n5 << 1;
                    }
                    n6 = n5 + 1;
                    break block45;
                }
                switch (c) {
                    case '\uf118': {
                        n6 = n5 + 3;
                        break block45;
                    }
                    case '\uf110': {
                        n6 = n5 + 5;
                        if (bl4) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf112': {
                        n6 = n5 + 5;
                        break block45;
                    }
                    case '\uf102': 
                    case '\uf10d': 
                    case '\uf10e': {
                        n6 = n5 + 3;
                        if (bl2) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf106': {
                        n6 = n5 + 2;
                        break block45;
                    }
                    case '\uf10b': {
                        if (!bl) {
                            return 0;
                        }
                        n6 = n5 + 2;
                        break block45;
                    }
                    case '\uf10f': {
                        n6 = n5 + 5;
                        if (bl2) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf10c': {
                        if (!bl) {
                            return 0;
                        }
                        n6 = n5 + 7;
                        break block45;
                    }
                    case '\uf10a': 
                    case '\uf111': {
                        if (!bl) {
                            return 0;
                        }
                    }
                    case '\uf113': {
                        n6 = n5 + 1;
                        break block45;
                    }
                    case '\uf109': {
                        int n7;
                        n6 = bl4 ? n7 + 1 + ((n7 = this.getIntN(n5 + 3)) < 0 ? this.data.length : n5) : n5 + 5;
                        if (bl5) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf100': 
                    case '\uf101': {
                        n6 = n5 + 1;
                        if (bl2) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf116': {
                        n6 = n5 + 1;
                        break block45;
                    }
                    case '\uf103': 
                    case '\uf105': {
                        n6 = n5 + 5;
                        if (bl2) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf114': {
                        n6 = n5 + 5 + this.getIntN(n5 + 3);
                        if (bl4) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf117': {
                        n6 = n5 + 3 + this.getIntN(n5 + 1);
                        if (bl4) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf115': {
                        n6 = n5 + 3 + this.getIntN(n5 + 1);
                        if (bl2) {
                            break;
                        }
                        break block45;
                    }
                    case '\uf108': {
                        int n7;
                        n6 = bl ? n5 + 3 : n7 + ((n7 = this.getIntN(n5 + 1)) < 0 ? this.data.length : n5) + 7;
                        if (bl3) {
                            break;
                        }
                        break block45;
                    }
                    default: {
                        if (c < '\ua000' || c > '\uafff') throw new Error("unknown code:" + c);
                        n6 = bl ? n5 + 3 : n5 + this.data[n5 + 1] + 2;
                        if (bl3) {
                            break;
                        }
                        break block45;
                    }
                }
                if (n5 > n3 && itemPredicate.isInstancePos(this, n5 << 1)) {
                    if (n5 < this.gapEnd) return n5 << 1;
                    n5 -= this.gapEnd - this.gapStart;
                    return n5 << 1;
                }
            }
            n5 = n6;
        }
    }

    public int nextPos(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return 0;
        }
        if (n2 >= this.gapEnd) {
            n2 -= this.gapEnd - this.gapStart;
        }
        return (n2 << 1) + 3;
    }

    public final int nextDataIndex(int n) {
        char c;
        if (n == this.gapStart) {
            n = this.gapEnd;
        }
        if (n == this.data.length) {
            return -1;
        }
        if ((c = this.data[n++]) <= '\u9fff' || c >= '\ue000' && c <= '\uefff' || c >= '\ub000' && c <= '\udfff') {
            return n;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return this.data[n] + n + 1;
        }
        switch (c) {
            case '\uf110': {
                int n2 = this.getIntN(n);
                return (n2 += n2 < 0 ? this.data.length : n - 1) + 1;
            }
            case '\uf112': {
                int n3 = n + 4;
                while (true) {
                    if (n3 == this.gapStart) {
                        n3 = this.gapEnd;
                    }
                    if (n3 == this.data.length) {
                        return -1;
                    }
                    if (this.data[n3] == '\uf113') {
                        return n3 + 1;
                    }
                    n3 = this.nextDataIndex(n3);
                }
            }
            case '\uf100': 
            case '\uf101': 
            case '\uf116': {
                return n;
            }
            case '\uf106': {
                return n + 1;
            }
            case '\uf102': 
            case '\uf10d': 
            case '\uf10e': {
                return n + 2;
            }
            case '\uf10f': {
                return n + 4;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': 
            case '\uf113': {
                return -1;
            }
            case '\uf108': {
                int n4 = this.getIntN(n);
                return (n4 += n4 < 0 ? this.data.length : n - 1) + 7;
            }
            case '\uf109': {
                int n5 = this.getIntN(n + 2);
                return (n5 += n5 < 0 ? this.data.length : n - 1) + 1;
            }
            case '\uf103': 
            case '\uf105': {
                return n + 4;
            }
            case '\uf114': {
                n += 2;
            }
            case '\uf115': 
            case '\uf117': {
                return n + 2 + this.getIntN(n);
            }
        }
        throw new Error("unknown code:" + Integer.toHexString(c));
    }

    public Object documentUriOfPos(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return null;
        }
        if (this.data[n2] == '\uf110') {
            int n3 = n2 + 5;
            if (n3 == this.gapStart) {
                n3 = this.gapEnd;
            }
            if (n3 < this.data.length && this.data[n3] == '\uf118') {
                return this.objects[this.getIntN(n3 + 1)];
            }
        }
        return null;
    }

    public int compare(int n, int n2) {
        int n3;
        int n4 = this.posToDataIndex(n);
        return n4 < (n3 = this.posToDataIndex(n2)) ? -1 : (n4 > n3 ? 1 : 0);
    }

    protected int getIndexDifference(int n, int n2) {
        int n3;
        int n4 = this.posToDataIndex(n2);
        int n5 = this.posToDataIndex(n);
        boolean bl = false;
        if (n4 > n5) {
            bl = true;
            n3 = n5;
            n5 = n4;
            n4 = n3;
        }
        n3 = 0;
        while (n4 < n5) {
            n4 = this.nextDataIndex(n4);
            ++n3;
        }
        return bl ? -n3 : n3;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public void consume(Consumer consumer) {
        this.consumeIRange(0, this.data.length, consumer);
    }

    public void statistics() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.statistics(printWriter);
        printWriter.flush();
    }

    public void statistics(PrintWriter printWriter) {
        printWriter.print("data array length: ");
        printWriter.println(this.data.length);
        printWriter.print("data array gap: ");
        printWriter.println(this.gapEnd - this.gapStart);
        printWriter.print("object array length: ");
        printWriter.println(this.objects.length);
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println(this.getClass().getName() + " @" + Integer.toHexString(System.identityHashCode(this)) + " gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + " length:" + this.data.length);
        this.dump(printWriter, 0, this.data.length);
    }

    public void dump(PrintWriter printWriter, int n, int n2) {
        int n3 = 0;
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            if (i >= this.gapStart && i < this.gapEnd) continue;
            int n4 = this.data[i];
            printWriter.print("" + i + ": 0x" + Integer.toHexString(n4) + '=' + (short)n4);
            if (--n3 < 0) {
                int n5;
                Object object2;
                if (n4 <= 40959) {
                    if (n4 >= 32 && n4 < 127) {
                        printWriter.print("='" + (char)n4 + "'");
                    } else if (n4 == 10) {
                        printWriter.print("='\\n'");
                    } else {
                        printWriter.print("='\\u" + Integer.toHexString(n4) + "'");
                    }
                } else if (n4 >= 57344 && n4 <= 61439) {
                    object2 = this.objects[n4 -= 57344];
                    printWriter.print("=Object#" + n4 + '=' + object2 + ':' + object2.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object2)));
                } else if (n4 >= 40960 && n4 <= 45055) {
                    n5 = this.data[i + 1] + i;
                    printWriter.print("=BEGIN_ELEMENT_SHORT end:" + n5 + " index#" + (n4 -= 40960) + "=<" + this.objects[n4] + '>');
                    n3 = 2;
                } else if (n4 >= 45056 && n4 <= 57343) {
                    printWriter.print("= INT_SHORT:" + (n4 - 49152));
                } else {
                    switch (n4) {
                        case 61698: {
                            n5 = this.getIntN(i + 1);
                            printWriter.print("=INT_FOLLOWS value:" + n5);
                            n3 = 2;
                            break;
                        }
                        case 61699: {
                            long l = this.getLongN(i + 1);
                            printWriter.print("=LONG_FOLLOWS value:" + l);
                            n3 = 4;
                            break;
                        }
                        case 61700: {
                            n5 = this.getIntN(i + 1);
                            printWriter.write("=FLOAT_FOLLOWS value:" + Float.intBitsToFloat(n5));
                            n3 = 2;
                            break;
                        }
                        case 61701: {
                            long l = this.getLongN(i + 1);
                            printWriter.print("=DOUBLE_FOLLOWS value:" + Double.longBitsToDouble(l));
                            n3 = 4;
                            break;
                        }
                        case 61712: {
                            n5 = this.getIntN(i + 1);
                            int n6 = n5 < 0 ? this.data.length : i;
                            printWriter.print("=BEGIN_DOCUMENT end:");
                            printWriter.print(n5 += n6);
                            printWriter.print(" parent:");
                            n5 = this.getIntN(i + 3);
                            printWriter.print(n5);
                            n3 = 4;
                            break;
                        }
                        case 61714: {
                            n5 = this.getIntN(i + 1);
                            printWriter.print("=BEGIN_ENTITY base:");
                            printWriter.print(n5);
                            printWriter.print(" parent:");
                            n5 = this.getIntN(i + 3);
                            printWriter.print(n5);
                            n3 = 4;
                            break;
                        }
                        case 61715: {
                            printWriter.print("=END_ENTITY");
                            break;
                        }
                        case 61720: {
                            printWriter.print("=DOCUMENT_URI: ");
                            n5 = this.getIntN(i + 1);
                            printWriter.print(this.objects[n5]);
                            n3 = 2;
                            break;
                        }
                        case 61719: {
                            printWriter.print("=COMMENT: '");
                            n5 = this.getIntN(i + 1);
                            printWriter.write(this.data, i + 3, n5);
                            printWriter.print('\'');
                            n3 = 2 + n5;
                            break;
                        }
                        case 61717: {
                            printWriter.print("=CDATA: '");
                            n5 = this.getIntN(i + 1);
                            printWriter.write(this.data, i + 3, n5);
                            printWriter.print('\'');
                            n3 = 2 + n5;
                            break;
                        }
                        case 61716: {
                            printWriter.print("=PROCESSING_INSTRUCTION: ");
                            n5 = this.getIntN(i + 1);
                            printWriter.print(this.objects[n5]);
                            printWriter.print(" '");
                            n5 = this.getIntN(i + 3);
                            printWriter.write(this.data, i + 5, n5);
                            printWriter.print('\'');
                            n3 = 4 + n5;
                            break;
                        }
                        case 61713: {
                            printWriter.print("=END_DOCUMENT");
                            break;
                        }
                        case 61696: {
                            printWriter.print("= false");
                            break;
                        }
                        case 61697: {
                            printWriter.print("= true");
                            break;
                        }
                        case 61718: {
                            printWriter.print("= joiner");
                            break;
                        }
                        case 61702: {
                            printWriter.print("=CHAR_FOLLOWS");
                            n3 = 1;
                            break;
                        }
                        case 61709: 
                        case 61710: {
                            n3 = 2;
                            break;
                        }
                        case 61707: {
                            printWriter.print("=END_ELEMENT_SHORT begin:");
                            n5 = i - this.data[i + 1];
                            printWriter.print(n5);
                            n5 = this.data[n5] - 40960;
                            printWriter.print(" -> #");
                            printWriter.print(n5);
                            printWriter.print("=<");
                            printWriter.print(this.objects[n5]);
                            printWriter.print('>');
                            n3 = 1;
                            break;
                        }
                        case 61704: {
                            n5 = this.getIntN(i + 1);
                            int n7 = n5 < 0 ? this.data.length : i;
                            printWriter.print("=BEGIN_ELEMENT_LONG end:");
                            printWriter.print(n5 += n7);
                            n5 = this.getIntN(n5 + 1);
                            printWriter.print(" -> #");
                            printWriter.print(n5);
                            if (n5 >= 0 && n5 + 1 < this.objects.length) {
                                printWriter.print("=<" + this.objects[n5] + '>');
                            } else {
                                printWriter.print("=<out-of-bounds>");
                            }
                            n3 = 2;
                            break;
                        }
                        case 61708: {
                            n5 = this.getIntN(i + 1);
                            printWriter.print("=END_ELEMENT_LONG name:" + n5 + "=<" + this.objects[n5] + '>');
                            n5 = this.getIntN(i + 3);
                            n5 = n5 < 0 ? i + n5 : n5;
                            printWriter.print(" begin:" + n5);
                            n5 = this.getIntN(i + 5);
                            n5 = n5 < 0 ? i + n5 : n5;
                            printWriter.print(" parent:" + n5);
                            n3 = 6;
                            break;
                        }
                        case 61705: {
                            n5 = this.getIntN(i + 1);
                            printWriter.print("=BEGIN_ATTRIBUTE name:" + n5 + "=" + this.objects[n5]);
                            n5 = this.getIntN(i + 3);
                            printWriter.print(" end:" + (n5 += n5 < 0 ? this.data.length : i));
                            n3 = 4;
                            break;
                        }
                        case 61706: {
                            printWriter.print("=END_ATTRIBUTE");
                            break;
                        }
                        case 61711: {
                            printWriter.print("=POSITION_PAIR_FOLLOWS seq:");
                            n5 = this.getIntN(i + 1);
                            printWriter.print(n5);
                            printWriter.print('=');
                            object2 = this.objects[n5];
                            printWriter.print(object2 == null ? null : object2.getClass().getName());
                            printWriter.print('@');
                            if (object2 == null) {
                                printWriter.print("null");
                            } else {
                                printWriter.print(Integer.toHexString(System.identityHashCode(object2)));
                            }
                            printWriter.print(" ipos:");
                            printWriter.print(this.getIntN(i + 3));
                            n3 = 4;
                        }
                    }
                }
            }
            printWriter.println();
            if (!bl || n3 <= 0) continue;
            i += n3;
            n3 = 0;
        }
    }
}

