/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;

public class FVector
extends SimpleVector
implements Externalizable,
Consumable,
Comparable {
    public Object[] data;
    protected static Object[] empty = new Object[0];

    public FVector() {
        this.data = empty;
    }

    public FVector(int n) {
        this.size = n;
        this.data = new Object[n];
    }

    public FVector(int n, Object object2) {
        Object[] objectArray = new Object[n];
        if (object2 != null) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = object2;
            }
        }
        this.data = objectArray;
        this.size = n;
    }

    public FVector(Object[] objectArray) {
        this.size = objectArray.length;
        this.data = objectArray;
    }

    public FVector(List list) {
        this.data = new Object[list.size()];
        this.addAll((Collection)list);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.data, 0, objectArray, 0, n2 < n ? n2 : n);
            this.data = objectArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public void shift(int n, int n2, int n3) {
        System.arraycopy(this.data, n, this.data, n2, n3);
    }

    public final Object getBuffer(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final Object setBuffer(int n, Object object2) {
        Object object3 = this.data[n];
        this.data[n] = object2;
        return object3;
    }

    protected void clearBuffer(int n, int n2) {
        Object[] objectArray = this.data;
        while (--n2 >= 0) {
            objectArray[n++] = null;
        }
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof FVector)) {
            return false;
        }
        FVector fVector = (FVector)object2;
        int n = this.size;
        if (fVector.data == null || fVector.size != n) {
            return false;
        }
        Object[] objectArray = this.data;
        Object[] objectArray2 = fVector.data;
        for (int i = 0; i < n; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object2) {
        FVector fVector = (FVector)object2;
        Object[] objectArray = this.data;
        Object[] objectArray2 = fVector.data;
        int n = this.size;
        int n2 = fVector.size;
        int n3 = n > n2 ? n2 : n;
        for (int i = 0; i < n3; ++i) {
            Comparable comparable = (Comparable)objectArray[i];
            Comparable comparable2 = (Comparable)objectArray2[i];
            int n4 = comparable.compareTo(comparable2);
            if (n4 == 0) continue;
            return n4;
        }
        return n - n2;
    }

    public final void setAll(Object object2) {
        Object[] objectArray = this.data;
        int n = this.size;
        while (--n >= 0) {
            objectArray[n] = object2;
        }
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeObject(this.data[n2]);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        if (n4 > this.size) {
            n4 = this.size;
        }
        while (n3 < n4) {
            consumer.writeObject(this.data[n3]);
            ++n3;
        }
    }

    public void consume(Consumer consumer) {
        consumer.startElement("#vector");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            consumer.writeObject(this.data[i]);
        }
        consumer.endElement();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeObject(this.data[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectInput.readObject();
        }
        this.size = n;
        this.data = objectArray;
    }
}

