/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.reflect.Invoke;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.regex.Pattern;

public class ReaderDispatchMisc
extends ReadTableEntry {
    protected int code;
    private static ReaderDispatchMisc instance = new ReaderDispatchMisc();

    public static ReaderDispatchMisc getInstance() {
        return instance;
    }

    public ReaderDispatchMisc() {
        this.code = -1;
    }

    public ReaderDispatchMisc(int n) {
        this.code = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Lexer lexer, int n, int n2) throws IOException, SyntaxException {
        LispReader lispReader = (LispReader)lexer;
        char c = '\u0000';
        if (this.code >= 0) {
            n = this.code;
        }
        switch (n) {
            case 58: {
                int n3 = lispReader.tokenBufferLength;
                lispReader.readToken(lispReader.read(), 'P', ReadTable.getCurrent());
                int n4 = lispReader.tokenBufferLength - n3;
                String string = new String(lispReader.tokenBuffer, n3, n4);
                lispReader.tokenBufferLength = n3;
                return Keyword.make(string.intern());
            }
            case 92: {
                return LispReader.readCharacter(lispReader);
            }
            case 33: {
                return LispReader.readSpecial(lispReader);
            }
            case 84: {
                return Boolean.TRUE;
            }
            case 70: {
                n = lexer.peek();
                if (Character.isDigit((char)n)) {
                    return LispReader.readSimpleVector(lispReader, 'F');
                }
                return Boolean.FALSE;
            }
            case 83: 
            case 85: {
                return LispReader.readSimpleVector(lispReader, (char)n);
            }
            case 82: {
                if (n2 > 36) {
                    lexer.error("the radix " + n2 + " is too big (max is 36)");
                    n2 = 36;
                }
                return LispReader.readNumberWithRadix(0, lispReader, n2);
            }
            case 88: {
                return LispReader.readNumberWithRadix(0, lispReader, 16);
            }
            case 68: {
                return LispReader.readNumberWithRadix(0, lispReader, 10);
            }
            case 79: {
                return LispReader.readNumberWithRadix(0, lispReader, 8);
            }
            case 66: {
                return LispReader.readNumberWithRadix(0, lispReader, 2);
            }
            case 69: 
            case 73: {
                lispReader.tokenBufferAppend(35);
                lispReader.tokenBufferAppend(n);
                return LispReader.readNumberWithRadix(2, lispReader, 0);
            }
            case 47: {
                return ReaderDispatchMisc.readRegex(lexer, n, n2);
            }
            case 124: {
                LineBufferedReader lineBufferedReader = lispReader.getPort();
                if (lineBufferedReader instanceof InPort) {
                    c = ((InPort)lineBufferedReader).readState;
                    ((InPort)lineBufferedReader).readState = (char)124;
                }
                try {
                    lispReader.readNestedComment('#', '|');
                }
                finally {
                    if (lineBufferedReader instanceof InPort) {
                        ((InPort)lineBufferedReader).readState = c;
                    }
                }
                return Values.empty;
            }
            case 59: {
                LineBufferedReader lineBufferedReader = lispReader.getPort();
                if (lineBufferedReader instanceof InPort) {
                    c = ((InPort)lineBufferedReader).readState;
                    ((InPort)lineBufferedReader).readState = (char)59;
                }
                try {
                    lispReader.readObject();
                }
                finally {
                    if (lineBufferedReader instanceof InPort) {
                        ((InPort)lineBufferedReader).readState = c;
                    }
                }
                return Values.empty;
            }
            case 44: {
                Object object2;
                int n5;
                LineBufferedReader lineBufferedReader = lispReader.getPort();
                if (lineBufferedReader.peek() == 40 && (n5 = LList.listLength(object2 = lispReader.readObject(), false)) > 0 && ((Pair)object2).getCar() instanceof String) {
                    String string = (String)((Pair)object2).getCar();
                    Object object3 = ReadTable.getCurrent().getReaderCtor(string);
                    if (object3 == null) {
                        lexer.error("unknown reader constructor " + string);
                    } else if (!(object3 instanceof Procedure) && !(object3 instanceof Type)) {
                        lexer.error("reader constructor must be procedure or type name");
                    } else {
                        int n6 = object3 instanceof Type ? 1 : 0;
                        Object[] objectArray = new Object[n6 + --n5];
                        Object object4 = ((Pair)object2).getCdr();
                        for (int i = 0; i < n5; ++i) {
                            Pair pair = (Pair)object4;
                            objectArray[n6 + i] = pair.getCar();
                            object4 = pair.getCdr();
                        }
                        try {
                            if (n6 > 0) {
                                objectArray[0] = object3;
                                return Invoke.make.applyN(objectArray);
                            }
                            return ((Procedure)object3).applyN(objectArray);
                        }
                        catch (Throwable throwable) {
                            lexer.error("caught " + throwable + " applying reader constructor " + string);
                        }
                    }
                } else {
                    lexer.error("a non-empty list starting with a symbol must follow #,");
                }
                return Boolean.FALSE;
            }
        }
        lexer.error("An invalid #-construct was read.");
        return Values.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern readRegex(Lexer lexer, int n, int n2) throws IOException, SyntaxException {
        int n3 = lexer.tokenBufferLength;
        LineBufferedReader lineBufferedReader = lexer.getPort();
        char c = '\u0000';
        int n4 = 0;
        if (lineBufferedReader instanceof InPort) {
            c = ((InPort)lineBufferedReader).readState;
            ((InPort)lineBufferedReader).readState = (char)47;
        }
        try {
            int n5;
            while (true) {
                if ((n5 = lineBufferedReader.read()) < 0) {
                    lexer.eofError("unexpected EOF in regex literal");
                }
                if (n5 == n) break;
                if (n5 == 92) {
                    n5 = lineBufferedReader.read();
                    if ((n5 == 32 || n5 == 9 || n5 == 13 || n5 == 10) && lexer instanceof LispReader && (n5 = ((LispReader)lexer).readEscape(n5)) == -2) continue;
                    if (n5 < 0) {
                        lexer.eofError("unexpected EOF in regex literal");
                    }
                    if (n5 != n) {
                        lexer.tokenBufferAppend(92);
                    }
                }
                lexer.tokenBufferAppend(n5);
            }
            String string = new String(lexer.tokenBuffer, n3, lexer.tokenBufferLength - n3);
            while (true) {
                if ((n5 = lexer.peek()) == 105 || n5 == 73) {
                    n4 |= 0x42;
                } else if (n5 == 115 || n5 == 83) {
                    n4 |= 0x20;
                } else if (n5 == 109 || n5 == 77) {
                    n4 |= 8;
                } else {
                    if (!Character.isLetter(n5)) break;
                    lexer.error("unrecognized regex option '" + (char)n5 + '\'');
                }
                lexer.skip();
            }
            Pattern pattern = Pattern.compile(string, n4);
            return pattern;
        }
        finally {
            lexer.tokenBufferLength = n3;
            if (lineBufferedReader instanceof InPort) {
                ((InPort)lineBufferedReader).readState = c;
            }
        }
    }
}

