/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.expr.Keyword;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XmlNamespace;
import gnu.lists.AbstractFormat;
import gnu.lists.Array;
import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.SimpleVector;
import gnu.lists.Strings;
import gnu.mapping.Namespace;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.text.Char;
import gnu.text.Printable;
import java.io.PrintWriter;
import java.net.URI;
import java.util.regex.Pattern;

public class DisplayFormat
extends AbstractFormat {
    public static final ThreadLocation outBase = new ThreadLocation("out-base");
    public static final ThreadLocation outRadix;
    boolean readable;
    char language;
    static Pattern r5rsIdentifierMinusInteriorColons;

    public DisplayFormat(boolean bl, char c) {
        this.readable = bl;
        this.language = c;
    }

    public static DisplayFormat getEmacsLispFormat(boolean bl) {
        return new DisplayFormat(bl, 'E');
    }

    public static DisplayFormat getCommonLispFormat(boolean bl) {
        return new DisplayFormat(bl, 'C');
    }

    public static DisplayFormat getSchemeFormat(boolean bl) {
        return new DisplayFormat(bl, 'S');
    }

    public boolean getReadableOutput() {
        return this.readable;
    }

    public void writeBoolean(boolean bl, Consumer consumer) {
        this.write(this.language == 'S' ? (bl ? "#t" : "#f") : (bl ? "t" : "nil"), consumer);
    }

    public void write(int n, Consumer consumer) {
        if (!this.getReadableOutput()) {
            Char.print(n, consumer);
        } else if (this.language == 'E' && n > 32) {
            consumer.write(63);
            Char.print(n, consumer);
        } else {
            this.write(Char.toScmReadableString(n), consumer);
        }
    }

    public void writeList(LList lList, OutPort outPort) {
        Object object2 = lList;
        outPort.startLogicalBlock("(", false, ")");
        while (object2 instanceof Pair) {
            if (object2 != lList) {
                outPort.writeSpaceFill();
            }
            Pair pair = (Pair)object2;
            this.writeObject(pair.getCar(), (Consumer)outPort);
            object2 = pair.getCdr();
        }
        if (object2 != LList.Empty) {
            outPort.writeSpaceFill();
            outPort.write(". ");
            this.writeObject(LList.checkNonList(object2), (Consumer)outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public void writeObject(Object object2, Consumer consumer) {
        boolean bl = false;
        if (!(!(consumer instanceof OutPort) || object2 instanceof UntypedAtomic || object2 instanceof Values || !this.getReadableOutput() && (object2 instanceof Char || object2 instanceof CharSequence || object2 instanceof Character))) {
            ((OutPort)consumer).writeWordStart();
            bl = true;
        }
        this.writeObjectRaw(object2, consumer);
        if (bl) {
            ((OutPort)consumer).writeWordEnd();
        }
    }

    public void writeObjectRaw(Object object2, Consumer consumer) {
        if (object2 instanceof Boolean) {
            this.writeBoolean((Boolean)object2, consumer);
        } else if (object2 instanceof Char) {
            this.write(((Char)object2).intValue(), consumer);
        } else if (object2 instanceof Character) {
            this.write(((Character)object2).charValue(), consumer);
        } else if (object2 instanceof Symbol) {
            Symbol symbol = (Symbol)object2;
            if (symbol.getNamespace() == XmlNamespace.HTML) {
                this.write("html:", consumer);
                this.write(symbol.getLocalPart(), consumer);
            } else {
                this.writeSymbol(symbol, consumer, this.readable);
            }
        } else if (object2 instanceof URI && this.getReadableOutput() && consumer instanceof PrintWriter) {
            this.write("#,(URI ", consumer);
            Strings.printQuoted(object2.toString(), (PrintWriter)((Object)consumer), 1);
            consumer.write(41);
        } else if (object2 instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object2;
            if (this.getReadableOutput() && consumer instanceof PrintWriter) {
                Strings.printQuoted(charSequence, (PrintWriter)((Object)consumer), 1);
            } else if (object2 instanceof String) {
                consumer.write((String)object2);
            } else if (object2 instanceof CharSeq) {
                CharSeq charSeq = (CharSeq)object2;
                charSeq.consume(0, charSeq.size(), consumer);
            } else {
                int n = charSequence.length();
                for (int i = 0; i < n; ++i) {
                    consumer.write(charSequence.charAt(i));
                }
            }
        } else if (object2 instanceof LList && consumer instanceof OutPort) {
            this.writeList((LList)object2, (OutPort)consumer);
        } else if (object2 instanceof SimpleVector) {
            String string;
            String string2;
            SimpleVector simpleVector = (SimpleVector)object2;
            String string3 = simpleVector.getTag();
            if (this.language == 'E') {
                string2 = "[";
                string = "]";
            } else {
                string2 = string3 == null ? "#(" : "#" + string3 + "(";
                string = ")";
            }
            if (consumer instanceof OutPort) {
                ((OutPort)consumer).startLogicalBlock(string2, false, string);
            } else {
                this.write(string2, consumer);
            }
            int n = simpleVector.size() << 1;
            for (int i = 0; i < n; i += 2) {
                if (i > 0 && consumer instanceof OutPort) {
                    ((OutPort)consumer).writeSpaceFill();
                }
                if (!simpleVector.consumeNext(i, consumer)) break;
            }
            if (consumer instanceof OutPort) {
                ((OutPort)consumer).endLogicalBlock(string);
            } else {
                this.write(string, consumer);
            }
        } else if (object2 instanceof Array) {
            this.write((Array)object2, 0, 0, consumer);
        } else if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(consumer);
        } else if (object2 instanceof Printable) {
            ((Printable)object2).print(consumer);
        } else if (object2 instanceof RatNum) {
            int n = 10;
            boolean bl = false;
            Object object3 = outBase.get(null);
            Object object4 = outRadix.get(null);
            if (object4 != null && (object4 == Boolean.TRUE || "yes".equals(object4.toString()))) {
                bl = true;
            }
            if (object3 instanceof Number) {
                n = ((IntNum)object3).intValue();
            } else if (object3 != null) {
                n = Integer.parseInt(object3.toString());
            }
            String string = ((RatNum)object2).toString(n);
            if (bl) {
                if (n == 16) {
                    this.write("#x", consumer);
                } else if (n == 8) {
                    this.write("#o", consumer);
                } else if (n == 2) {
                    this.write("#b", consumer);
                } else if (n != 10 || !(object2 instanceof IntNum)) {
                    this.write("#" + object3 + "r", consumer);
                }
            }
            this.write(string, consumer);
            if (bl && n == 10 && object2 instanceof IntNum) {
                this.write(".", consumer);
            }
        } else {
            String string;
            if (object2 == null) {
                string = null;
            } else {
                Class<?> clazz = object2.getClass();
                if (clazz.isArray()) {
                    int n = java.lang.reflect.Array.getLength(object2);
                    if (consumer instanceof OutPort) {
                        ((OutPort)consumer).startLogicalBlock("[", false, "]");
                    } else {
                        this.write("[", consumer);
                    }
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            this.write(" ", consumer);
                            if (consumer instanceof OutPort) {
                                ((OutPort)consumer).writeBreakFill();
                            }
                        }
                        this.writeObject(java.lang.reflect.Array.get(object2, i), consumer);
                    }
                    if (consumer instanceof OutPort) {
                        ((OutPort)consumer).endLogicalBlock("]");
                    } else {
                        this.write("]", consumer);
                    }
                    return;
                }
                string = object2.toString();
            }
            if (string == null) {
                this.write("#!null", consumer);
            } else {
                this.write(string, consumer);
            }
        }
    }

    int write(Array array, int n, int n2, Consumer consumer) {
        String string;
        int n3 = array.rank();
        int n4 = 0;
        String string2 = n2 > 0 ? "(" : (string = n3 == 1 ? "#(" : "#" + n3 + "a(");
        if (consumer instanceof OutPort) {
            ((OutPort)consumer).startLogicalBlock(string, false, ")");
        } else {
            this.write(string, consumer);
        }
        if (n3 > 0) {
            int n5 = array.getSize(n2);
            ++n2;
            for (int i = 0; i < n5; ++i) {
                int n6;
                if (i > 0) {
                    this.write(" ", consumer);
                    if (consumer instanceof OutPort) {
                        ((OutPort)consumer).writeBreakFill();
                    }
                }
                if (n2 == n3) {
                    this.writeObject(array.getRowMajor(n), consumer);
                    n6 = 1;
                } else {
                    n6 = this.write(array, n, n2, consumer);
                }
                n += n6;
                n4 += n6;
            }
        }
        if (consumer instanceof OutPort) {
            ((OutPort)consumer).endLogicalBlock(")");
        } else {
            this.write(")", consumer);
        }
        return n4;
    }

    void writeSymbol(Symbol symbol, Consumer consumer, boolean bl) {
        String string = symbol.getPrefix();
        Namespace namespace = symbol.getNamespace();
        String string2 = namespace == null ? null : namespace.getName();
        boolean bl2 = false;
        if (namespace == Keyword.keywordNamespace) {
            if (this.language == 'C' || this.language == 'E') {
                consumer.write(58);
            } else {
                bl2 = true;
            }
        } else if (string != null && string.length() > 0) {
            this.writeSymbol(string, consumer, bl);
            consumer.write(58);
        } else if (string2 != null && string2.length() > 0) {
            consumer.write(123);
            consumer.write(string2);
            consumer.write(125);
        }
        this.writeSymbol(symbol.getName(), consumer, bl);
        if (bl2) {
            consumer.write(58);
        }
    }

    void writeSymbol(String string, Consumer consumer, boolean bl) {
        if (bl && !r5rsIdentifierMinusInteriorColons.matcher(string).matches()) {
            int n = string.length();
            if (n == 0) {
                this.write("||", consumer);
            } else {
                boolean bl2 = false;
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '|') {
                        this.write(bl2 ? "|\\" : "\\", consumer);
                        bl2 = false;
                    } else if (!bl2) {
                        consumer.write(124);
                        bl2 = true;
                    }
                    consumer.write(c);
                }
                if (bl2) {
                    consumer.write(124);
                }
            }
            return;
        }
        this.write(string, consumer);
    }

    static {
        outBase.setGlobal(IntNum.ten());
        outRadix = new ThreadLocation("out-radix");
        r5rsIdentifierMinusInteriorColons = Pattern.compile("(([a-zA-Z]|[!$%&*/:<=>?^_~])([a-zA-Z]|[!$%&*/<=>?^_~]|[0-9]|([-+.@]))*[:]?)|([-+]|[.][.][.])");
    }
}

