/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.Member;
import java.io.DataOutputStream;
import java.io.IOException;

public class SignatureAttr
extends Attribute {
    String signature;
    int signature_index;

    public final String getSignature() {
        return this.signature;
    }

    protected void setSignature(String string) {
        this.signature = string;
        this.signature_index = 0;
    }

    public SignatureAttr(String string) {
        super("Signature");
        this.signature = string;
    }

    public SignatureAttr(int n, Member member) {
        super("Signature");
        ClassType classType = member instanceof ClassType ? (ClassType)member : member.getDeclaringClass();
        CpoolUtf8 cpoolUtf8 = (CpoolUtf8)classType.constants.getForced(n, 1);
        this.signature = cpoolUtf8.string;
        this.signature_index = n;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        if (this.signature_index == 0) {
            this.signature_index = classType.getConstants().addUtf8(this.signature).getIndex();
        }
    }

    public final int getLength() {
        return 2;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.signature_index);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        super.print(classTypeWriter);
        classTypeWriter.print("  ");
        classTypeWriter.printOptionalIndex(this.signature_index);
        classTypeWriter.print('\"');
        classTypeWriter.print(this.getSignature());
        classTypeWriter.println('\"');
    }
}

