/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.kawa.servlet.KawaServlet;
import gnu.kawa.servlet.ServletCallContext;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KawaPageServlet
extends KawaServlet {
    private static long LAST_MODIFIED_CACHE_TIME = 1000L;
    private static Map procedureCache = new WeakHashMap();
    private ServletContext context;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
    }

    public void apply(CallContext callContext) throws Throwable {
        ServletCallContext servletCallContext = (ServletCallContext)callContext;
        HttpServletRequest httpServletRequest = servletCallContext.request;
        HttpServletResponse httpServletResponse = servletCallContext.response;
        boolean bl = httpServletRequest.getParameter("qexo-save-class") != null;
        String string = httpServletRequest.getServletPath();
        Procedure procedure = this.getProcedure(servletCallContext, string, bl);
        if (procedure != null) {
            procedure.apply(servletCallContext);
        }
    }

    private Procedure getProcedure(ServletCallContext servletCallContext, String string, boolean bl) throws Exception {
        URL uRL = this.context.getResource(string);
        if (uRL == null) {
            servletCallContext.response.reset();
            servletCallContext.response.sendError(404, string);
            return null;
        }
        Map map2 = procedureCache;
        synchronized (map2) {
            Object object2;
            CacheEntry cacheEntry = this.getCacheEntry(string, uRL);
            if (cacheEntry.proc == null || bl) {
                Object object3;
                Compilation compilation;
                Interpreter interpreter;
                object2 = uRL.openStream();
                InPort inPort = new InPort((InputStream)object2, string.substring(string.lastIndexOf(47) + 1));
                Interpreter.defaultInterpreter = interpreter = Interpreter.getInstanceFromFilenameExtension(string);
                Environment.setCurrent(interpreter.getEnvironment());
                SourceMessages sourceMessages = new SourceMessages();
                try {
                    compilation = interpreter.parseFile(inPort, true, sourceMessages);
                    object3 = string.substring(string.lastIndexOf(47) + 1, string.indexOf(46));
                    compilation.getModule().setName((String)object3);
                }
                catch (SyntaxException syntaxException) {
                    if (syntaxException.getMessages() != sourceMessages) {
                        throw syntaxException;
                    }
                    compilation = null;
                }
                if (sourceMessages.seenErrors()) {
                    servletCallContext.response.reset();
                    object3 = servletCallContext.response.getOutputStream();
                    object3.print(sourceMessages.toString(20));
                    Procedure procedure = null;
                    return procedure;
                }
                object3 = ModuleExp.evalToClass(compilation);
                if (bl) {
                    compilation.outputClass(this.context.getRealPath("WEB-INF/classes") + '/');
                }
                cacheEntry.proc = (Procedure)((Class)object3).newInstance();
            }
            object2 = cacheEntry.proc;
            return object2;
        }
    }

    private CacheEntry getCacheEntry(String string, URL uRL) throws IOException {
        CacheEntry cacheEntry = (CacheEntry)procedureCache.get(string);
        long l = System.currentTimeMillis();
        if (cacheEntry != null && l - cacheEntry.lastCheck < LAST_MODIFIED_CACHE_TIME) {
            return cacheEntry;
        }
        long l2 = uRL.openConnection().getLastModified();
        if (cacheEntry != null) {
            if (cacheEntry.lastModified != l2) {
                cacheEntry.proc = null;
            }
        } else {
            cacheEntry = new CacheEntry();
            procedureCache.put(string, cacheEntry);
        }
        cacheEntry.lastCheck = l;
        cacheEntry.lastModified = l2;
        return cacheEntry;
    }

    static class CacheEntry {
        long lastCheck;
        long lastModified;
        Procedure proc;

        CacheEntry() {
        }
    }
}

