/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.kawa.functions.ObjectFormat;
import gnu.mapping.CallContext;
import gnu.mapping.FluidBinding;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.math.IntNum;
import java.io.IOException;
import java.io.PrintWriter;

public class TracedProcedure
extends ProcedureN {
    public Procedure proc;
    boolean enabled;
    static Symbol indentation = Symbol.makeUninterned(IntNum.zero(), "indentation");
    static int indentationStep = 2;

    public TracedProcedure(Procedure procedure, boolean bl) {
        this.proc = procedure;
        this.enabled = bl;
        String string = procedure.getName();
        if (string != null) {
            this.setName(string);
        }
    }

    static void put(Object object2, PrintWriter printWriter) {
        try {
            if (!ObjectFormat.format(object2, printWriter, 50, true)) {
                printWriter.print("...");
            }
        }
        catch (IOException iOException) {
            printWriter.print("<caught ");
            printWriter.print(iOException);
            printWriter.print('>');
        }
    }

    static void indent(int n, PrintWriter printWriter) {
        while (--n >= 0) {
            printWriter.print(' ');
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        if (this.enabled) {
            Object object2;
            int n = ((IntNum)indentation.getValue()).intValue();
            OutPort outPort = OutPort.errDefault();
            String string = this.getName();
            if (string == null) {
                string = "??";
            }
            TracedProcedure.indent(n, outPort);
            ((PrintWriter)outPort).print("call to ");
            ((PrintWriter)outPort).print(string);
            int n2 = objectArray.length;
            ((PrintWriter)outPort).print(" (");
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    ((PrintWriter)outPort).print(' ');
                }
                TracedProcedure.put(objectArray[i], outPort);
            }
            outPort.println(")");
            CallContext callContext = CallContext.getInstance();
            FluidBinding fluidBinding = callContext.fluidBindings;
            IntNum intNum = IntNum.make(n + indentationStep);
            FluidBinding fluidBinding2 = new FluidBinding(fluidBinding, intNum, indentation);
            try {
                callContext.setFluids(fluidBinding2);
                object2 = this.proc.applyN(objectArray);
            }
            catch (RuntimeException runtimeException) {
                TracedProcedure.indent(n, outPort);
                outPort.println("procedure " + string + " throws exception " + runtimeException);
                throw runtimeException;
            }
            finally {
                callContext.resetFluids(fluidBinding);
            }
            TracedProcedure.indent(n, outPort);
            ((PrintWriter)outPort).print("return from ");
            ((PrintWriter)outPort).print(string);
            ((PrintWriter)outPort).print(" => ");
            TracedProcedure.put(object2, outPort);
            outPort.println();
            return object2;
        }
        return this.proc.applyN(objectArray);
    }

    public static Procedure doTrace(Procedure procedure, boolean bl) {
        if (procedure instanceof TracedProcedure) {
            ((TracedProcedure)procedure).enabled = bl;
            return procedure;
        }
        return new TracedProcedure(procedure, bl);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<procedure ");
        String string = this.getName();
        if (string == null) {
            printWriter.print("<unnamed>");
        } else {
            printWriter.print(string);
        }
        printWriter.print(this.enabled ? ", traced>" : ">");
    }
}

