/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Type;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class ClassType
extends ObjectType
implements AttrContainer,
Externalizable {
    public static final int minor_version = 3;
    public static final int major_version = 45;
    int thisClassIndex;
    ClassType superClass;
    int superClassIndex = -1;
    ClassType[] interfaces;
    int[] interfaceIndexes;
    public int access_flags;
    Attribute attributes;
    public static final ClassType[] noClasses = new ClassType[0];
    boolean emitDebugInfo = true;
    ConstantPool constants;
    Field fields;
    int fields_count;
    Field last_field;
    int ConstantValue_name_index;
    int Code_name_index;
    int LocalVariableTable_name_index;
    int LineNumberTable_name_index;
    Method methods;
    int methods_count;
    Method last_method;
    public Method constructor;

    public static ClassType make(String string) {
        return (ClassType)Type.getType(string);
    }

    public static ClassType make(String string, ClassType classType) {
        ClassType classType2 = ClassType.make(string);
        if (classType2.superClass == null) {
            classType2.setSuper(classType);
        }
        return classType2;
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public final ConstantPool getConstants() {
        return this.constants;
    }

    public final CpoolEntry getConstant(int n) {
        if (this.constants == null || this.constants.pool == null || n > this.constants.count) {
            return null;
        }
        return this.constants.pool[n];
    }

    public final int getModifiers() {
        if (this.access_flags == 0 && (this.flags & 4) != 0 && this.getReflectClass() != null) {
            this.access_flags = this.reflectClass.getModifiers();
        }
        return this.access_flags;
    }

    public final void setModifiers(int n) {
        this.access_flags = n;
    }

    public void setName(String string) {
        this.this_name = string;
        string = string.replace('.', '/');
        this.setSignature("L" + string + ";");
    }

    public void setSourceFile(String string) {
        SourceFileAttr.setSourceFile(this, string);
    }

    public void setSuper(String string) {
        this.setSuper(string == null ? Type.pointer_type : ClassType.make(string));
    }

    public void setSuper(ClassType classType) {
        this.superClass = classType;
    }

    public ClassType getSuperclass() {
        if (this.superClass == null && !this.isInterface() && !"java.lang.Object".equals(this.getName()) && this.getReflectClass() != null) {
            this.superClass = (ClassType)ClassType.make(this.reflectClass.getSuperclass());
        }
        return this.superClass;
    }

    public String getPackageName() {
        String string = this.getName();
        int n = string.indexOf(46);
        return n < 0 ? string : string.substring(0, n);
    }

    public ClassType[] getInterfaces() {
        if (this.interfaces == null && (this.flags & 4) != 0 && this.getReflectClass() != null) {
            Class<?>[] classArray = this.reflectClass.getInterfaces();
            int n = classArray.length;
            this.interfaces = n == 0 ? noClasses : new ClassType[n];
            for (int i = 0; i < n; ++i) {
                this.interfaces[i] = (ClassType)Type.make(classArray[i]);
            }
        }
        return this.interfaces;
    }

    public void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public void addInterface(ClassType classType) {
        int n;
        if (this.interfaces == null || this.interfaces.length == 0) {
            n = 0;
            this.interfaces = new ClassType[1];
        } else {
            int n2 = n = this.interfaces.length;
            while (--n2 >= 0) {
                if (this.interfaces[n2] != classType) continue;
                return;
            }
            ClassType[] classTypeArray = new ClassType[n + 1];
            System.arraycopy(this.interfaces, 0, classTypeArray, 0, n);
            this.interfaces = classTypeArray;
        }
        this.interfaces[n] = classType;
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final void setInterface(boolean bl) {
        this.access_flags = bl ? (this.access_flags |= 0x200) : (this.access_flags &= 0xFFFFFDFF);
    }

    public ClassType() {
    }

    public ClassType(String string) {
        this.setName(string);
    }

    public final Field getFields() {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        return this.fields;
    }

    public final int getFieldCount() {
        return this.fields_count;
    }

    public Field getDeclaredField(String string) {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        Field field = this.fields;
        while (field != null) {
            if (string.equals(field.name)) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    public Field getField(String string) {
        ClassType classType = this;
        do {
            Field field;
            if ((field = classType.getDeclaredField(string)) == null) continue;
            return field;
        } while ((classType = classType.getSuperclass()) != null);
        return null;
    }

    public Field addField() {
        return new Field(this);
    }

    public Field addField(String string) {
        Field field = new Field(this);
        field.setName(string);
        return field;
    }

    public final Field addField(String string, Type type) {
        Field field = new Field(this);
        field.setName(string);
        field.setType(type);
        return field;
    }

    public final Field addField(String string, Type type, int n) {
        Field field = this.addField(string, type);
        field.flags = n;
        return field;
    }

    public void addFields() {
        java.lang.reflect.Field[] fieldArray;
        Class clazz = this.getReflectClass();
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            fieldArray = clazz.getFields();
        }
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            java.lang.reflect.Field field = fieldArray[i];
            if (!field.getDeclaringClass().equals(clazz) || ((n2 = field.getModifiers()) & 5) == 0) continue;
            this.addField(field.getName(), Type.make(field.getType()), n2);
        }
        this.flags |= 1;
    }

    public final Method getMethods() {
        return this.methods;
    }

    public final int getMethodCount() {
        return this.methods_count;
    }

    Method addMethod() {
        return new Method(this, 0);
    }

    public Method addMethod(String string) {
        Method method = new Method(this, 0);
        method.setName(string);
        return method;
    }

    public Method addMethod(String string, int n) {
        Method method = new Method(this, n);
        method.setName(string);
        return method;
    }

    public Method addMethod(String string, Type[] typeArray, Type type, int n) {
        return this.addMethod(string, n, typeArray, type);
    }

    public Method addMethod(String string, int n, Type[] typeArray, Type type) {
        Method method = this.getDeclaredMethod(string, typeArray);
        if (method != null && type.equals(method.getReturnType()) && (n & method.access_flags) == n) {
            return method;
        }
        method = new Method(this, n);
        method.setName(string);
        method.arg_types = typeArray;
        method.return_type = type;
        return method;
    }

    public Method addMethod(String string, String string2, int n) {
        Method method = this.addMethod(string, n);
        method.setSignature(string2);
        return method;
    }

    public Method getDeclaredMethods() {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        return this.methods;
    }

    public final int countMethods(Filter filter, int n) {
        return this.getMethods(filter, n, null, 0);
    }

    public Method[] getMethods(Filter filter, boolean bl) {
        return this.getMethods(filter, bl ? 1 : 0);
    }

    public Method[] getMethods(Filter filter, int n) {
        int n2 = this.getMethods(filter, n, null, 0);
        Method[] methodArray = new Method[n2];
        this.getMethods(filter, n, methodArray, 0);
        return methodArray;
    }

    public int getMethods(Filter filter, int n, Method[] methodArray, int n2) {
        int n3 = 0;
        for (ClassType classType = this; classType != null; classType = classType.getSuperclass()) {
            ClassType[] classTypeArray;
            for (classTypeArray = classType.getDeclaredMethods(); classTypeArray != null; classTypeArray = classTypeArray.getNext()) {
                if (!filter.select(classTypeArray)) continue;
                if (methodArray != null) {
                    methodArray[n2 + n3] = classTypeArray;
                }
                ++n3;
            }
            if (n == 0) break;
            if (n <= 1 || (classTypeArray = classType.getInterfaces()) == null) continue;
            for (int i = 0; i < classTypeArray.length; ++i) {
                n3 += classTypeArray[i].getMethods(filter, n, methodArray, n2 + n3);
            }
        }
        return n3;
    }

    public int getMethods(Filter filter, int n, Vector vector, String string) {
        int n2 = 0;
        for (ClassType classType = this; classType != null; classType = classType.getSuperclass()) {
            ClassType[] classTypeArray;
            if (string == null || (classType.getModifiers() & 1) != 0 || string.equals(classType.getPackageName())) {
                for (classTypeArray = classType.getDeclaredMethods(); classTypeArray != null; classTypeArray = classTypeArray.getNext()) {
                    if (!filter.select(classTypeArray)) continue;
                    if (vector != null) {
                        vector.addElement(classTypeArray);
                    }
                    ++n2;
                }
            }
            if (n == 0) break;
            if (n <= 1 || (classTypeArray = classType.getInterfaces()) == null) continue;
            for (int i = 0; i < classTypeArray.length; ++i) {
                n2 += classTypeArray[i].getMethods(filter, n, vector, string);
            }
        }
        return n2;
    }

    public Method getDeclaredMethod(String string, Type[] typeArray) {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        Method method = this.methods;
        while (method != null) {
            if (string.equals(method.getName())) {
                Type[] typeArray2 = method.getParameterTypes();
                if (typeArray == null || typeArray == typeArray2) {
                    return method;
                }
                int n = typeArray.length;
                if (n == typeArray2.length) {
                    while (--n >= 0 && typeArray[n] == typeArray2[n]) {
                    }
                    if (n < 0) {
                        return method;
                    }
                }
            }
            method = method.next;
        }
        return null;
    }

    public Method getDeclaredMethod(String string, int n) {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        Method method = null;
        Method method2 = this.methods;
        while (method2 != null) {
            if (string.equals(method2.getName()) && n == method2.getParameterTypes().length) {
                if (method != null) {
                    throw new Error("ambiguous call to getDeclaredMethod(\"" + string + "\", " + n + ")\n - " + method + "\n - " + method2);
                }
                method = method2;
            }
            method2 = method2.next;
        }
        return method;
    }

    public Method getMethod(String string, Type[] typeArray) {
        ClassType classType = this;
        do {
            Method method;
            if ((method = classType.getDeclaredMethod(string, typeArray)) == null) continue;
            return method;
        } while ((classType = classType.getSuperclass()) != null);
        return null;
    }

    public void addMethods(Class clazz) {
        Constructor<?>[] constructorArray;
        Type[] typeArray;
        java.lang.reflect.Method[] methodArray;
        this.flags |= 2;
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (SecurityException securityException) {
            methodArray = clazz.getMethods();
        }
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            java.lang.reflect.Method method = methodArray[i];
            if (!method.getDeclaringClass().equals(clazz) || ((n2 = method.getModifiers()) & 5) == 0) continue;
            Class<?>[] classArray = method.getParameterTypes();
            int n3 = classArray.length;
            Type[] typeArray2 = new Type[n3];
            while (--n3 >= 0) {
                typeArray2[n3] = Type.make(classArray[n3]);
            }
            typeArray = new Method(this, n2);
            typeArray.setName(method.getName());
            typeArray.arg_types = typeArray2;
            typeArray.return_type = Type.make(method.getReturnType());
        }
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (SecurityException securityException) {
            constructorArray = clazz.getConstructors();
        }
        n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            int n4;
            Constructor<?> constructor = constructorArray[i];
            if (!constructor.getDeclaringClass().equals(clazz) || ((n4 = constructor.getModifiers()) & 5) == 0) continue;
            Class<?>[] classArray = constructor.getParameterTypes();
            int n5 = classArray.length;
            typeArray = new Type[n5];
            while (--n5 >= 0) {
                typeArray[n5] = Type.make(classArray[n5]);
            }
            Method method = new Method(this, n4);
            method.setName("<init>");
            method.arg_types = typeArray;
            method.return_type = Type.void_type;
        }
    }

    public Method[] getMatchingMethods(String string, Type[] typeArray, int n) {
        Object object2;
        int n2 = this.getMethodCount();
        int n3 = 0;
        Vector<Object[]> vector = new Vector<Object[]>(10);
        for (object2 = this.methods; object2 != null; object2 = object2.getNext()) {
            Type[] typeArray2;
            if (!string.equals(object2.getName()) || (n & 8) != (object2.access_flags & 8) || (n & 1) > (object2.access_flags & 1) || (typeArray2 = object2.arg_types).length != typeArray.length) continue;
            ++n3;
            vector.addElement((Object[])object2);
        }
        object2 = new Method[n3];
        vector.copyInto((Object[])object2);
        return object2;
    }

    public void doFixups() {
        if (this.constants == null) {
            this.constants = new ConstantPool();
        }
        if (this.thisClassIndex == 0) {
            this.thisClassIndex = this.constants.addClass((ObjectType)this).index;
        }
        if (this.superClass == this) {
            this.setSuper((ClassType)null);
        }
        if (this.superClassIndex < 0) {
            int n = this.superClassIndex = this.superClass == null ? 0 : this.constants.addClass((ObjectType)this.superClass).index;
        }
        if (this.interfaces != null && this.interfaceIndexes == null) {
            int n = this.interfaces.length;
            this.interfaceIndexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.interfaceIndexes[i] = this.constants.addClass((ObjectType)this.interfaces[i]).index;
            }
        }
        AttrContainer attrContainer = this.fields;
        while (attrContainer != null) {
            ((Field)attrContainer).assign_constants(this);
            attrContainer = ((Field)attrContainer).next;
        }
        attrContainer = this.methods;
        while (attrContainer != null) {
            ((Method)attrContainer).assignConstants();
            attrContainer = ((Method)attrContainer).next;
        }
        Attribute.assignConstants(this, this);
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.doFixups();
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        if (this.constants == null) {
            dataOutputStream.writeShort(1);
        } else {
            this.constants.write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.thisClassIndex);
        dataOutputStream.writeShort(this.superClassIndex);
        if (this.interfaceIndexes == null) {
            dataOutputStream.writeShort(0);
        } else {
            int n = this.interfaceIndexes.length;
            dataOutputStream.writeShort(n);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeShort(this.interfaceIndexes[i]);
            }
        }
        dataOutputStream.writeShort(this.fields_count);
        AttrContainer attrContainer = this.fields;
        while (attrContainer != null) {
            ((Field)attrContainer).write(dataOutputStream, this);
            attrContainer = ((Field)attrContainer).next;
        }
        dataOutputStream.writeShort(this.methods_count);
        attrContainer = this.methods;
        while (attrContainer != null) {
            ((Method)attrContainer).write(dataOutputStream, this);
            attrContainer = ((Method)attrContainer).next;
        }
        Attribute.writeAll(this, dataOutputStream);
        this.flags |= 3;
    }

    public void writeToFile(String string) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        this.writeToStream(bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
    }

    public void writeToFile() throws IOException {
        this.writeToFile(this.this_name.replace('.', File.separatorChar) + ".class");
    }

    public byte[] writeToArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
        try {
            this.writeToStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] to_utf8(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n > 0 && n <= 127) {
                ++n3;
                continue;
            }
            if (n <= 2047) {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        byte[] byArray = new byte[n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
            byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return byArray;
    }

    public final boolean implementsInterface(ClassType classType) {
        if (this == classType) {
            return true;
        }
        ClassType classType2 = this.getSuperclass();
        if (classType2 != null && classType2.implementsInterface(classType)) {
            return true;
        }
        ClassType[] classTypeArray = this.getInterfaces();
        if (classTypeArray != null) {
            int n = classTypeArray.length;
            while (--n >= 0) {
                if (!classTypeArray[n].implementsInterface(classType)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isSubclass(ClassType classType) {
        if (classType.isInterface()) {
            return this.implementsInterface(classType);
        }
        if (this == tostring_type && classType == string_type || this == string_type && classType == tostring_type) {
            return true;
        }
        for (ClassType classType2 = this; classType2 != null; classType2 = classType2.getSuperclass()) {
            if (classType2 != classType) continue;
            return true;
        }
        return false;
    }

    public int compare(Type type) {
        if (type == nullType) {
            return 1;
        }
        if (type instanceof PrimType) {
            return ClassType.swappedCompareResult(((PrimType)type).compare(this));
        }
        if (type instanceof ArrayType) {
            return ClassType.swappedCompareResult(((ArrayType)type).compare(this));
        }
        if (!(type instanceof ClassType)) {
            return -3;
        }
        String string = this.getName();
        if (string != null && string.equals(type.getName())) {
            return 0;
        }
        ClassType classType = (ClassType)type;
        if (this.isSubclass(classType)) {
            return -1;
        }
        if (classType.isSubclass(this)) {
            return 1;
        }
        if (this == tostring_type) {
            return 1;
        }
        if (classType == tostring_type) {
            return -1;
        }
        if (this.isInterface() || classType.isInterface()) {
            return -2;
        }
        return -3;
    }

    public String toString() {
        return "ClassType " + this.getName();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = this.getName();
        Type type = ClassType.lookupType(string);
        if (type != this) {
            throw new IOException("serializing ClassType not in class table not implemented");
        }
        objectOutput.writeUTF(string);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName(objectInput.readUTF());
        this.flags |= 4;
    }

    public Object readResolve() throws ObjectStreamException {
        String string = this.getName();
        Type type = ClassType.lookupType(string);
        if (type != null) {
            return type;
        }
        mapNameToType.put(string, this);
        return this;
    }
}

