/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.SubSequence;
import java.io.IOException;
import java.util.List;

public class SubCharSeq
extends SubSequence
implements CharSeq {
    public SubCharSeq(AbstractSequence base, int startPos, int endPos) {
        super(base, startPos, endPos);
    }

    public int length() {
        return this.size();
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int start = this.base.nextIndex(this.ipos0);
        return ((CharSeq)((Object)this.base)).charAt(start + index);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        for (int i = srcBegin; i < srcEnd; ++i) {
            dst[dstBegin++] = this.charAt(i);
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int start = this.base.nextIndex(this.ipos0);
        ((CharSeq)((Object)this.base)).setCharAt(start + index, ch);
    }

    public void fill(char value) {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        ((CharSeq)((Object)this.base)).fill(index0, index1, value);
    }

    public void fill(int fromIndex, int toIndex, char value) {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        if (fromIndex < 0 || toIndex < fromIndex || index0 + toIndex > index1) {
            throw new IndexOutOfBoundsException();
        }
        ((CharSeq)((Object)this.base)).fill(index0 + fromIndex, index0 + toIndex, value);
    }

    public void writeTo(int start, int count, Appendable dest) throws IOException {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        if (start < 0 || count < 0 || index0 + start + count > index1) {
            throw new IndexOutOfBoundsException();
        }
        ((CharSeq)((Object)this.base)).writeTo(index0 + start, count, dest);
    }

    public void writeTo(Appendable dest) throws IOException {
        int index0 = this.base.nextIndex(this.ipos0);
        ((CharSeq)((Object)this.base)).writeTo(index0, this.size(), dest);
    }

    public void consume(int start, int count, Consumer out) {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        if (start < 0 || count < 0 || index0 + start + count > index1) {
            throw new IndexOutOfBoundsException();
        }
        ((CharSeq)((Object)this.base)).consume(index0 + start, count, out);
    }

    public String toString() {
        int sz = this.size();
        StringBuffer sbuf = new StringBuffer(sz);
        for (int i = 0; i < sz; ++i) {
            sbuf.append(this.charAt(i));
        }
        return sbuf.toString();
    }

    private SubCharSeq subCharSeq(int start, int end) {
        int sz = this.size();
        if (start < 0 || end < start || end > sz) {
            throw new IndexOutOfBoundsException();
        }
        return new SubCharSeq(this.base, this.base.createRelativePos(this.ipos0, start, false), this.base.createRelativePos(this.ipos0, end, true));
    }

    public List subList(int fromIx, int toIx) {
        return this.subCharSeq(fromIx, toIx);
    }

    public CharSequence subSequence(int start, int end) {
        return this.subCharSeq(start, end);
    }
}

