/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.lists.Consumable;
import gnu.lists.FilterConsumer;
import gnu.lists.UnescapedData;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.xml.XMLPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class HttpPrinter
extends FilterConsumer {
    Vector headers = new Vector();
    StringBuilder sbuf = new StringBuilder(100);
    Object currentHeader;
    private int seenStartDocument;
    protected String sawContentType;
    private int elementNesting;
    protected OutputStream ostream;
    OutPort writer;
    boolean seenXmlHeader;

    public HttpPrinter(OutputStream out) {
        super(null);
        this.ostream = out;
    }

    public HttpPrinter(OutPort out) {
        super(null);
        this.writer = out;
    }

    public static HttpPrinter make(OutPort out) {
        return new HttpPrinter(out);
    }

    private void writeRaw(String str) throws IOException {
        if (this.writer != null) {
            this.writer.write(str);
        } else {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                this.ostream.write((byte)str.charAt(i));
            }
        }
    }

    @Override
    protected void beforeNode() {
        if (this.sawContentType == null) {
            this.addHeader("Content-type", "text/xml");
        }
        this.beginData();
    }

    public void printHeader(String label, String value) throws IOException {
        this.writeRaw(label);
        this.writeRaw(": ");
        this.writeRaw(value);
        this.writeRaw("\n");
    }

    public void printHeaders() throws IOException {
        int num = this.headers.size();
        for (int i = 0; i < num; i += 2) {
            this.printHeader(this.headers.elementAt(i).toString(), this.headers.elementAt(i + 1).toString());
        }
        this.writeRaw("\n");
    }

    public void addHeader(String label, String value) {
        if (label.equalsIgnoreCase("Content-type")) {
            this.sawContentType = value;
        }
        this.headers.addElement(label);
        this.headers.addElement(value);
    }

    @Override
    public void startAttribute(Object attrType) {
        if (this.base == null) {
            this.currentHeader = attrType;
        } else {
            this.base.startAttribute(attrType);
        }
    }

    @Override
    public void endAttribute() {
        if (this.currentHeader != null) {
            this.addHeader(this.currentHeader.toString(), this.sbuf.toString());
            this.sbuf.setLength(0);
            this.currentHeader = null;
        } else {
            this.base.endAttribute();
        }
    }

    public void beginData() {
        if (this.base == null) {
            if (this.sawContentType == null) {
                this.addHeader("Content-type", "text/plain");
            }
            if (this.writer == null) {
                this.writer = new OutPort(this.ostream);
            }
            String style = null;
            if ("text/html".equalsIgnoreCase(this.sawContentType)) {
                style = "html";
            } else if ("application/xhtml+xml".equalsIgnoreCase(this.sawContentType)) {
                style = "xhtml";
            } else if ("text/plain".equalsIgnoreCase(this.sawContentType)) {
                style = "plain";
            }
            this.base = XMLPrinter.make(this.writer, style);
            if (this.seenStartDocument == 0) {
                this.base.startDocument();
                this.seenStartDocument = 1;
            }
            try {
                this.printHeaders();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex.toString());
            }
        }
        this.append(this.sbuf);
        this.sbuf.setLength(0);
    }

    @Override
    public void startElement(Object type) {
        if (this.sawContentType == null) {
            String mimeType = !this.seenXmlHeader ? "text/html" : (type instanceof Symbol && "html".equals(((Symbol)type).getLocalPart()) ? "text/xhtml" : "text/xml");
            this.addHeader("Content-type", mimeType);
        }
        this.beginData();
        this.base.startElement(type);
        ++this.elementNesting;
    }

    @Override
    public void endElement() {
        super.endElement();
        --this.elementNesting;
        if (this.elementNesting == 0 && this.seenStartDocument == 1) {
            this.endDocument();
        }
    }

    @Override
    public void writeObject(Object v) {
        if (v instanceof Consumable && !(v instanceof UnescapedData)) {
            ((Consumable)v).consume(this);
        } else {
            this.beginData();
            super.writeObject(v);
        }
    }

    @Override
    public void write(CharSequence str, int start, int length) {
        if (this.base == null) {
            this.sbuf.append(str, start, start + length);
        } else {
            this.base.write(str, start, length);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.base == null) {
            this.sbuf.append(buf, off, len);
        } else {
            this.base.write(buf, off, len);
        }
    }

    @Override
    public void startDocument() {
        if (this.base != null) {
            this.base.startDocument();
        }
        this.seenStartDocument = 2;
    }

    @Override
    public void endDocument() {
        if (this.base != null) {
            this.base.endDocument();
        }
        try {
            if (this.sawContentType == null) {
                this.addHeader("Content-type", "text/plain");
            }
            if (this.sbuf.length() > 0) {
                String str = this.sbuf.toString();
                this.sbuf.setLength(0);
                if (this.writer != null) {
                    this.writer.write(str);
                } else {
                    this.ostream.write(str.getBytes());
                }
            }
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.ostream != null) {
                this.ostream.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean reset(boolean headersAlso) {
        if (headersAlso) {
            this.headers.clear();
            this.sawContentType = null;
            this.currentHeader = null;
            this.elementNesting = 0;
        }
        this.sbuf.setLength(0);
        this.base = null;
        boolean ok = true;
        if (this.ostream != null) {
            ok = this.writer == null;
            this.writer = null;
        }
        return ok;
    }
}

