/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.InputStreamHandler;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.ProcessMode;
import gnu.mapping.WrappedException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import kawa.Telnet;

public class TelnetMode
extends ProcessMode {
    public TelnetMode(Buffer buffer, String host) {
        this(buffer, host, 23);
    }

    public TelnetMode(Buffer buffer, String host, int port) {
        Telnet telnet;
        this.buffer = buffer;
        this.processMark = new Marker(buffer.pointMarker);
        try {
            Socket socket = new Socket(host, port);
            telnet = new Telnet(socket, false);
            telnet.request(253, 3);
            telnet.request(251, 3);
            telnet.request(253, 1);
        }
        catch (Exception ex) {
            throw new WrappedException("telnet - creating socket failed", ex);
        }
        this.toInferior = new OutputStreamWriter(telnet.getOutputStream());
        InputStreamHandler t = new InputStreamHandler(telnet.getInputStream(), this);
        t.setPriority(Thread.currentThread().getPriority() + 1);
        t.start();
    }

    public static void telnetMode(Buffer buffer, String host, int port) {
        buffer.modes = new TelnetMode(buffer, host, port);
    }
}

