%define buildglade %(pkg-config libglade-2.0 && echo 1 || echo 0)

Summary: Python bindings for the GTK+ widget set.
Name: pygtk2
Version: 1.99.4
Release: 1
Copyright: LGPL
Group: Development/Languages
Source: ftp://ftp.gtk.org/pub/gtk/python/pygtk-%{version}.tar.gz
BuildRoot: /var/tmp/pygtk-root
Packager: James Henstridge <james@daa.com.au>
Requires: gtk2 >= 1.3.9
Requires: python2 >= 2.2
Buildrequires: python2-devel >= 2.2

%description
PyGTK is an extension module for python that gives you access to the GTK+
widget set.  Just about anything you can write in C with GTK+ you can write
in python with PyGTK (within reason), but with all the benefits of python.

%package libglade
Summary: A wrapper for the libglade library for use with PyGTK
Group: Development/Languages
Requires: pygtk2 = %{version}

%description libglade
This module contains a wrapper for the libglade library.  Libglade allows
a program to construct its user interface from an XML description, which
allows the programmer to keep the UI and program logic separate.

%package devel
Summary: files needed to build wrappers for GTK+ addon libraries
Group: Development/Languages
Requires: pygtk2 = %{version}

%description devel
This package contains files required to build wrappers for GTK+ addon
libraries so that they interoperate with pygtk.

%changelog
* Thu Oct 18 2001 Matt Wilson <msw@redhat.com>
- fix devel filelist to match new header location

* Mon Oct 15 2001 Matt Wilson <msw@redhat.com>
- get the headers from their new version-specific location

* Thu Oct 11 2001 Matt Wilson <msw@redhat.com>
- fixed typo in devel filelist
- added macro that tests to see if we have libglade2, make the
  filelist a condition of that
- changed name to 'pygtk2' to avoid name conflict with pygtk

%prep
%setup -q -n pygtk-%{version}
[ -x /usr/bin/python2.2 ] && export PYTHON=/usr/bin/python2.2
./configure --prefix=%{_prefix}

%build
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%files
%defattr(644, root, root, 755)
%dir %{_prefix}/lib/python?.?/site-packages/gtk
%{_prefix}/lib/python?.?/site-packages/gtk/__init__.py*
%{_prefix}/lib/python?.?/site-packages/gtk/keysyms.py*

%defattr(755, root, root, 755)
%{_prefix}/lib/python?.?/site-packages/gobjectmodule.so
%{_prefix}/lib/python?.?/site-packages/pangomodule.so
%{_prefix}/lib/python?.?/site-packages/gtk/_gtkmodule.so

%doc AUTHORS NEWS README MAPPING ChangeLog description.py
%doc examples

%if %{buildglade}
%files libglade
%defattr(755, root, root, 755)
%{_prefix}/lib/python?.?/site-packages/gtk/glademodule.so
%endif

%files devel
%defattr(755, root, root, 755)
%{_prefix}/bin/pygtk-codegen-2.0
%defattr(644, root, root, 755)
%dir %{_prefix}/include/pygtk-2.0
%{_prefix}/include/pygtk-2.0/*.h
%dir %{_prefix}/include/pygtk-2.0/pygtk
%{_prefix}/include/pygtk-2.0/pygtk/*.h
%{_prefix}/lib/pkgconfig/pygtk-2.0.pc
%dir %{_prefix}/share/pygtk
%dir %{_prefix}/share/pygtk/2.0
%dir %{_prefix}/share/pygtk/2.0/codegen
%dir %{_prefix}/share/pygtk/2.0/defs
%{_prefix}/share/pygtk/2.0/codegen/*
%{_prefix}/share/pygtk/2.0/defs/pango.defs
%{_prefix}/share/pygtk/2.0/defs/pango-types.defs
%{_prefix}/share/pygtk/2.0/defs/gdk.defs
%{_prefix}/share/pygtk/2.0/defs/gdk-types.defs
%{_prefix}/share/pygtk/2.0/defs/gtk.defs
%{_prefix}/share/pygtk/2.0/defs/gtk-types.defs
%{_prefix}/share/pygtk/2.0/defs/gtk-extrafuncs.defs
%{_prefix}/share/pygtk/2.0/defs/libglade.defs
