/* SettingsDialog.c generated by valac 0.10.4, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;
typedef struct _moserialSettingsDialogPrivate moserialSettingsDialogPrivate;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSettingsDialog {
	GObject parent_instance;
	moserialSettingsDialogPrivate * priv;
};

struct _moserialSettingsDialogClass {
	GObjectClass parent_class;
};

struct _moserialSettingsDialogPrivate {
	GtkBuilder* _builder;
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBoxEntry* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
	GtkListStore* ls;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_settings_dialog_parent_class = NULL;

GType moserial_settings_dialog_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogPrivate))
enum  {
	MOSERIAL_SETTINGS_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_SETTINGS_DIALOG_BUILDER
};
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder);
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
static void _g_list_free_g_free (GList* self);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self);
const char* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_parity_get_type (void) G_GNUC_CONST;
SettingsParity settings_get_parity (Settings* self);
GType settings_access_mode_get_type (void) G_GNUC_CONST;
SettingsAccessMode settings_get_accessMode (Settings* self);
GType settings_handshake_get_type (void) G_GNUC_CONST;
SettingsHandshake settings_get_handshake (Settings* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self, GtkWidget* w, GdkEvent* event);
void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w);
void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w);
Settings* settings_new (const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const char* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self);
static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_settings_dialog_finalize (GObject* obj);
static void moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder) {
	moserialSettingsDialog * self = NULL;
	g_return_val_if_fail (builder != NULL, NULL);
	self = (moserialSettingsDialog*) g_object_new (object_type, "builder", builder, NULL);
	return self;
}


moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder) {
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG, builder);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self) {
	GList* deviceTypes;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	deviceTypes = NULL;
	deviceTypes = g_list_append (deviceTypes, g_strdup ("/dev/ttyS"));
	deviceTypes = g_list_append (deviceTypes, g_strdup ("/dev/ttyUSB"));
	deviceTypes = g_list_append (deviceTypes, g_strdup ("/dev/rfcomm"));
	gtk_list_store_clear (self->priv->ls);
	{
		GList* devType_collection;
		GList* devType_it;
		devType_collection = deviceTypes;
		for (devType_it = devType_collection; devType_it != NULL; devType_it = devType_it->next) {
			char* devType;
			devType = g_strdup ((const char*) devType_it->data);
			{
				{
					gint i;
					i = 0;
					{
						gboolean _tmp0_;
						_tmp0_ = TRUE;
						while (TRUE) {
							char* dev;
							if (!_tmp0_) {
								i++;
							}
							_tmp0_ = FALSE;
							if (!(i < MOSERIAL_SETTINGS_DIALOG_max_devices)) {
								break;
							}
							dev = g_strdup_printf ("%s%d", devType, i);
							if (g_file_test (dev, G_FILE_TEST_EXISTS)) {
								gtk_list_store_append (self->priv->ls, &iter);
								gtk_list_store_set (self->priv->ls, &iter, 0, "", 1, dev, -1, -1);
							}
							_g_free0 (dev);
						}
					}
				}
				_g_free0 (devType);
			}
		}
	}
	__g_list_free_g_free0 (deviceTypes);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings) {
	Settings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	moserial_settings_dialog_populateDevices (self);
	self->priv->currentSettings = (_tmp0_ = _g_object_ref0 (settings), _g_object_unref0 (self->priv->currentSettings), _tmp0_);
	moserial_settings_dialog_loadSettings (self);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self) {
	GtkTreeModel* t;
	GtkTreeIter ti = {0};
	gboolean success = FALSE;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp8_;
	GtkTreeModel* _tmp13_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	t = NULL;
	t = (_tmp0_ = _g_object_ref0 (gtk_combo_box_get_model ((GtkComboBox*) self->priv->deviceCombo)), _g_object_unref0 (t), _tmp0_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp1_ = {0};
		GValue _tmp2_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 1, &_tmp1_);
		str_data = (_tmp2_ = _tmp1_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp2_);
		if (_vala_strcmp0 (g_value_get_string (&str_data), settings_get_device (self->priv->currentSettings)) == 0) {
			gtk_combo_box_set_active_iter ((GtkComboBox*) self->priv->deviceCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	t = (_tmp3_ = _g_object_ref0 (gtk_combo_box_get_model (self->priv->baudRateCombo)), _g_object_unref0 (t), _tmp3_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp4_ = {0};
		GValue _tmp5_;
		char* _tmp6_;
		gboolean _tmp7_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp4_);
		str_data = (_tmp5_ = _tmp4_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp5_);
		if ((_tmp7_ = _vala_strcmp0 (g_value_get_string (&str_data), _tmp6_ = g_strdup_printf ("%i", settings_get_baudRate (self->priv->currentSettings))) == 0, _g_free0 (_tmp6_), _tmp7_)) {
			gtk_combo_box_set_active_iter (self->priv->baudRateCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	t = (_tmp8_ = _g_object_ref0 (gtk_combo_box_get_model (self->priv->dataBitsCombo)), _g_object_unref0 (t), _tmp8_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp9_ = {0};
		GValue _tmp10_;
		char* _tmp11_;
		gboolean _tmp12_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp9_);
		str_data = (_tmp10_ = _tmp9_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp10_);
		if ((_tmp12_ = _vala_strcmp0 (g_value_get_string (&str_data), _tmp11_ = g_strdup_printf ("%i", settings_get_dataBits (self->priv->currentSettings))) == 0, _g_free0 (_tmp11_), _tmp12_)) {
			gtk_combo_box_set_active_iter (self->priv->dataBitsCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	t = (_tmp13_ = _g_object_ref0 (gtk_combo_box_get_model (self->priv->stopBitsCombo)), _g_object_unref0 (t), _tmp13_);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp14_ = {0};
		GValue _tmp15_;
		char* _tmp16_;
		gboolean _tmp17_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp14_);
		str_data = (_tmp15_ = _tmp14_, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp15_);
		if ((_tmp17_ = _vala_strcmp0 (g_value_get_string (&str_data), _tmp16_ = g_strdup_printf ("%i", settings_get_stopBits (self->priv->currentSettings))) == 0, _g_free0 (_tmp16_), _tmp17_)) {
			gtk_combo_box_set_active_iter (self->priv->stopBitsCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	gtk_combo_box_set_active (self->priv->parityCombo, (gint) settings_get_parity (self->priv->currentSettings));
	gtk_combo_box_set_active (self->priv->accessModeCombo, (gint) settings_get_accessMode (self->priv->currentSettings));
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, FALSE);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, FALSE);
	if (settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_BOTH) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_HARDWARE;
	}
	if (_tmp18_) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, TRUE);
	}
	if (settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_BOTH) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	if (_tmp19_) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, TRUE);
	}
	if (settings_get_localEcho (self->priv->currentSettings)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, FALSE);
	}
	_g_object_unref0 (t);
}


gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self, GtkWidget* w, GdkEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	result = TRUE;
	return result;
}


void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w) {
	Settings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	self->priv->currentSettings = (_tmp0_ = NULL, _g_object_unref0 (self->priv->currentSettings), _tmp0_);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
}


void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w) {
	char* device;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean pLocalEcho = FALSE;
	char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Settings* _tmp2_;
	Settings* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	device = NULL;
	device = (_tmp0_ = g_strdup (gtk_combo_box_get_active_text ((GtkComboBox*) self->priv->deviceCombo)), _g_free0 (device), _tmp0_);
	baudRate = atoi (gtk_combo_box_get_active_text (self->priv->baudRateCombo));
	dataBits = atoi (gtk_combo_box_get_active_text (self->priv->dataBitsCombo));
	stopBits = atoi (gtk_combo_box_get_active_text (self->priv->stopBitsCombo));
	parity = (SettingsParity) gtk_combo_box_get_active (self->priv->parityCombo);
	accessMode = (SettingsAccessMode) gtk_combo_box_get_active (self->priv->accessModeCombo);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake)) {
		_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake)) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake)) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	pLocalEcho = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->localEcho);
	self->priv->settings = (_tmp2_ = settings_new (device, baudRate, dataBits, stopBits, parity, handshake, accessMode, pLocalEcho), _g_object_unref0 (self->priv->settings), _tmp2_);
	self->priv->currentSettings = (_tmp3_ = _g_object_ref0 (self->priv->settings), _g_object_unref0 (self->priv->currentSettings), _tmp3_);
	g_signal_emit_by_name (self, "update-settings", self->priv->currentSettings);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	_g_free0 (device);
}


GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_builder = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_builder), _tmp0_);
	g_object_notify ((GObject *) self, "builder");
}


static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = moserial_settings_dialog_hide (self, _sender, event);
	return result;
}


static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_cancel (self, _sender);
}


static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_ok (self, _sender);
}


static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSettingsDialog * self;
	parent_class = G_OBJECT_CLASS (moserial_settings_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	{
		GtkDialog* _tmp0_;
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		GtkComboBox* _tmp3_;
		GtkComboBox* _tmp4_;
		GtkComboBox* _tmp5_;
		GtkComboBox* _tmp6_;
		GtkCheckButton* _tmp7_;
		GtkCheckButton* _tmp8_;
		GtkComboBox* _tmp9_;
		GtkCheckButton* _tmp10_;
		GtkListStore* _tmp11_;
		GtkComboBoxEntry* _tmp12_;
		self->priv->dialog = (_tmp0_ = _g_object_ref0 (GTK_DIALOG (gtk_builder_get_object (self->priv->_builder, "settings_dialog"))), _g_object_unref0 (self->priv->dialog), _tmp0_);
		self->priv->cancelButton = (_tmp1_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_cancel_button"))), _g_object_unref0 (self->priv->cancelButton), _tmp1_);
		self->priv->okButton = (_tmp2_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_ok_button"))), _g_object_unref0 (self->priv->okButton), _tmp2_);
		self->priv->baudRateCombo = (_tmp3_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_baud_rate"))), _g_object_unref0 (self->priv->baudRateCombo), _tmp3_);
		self->priv->dataBitsCombo = (_tmp4_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_data_bits"))), _g_object_unref0 (self->priv->dataBitsCombo), _tmp4_);
		self->priv->stopBitsCombo = (_tmp5_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_stop_bits"))), _g_object_unref0 (self->priv->stopBitsCombo), _tmp5_);
		self->priv->parityCombo = (_tmp6_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_parity"))), _g_object_unref0 (self->priv->parityCombo), _tmp6_);
		self->priv->hardwareHandshake = (_tmp7_ = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_hardware_handshake"))), _g_object_unref0 (self->priv->hardwareHandshake), _tmp7_);
		self->priv->softwareHandshake = (_tmp8_ = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_software_handshake"))), _g_object_unref0 (self->priv->softwareHandshake), _tmp8_);
		self->priv->accessModeCombo = (_tmp9_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_open_for"))), _g_object_unref0 (self->priv->accessModeCombo), _tmp9_);
		self->priv->localEcho = (_tmp10_ = _g_object_ref0 (GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_local_echo"))), _g_object_unref0 (self->priv->localEcho), _tmp10_);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
		g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->okButton, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
		self->priv->ls = (_tmp11_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING), _g_object_unref0 (self->priv->ls), _tmp11_);
		self->priv->deviceCombo = (_tmp12_ = _g_object_ref0 (GTK_COMBO_BOX_ENTRY (gtk_builder_get_object (self->priv->_builder, "settings_device"))), _g_object_unref0 (self->priv->deviceCombo), _tmp12_);
		gtk_combo_box_set_model ((GtkComboBox*) self->priv->deviceCombo, (GtkTreeModel*) self->priv->ls);
		gtk_combo_box_entry_set_text_column (self->priv->deviceCombo, 1);
	}
	return obj;
}


static void moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass) {
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_settings_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_settings_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_settings_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SETTINGS_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("update_settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}


static void moserial_settings_dialog_instance_init (moserialSettingsDialog * self) {
	self->priv = MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE (self);
}


static void moserial_settings_dialog_finalize (GObject* obj) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	_g_object_unref0 (self->priv->_builder);
	_g_object_unref0 (self->priv->currentSettings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancelButton);
	_g_object_unref0 (self->priv->okButton);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->deviceCombo);
	_g_object_unref0 (self->priv->baudRateCombo);
	_g_object_unref0 (self->priv->dataBitsCombo);
	_g_object_unref0 (self->priv->stopBitsCombo);
	_g_object_unref0 (self->priv->parityCombo);
	_g_object_unref0 (self->priv->hardwareHandshake);
	_g_object_unref0 (self->priv->softwareHandshake);
	_g_object_unref0 (self->priv->accessModeCombo);
	_g_object_unref0 (self->priv->localEcho);
	_g_object_unref0 (self->priv->ls);
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}


GType moserial_settings_dialog_get_type (void) {
	static volatile gsize moserial_settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_settings_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
		GType moserial_settings_dialog_type_id;
		moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
		g_once_init_leave (&moserial_settings_dialog_type_id__volatile, moserial_settings_dialog_type_id);
	}
	return moserial_settings_dialog_type_id__volatile;
}


static void moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		g_value_set_object (value, moserial_settings_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		moserial_settings_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




