/* RecordDialog.c generated by valac 0.10.4, the Vala compiler
 * generated from RecordDialog.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_RECORD_DIALOG (moserial_record_dialog_get_type ())
#define MOSERIAL_RECORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialog))
#define MOSERIAL_RECORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogClass))
#define MOSERIAL_IS_RECORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RECORD_DIALOG))
#define MOSERIAL_IS_RECORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RECORD_DIALOG))
#define MOSERIAL_RECORD_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogClass))

typedef struct _moserialRecordDialog moserialRecordDialog;
typedef struct _moserialRecordDialogClass moserialRecordDialogClass;
typedef struct _moserialRecordDialogPrivate moserialRecordDialogPrivate;

#define MOSERIAL_SERIAL_STREAM_RECORDER_TYPE_DIRECTION (moserial_serial_stream_recorder_direction_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL
} moserialSerialStreamRecorderDirection;

struct _moserialRecordDialog {
	GObject parent_instance;
	moserialRecordDialogPrivate * priv;
	moserialSerialStreamRecorderDirection direction;
};

struct _moserialRecordDialogClass {
	GObjectClass parent_class;
};

struct _moserialRecordDialogPrivate {
	GtkBuilder* _builder;
	GtkFileChooserDialog* dialog;
	GtkButton* cancelButton;
	GtkComboBox* streamCombo;
	char* _fileName;
};


static gpointer moserial_record_dialog_parent_class = NULL;

GType moserial_record_dialog_get_type (void) G_GNUC_CONST;
GType moserial_serial_stream_recorder_direction_get_type (void) G_GNUC_CONST;
#define MOSERIAL_RECORD_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogPrivate))
enum  {
	MOSERIAL_RECORD_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_RECORD_DIALOG_BUILDER,
	MOSERIAL_RECORD_DIALOG_FILE_NAME
};
moserialRecordDialog* moserial_record_dialog_new (GtkBuilder* builder);
moserialRecordDialog* moserial_record_dialog_construct (GType object_type, GtkBuilder* builder);
void moserial_record_dialog_show (moserialRecordDialog* self, const char* folder);
gboolean mo_utils_fileExists (const char* path);
gboolean moserial_record_dialog_hide (moserialRecordDialog* self);
static void moserial_record_dialog_response (moserialRecordDialog* self, GtkWidget* w, gint r);
static void moserial_record_dialog_set_fileName (moserialRecordDialog* self, const char* value);
const char* moserial_record_dialog_get_fileName (moserialRecordDialog* self);
GtkBuilder* moserial_record_dialog_get_builder (moserialRecordDialog* self);
static void moserial_record_dialog_set_builder (moserialRecordDialog* self, GtkBuilder* value);
static gboolean _moserial_record_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void _moserial_record_dialog_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static GObject * moserial_record_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_record_dialog_finalize (GObject* obj);
static void moserial_record_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void moserial_record_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

moserialRecordDialog* moserial_record_dialog_construct (GType object_type, GtkBuilder* builder) {
	moserialRecordDialog * self = NULL;
	g_return_val_if_fail (builder != NULL, NULL);
	self = (moserialRecordDialog*) g_object_new (object_type, "builder", builder, NULL);
	return self;
}


moserialRecordDialog* moserial_record_dialog_new (GtkBuilder* builder) {
	return moserial_record_dialog_construct (MOSERIAL_TYPE_RECORD_DIALOG, builder);
}


void moserial_record_dialog_show (moserialRecordDialog* self, const char* folder) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (folder != NULL) {
		_tmp0_ = mo_utils_fileExists (folder);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) self->priv->dialog, folder);
	}
	gtk_dialog_run ((GtkDialog*) self->priv->dialog);
}


gboolean moserial_record_dialog_hide (moserialRecordDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	result = TRUE;
	return result;
}


static void moserial_record_dialog_response (moserialRecordDialog* self, GtkWidget* w, gint r) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	if (r == GTK_RESPONSE_CANCEL) {
		moserial_record_dialog_set_fileName (self, NULL);
		moserial_record_dialog_hide (self);
		g_signal_emit_by_name (self, "stop-recording");
	} else {
		if (r == GTK_RESPONSE_ACCEPT) {
			char* _tmp0_;
			moserial_record_dialog_set_fileName (self, _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->dialog));
			_g_free0 (_tmp0_);
			switch (gtk_combo_box_get_active (self->priv->streamCombo)) {
				default:
				{
					self->direction = MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING;
					break;
				}
				case 1:
				{
					self->direction = MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING;
					break;
				}
				case 2:
				{
					self->direction = MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
					break;
				}
			}
			moserial_record_dialog_hide (self);
			g_signal_emit_by_name (self, "start-recording", self->priv->_fileName, self->direction);
		} else {
			g_signal_emit_by_name (self, "stop-recording");
		}
	}
}


GtkBuilder* moserial_record_dialog_get_builder (moserialRecordDialog* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_record_dialog_set_builder (moserialRecordDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_builder = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_builder), _tmp0_);
	g_object_notify ((GObject *) self, "builder");
}


const char* moserial_record_dialog_get_fileName (moserialRecordDialog* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_fileName;
	return result;
}


static void moserial_record_dialog_set_fileName (moserialRecordDialog* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_fileName = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_fileName), _tmp0_);
	g_object_notify ((GObject *) self, "fileName");
}


static gboolean _moserial_record_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = moserial_record_dialog_hide (self);
	return result;
}


static void _moserial_record_dialog_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	moserial_record_dialog_response (self, _sender, response_id);
}


static GObject * moserial_record_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialRecordDialog * self;
	parent_class = G_OBJECT_CLASS (moserial_record_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_RECORD_DIALOG (obj);
	{
		GtkFileChooserDialog* _tmp0_;
		GtkButton* _tmp1_;
		GtkComboBox* _tmp2_;
		self->priv->dialog = (_tmp0_ = _g_object_ref0 (GTK_FILE_CHOOSER_DIALOG (gtk_builder_get_object (self->priv->_builder, "record_dialog"))), _g_object_unref0 (self->priv->dialog), _tmp0_);
		self->priv->cancelButton = (_tmp1_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "record_cancel"))), _g_object_unref0 (self->priv->cancelButton), _tmp1_);
		self->priv->streamCombo = (_tmp2_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "record_stream"))), _g_object_unref0 (self->priv->streamCombo), _tmp2_);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_record_dialog_hide_gtk_widget_delete_event, self, 0);
		g_signal_connect_object ((GtkDialog*) self->priv->dialog, "response", (GCallback) _moserial_record_dialog_response_gtk_dialog_response, self, 0);
		gtk_dialog_add_buttons ((GtkDialog*) self->priv->dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
		gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) self->priv->dialog, TRUE);
		gtk_file_chooser_set_local_only ((GtkFileChooser*) self->priv->dialog, FALSE);
		gtk_combo_box_set_active (self->priv->streamCombo, 0);
		moserial_record_dialog_set_fileName (self, NULL);
	}
	return obj;
}


static void moserial_record_dialog_class_init (moserialRecordDialogClass * klass) {
	moserial_record_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialRecordDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_record_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_record_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_record_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_record_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RECORD_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RECORD_DIALOG_FILE_NAME, g_param_spec_string ("fileName", "fileName", "fileName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("start_recording", MOSERIAL_TYPE_RECORD_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_ENUM, G_TYPE_NONE, 2, G_TYPE_STRING, MOSERIAL_SERIAL_STREAM_RECORDER_TYPE_DIRECTION);
	g_signal_new ("stop_recording", MOSERIAL_TYPE_RECORD_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void moserial_record_dialog_instance_init (moserialRecordDialog * self) {
	self->priv = MOSERIAL_RECORD_DIALOG_GET_PRIVATE (self);
}


static void moserial_record_dialog_finalize (GObject* obj) {
	moserialRecordDialog * self;
	self = MOSERIAL_RECORD_DIALOG (obj);
	_g_object_unref0 (self->priv->_builder);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancelButton);
	_g_object_unref0 (self->priv->streamCombo);
	_g_free0 (self->priv->_fileName);
	G_OBJECT_CLASS (moserial_record_dialog_parent_class)->finalize (obj);
}


GType moserial_record_dialog_get_type (void) {
	static volatile gsize moserial_record_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_record_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialRecordDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_record_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialRecordDialog), 0, (GInstanceInitFunc) moserial_record_dialog_instance_init, NULL };
		GType moserial_record_dialog_type_id;
		moserial_record_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialRecordDialog", &g_define_type_info, 0);
		g_once_init_leave (&moserial_record_dialog_type_id__volatile, moserial_record_dialog_type_id);
	}
	return moserial_record_dialog_type_id__volatile;
}


static void moserial_record_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialRecordDialog * self;
	self = MOSERIAL_RECORD_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_RECORD_DIALOG_BUILDER:
		g_value_set_object (value, moserial_record_dialog_get_builder (self));
		break;
		case MOSERIAL_RECORD_DIALOG_FILE_NAME:
		g_value_set_string (value, moserial_record_dialog_get_fileName (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_record_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialRecordDialog * self;
	self = MOSERIAL_RECORD_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_RECORD_DIALOG_BUILDER:
		moserial_record_dialog_set_builder (self, g_value_get_object (value));
		break;
		case MOSERIAL_RECORD_DIALOG_FILE_NAME:
		moserial_record_dialog_set_fileName (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_ENUM) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_enum (param_values + 2), data2);
}



